/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001#\taAj\\1e%\u0016\u001cx.\u001e:dK*\u00111\u0001B\u0001\te\u0016\u001cx.\u001e:dK*\u0011QAB\u0001\u0007K:$\u0018\u000e^=\u000b\u0005\u001dA\u0011AB2p[6|gN\u0003\u0002\n\u0015\u00059Q.\u00198bO\u0016\u0014(BA\u0006\r\u0003\u0019a\u0017N\\6jg*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!\u0001\u0003*fg>,(oY3\t\u0011]\u0001!Q1A\u0005\u0002a\ta!\\3n_JLX#A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\t1{gn\u001a\u0005\tA\u0001\u0011\t\u0011)A\u00053\u00059Q.Z7pef\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u000b\u0007I\u0011A\u0012\u0002\u000b\r|'/Z:\u0016\u0003\u0011\u0002\"AG\u0013\n\u0005\u0019Z\"aA%oi\"A\u0001\u0006\u0001B\u0001B\u0003%A%\u0001\u0004d_J,7\u000f\t\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071jc\u0006\u0005\u0002\u0014\u0001!)q#\u000ba\u00013!)!%\u000ba\u0001I!)\u0001\u0007\u0001C\u0006c\u0005qAo\u001c'pC\u0012\u0014Vm]8ve\u000e,GC\u0001\u00173\u0011\u0015\u0019t\u00061\u0001\u0013\u0003\u0005\u0011\b\"B\u001b\u0001\t\u00031\u0014aA1eIR\u0011Af\u000e\u0005\u0006gQ\u0002\rA\u0005\u0005\u0006s\u0001!\tAO\u0001\u0006[&tWo\u001d\u000b\u0003YmBQa\r\u001dA\u0002IAQ!\u0010\u0001\u0005\u0002y\n!\"\\;mi&\u0004H.[3e)\tas\bC\u00034y\u0001\u0007!\u0003C\u0003>\u0001\u0011\u0005\u0011\t\u0006\u0002-\u0005\")1\t\u0011a\u0001\t\u0006!!/\u0019;f!\tQR)\u0003\u0002G7\t)a\t\\8bi\")\u0001\n\u0001C\u0001\u0013\u00061A-\u001b<jI\u0016$\"\u0001\f&\t\u000bM:\u0005\u0019\u0001\n\t\u000b!\u0003A\u0011\u0001'\u0015\u00051j\u0005\"B\"L\u0001\u0004!\u0003\"B(\u0001\t\u0003\u0001\u0016\u0001C7pe\u0016$\u0006.\u00198\u0015\u0005E#\u0006C\u0001\u000eS\u0013\t\u00196DA\u0004C_>dW-\u00198\t\u000bMr\u0005\u0019\u0001\n\t\u000bY\u0003A\u0011A,\u0002\u0011\r\f7/Z'pe\u0016$\"!\u0015-\t\u000bM*\u0006\u0019\u0001\n\t\u000bi\u0003A\u0011A.\u0002\u0011\u0015\fX/\u00197t)>$\"!\u0015/\t\u000bMJ\u0006\u0019\u0001\n\t\u000by\u0003A\u0011I0\u0002\u000f9|G\u000fT3tgR\u0011\u0011\u000b\u0019\u0005\u0006gu\u0003\rA\u0005\u0005\u0006E\u0002!\teY\u0001\u0007i>T5o\u001c8\u0016\u0003\u0011\u0004\"!\u001a5\u000f\u0005i1\u0017BA4\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011N\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d\\\u0002\"\u00027\u0001\t\u0003j\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0011\u0004")
public class LoadResource
extends Resource {
    private final long memory;
    private final int cores;

    public long memory() {
        return this.memory;
    }

    public int cores() {
        return this.cores;
    }

    private LoadResource toLoadResource(Resource r) {
        LoadResource loadResource;
        Resource resource = r;
        if (resource instanceof LoadResource) {
            LoadResource loadResource2;
            loadResource = loadResource2 = (LoadResource)resource;
        } else if (resource instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource;
            loadResource = new LoadResource(memoryResource.memory(), 0);
        } else if (resource instanceof CPUResource) {
            CPUResource cPUResource = (CPUResource)resource;
            loadResource = new LoadResource(0L, cPUResource.cores());
        } else {
            loadResource = new LoadResource(Long.MAX_VALUE, Integer.MAX_VALUE);
        }
        return loadResource;
    }

    @Override
    public LoadResource add(Resource r) {
        return new LoadResource(this.memory() + this.toLoadResource(r).memory(), this.cores() + this.toLoadResource(r).cores());
    }

    @Override
    public LoadResource minus(Resource r) {
        return new LoadResource(this.memory() - this.toLoadResource(r).memory(), this.cores() - this.toLoadResource(r).cores());
    }

    @Override
    public LoadResource multiplied(Resource r) {
        return new LoadResource(this.memory() * this.toLoadResource(r).memory(), this.cores() * this.toLoadResource(r).cores());
    }

    @Override
    public LoadResource multiplied(float rate) {
        return new LoadResource((long)((double)this.memory() * (double)rate), package$.MODULE$.round((float)this.cores() * rate));
    }

    @Override
    public LoadResource divide(Resource r) {
        return new LoadResource(this.memory() / this.toLoadResource(r).memory(), this.cores() / this.toLoadResource(r).cores());
    }

    @Override
    public LoadResource divide(int rate) {
        return new LoadResource(this.memory() / (long)rate, this.cores() / rate);
    }

    @Override
    public boolean moreThan(Resource r) {
        return this.memory() > this.toLoadResource(r).memory() && this.cores() > this.toLoadResource(r).cores();
    }

    @Override
    public boolean caseMore(Resource r) {
        return this.memory() > this.toLoadResource(r).memory() || this.cores() > this.toLoadResource(r).cores();
    }

    @Override
    public boolean equalsTo(Resource r) {
        return this.memory() == this.toLoadResource(r).memory() && this.cores() == this.toLoadResource(r).cores();
    }

    @Override
    public boolean notLess(Resource r) {
        return this.memory() >= this.toLoadResource(r).memory() && this.cores() >= this.toLoadResource(r).cores();
    }

    @Override
    public String toJson() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"memory\":\"", "\",\"cpu\":", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ByteTimeUtils.bytesToString((long)this.memory()), BoxesRunTime.boxToInteger((int)this.cores())}));
    }

    public String toString() {
        return this.toJson();
    }

    public LoadResource(long memory, int cores) {
        this.memory = memory;
        this.cores = cores;
    }
}

