/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001#\t!Bj\\1e\u0013:\u001cH/\u00198dKJ+7o\\;sG\u0016T!a\u0001\u0003\u0002\u0011I,7o\\;sG\u0016T!!\u0002\u0004\u0002\r\u0015tG/\u001b;z\u0015\t9\u0001\"\u0001\u0004d_6lwN\u001c\u0006\u0003\u0013)\tq!\\1oC\u001e,'O\u0003\u0002\f\u0019\u00051A.\u001b8lSNT!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u0005SKN|WO]2f\u0011!9\u0002A!b\u0001\n\u0003A\u0012AB7f[>\u0014\u00180F\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0011auN\\4\t\u0011\u0001\u0002!\u0011!Q\u0001\ne\tq!\\3n_JL\b\u0005\u0003\u0005#\u0001\t\u0015\r\u0011\"\u0001$\u0003\u0015\u0019wN]3t+\u0005!\u0003C\u0001\u000e&\u0013\t13DA\u0002J]RD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0007G>\u0014Xm\u001d\u0011\t\u0011)\u0002!Q1A\u0005\u0002\r\n\u0011\"\u001b8ti\u0006t7-Z:\t\u00111\u0002!\u0011!Q\u0001\n\u0011\n!\"\u001b8ti\u0006t7-Z:!\u0011\u0015q\u0003\u0001\"\u00010\u0003\u0019a\u0014N\\5u}Q!\u0001'\r\u001a4!\t\u0019\u0002\u0001C\u0003\u0018[\u0001\u0007\u0011\u0004C\u0003#[\u0001\u0007A\u0005C\u0003+[\u0001\u0007A\u0005C\u00036\u0001\u0011\ra'\u0001\fu_2{\u0017\rZ%ogR\fgnY3SKN|WO]2f)\t\u0001t\u0007C\u00039i\u0001\u0007!#A\u0001s\u0011\u0015Q\u0004\u0001\"\u0001<\u0003\r\tG\r\u001a\u000b\u0003aqBQ\u0001O\u001dA\u0002IAQA\u0010\u0001\u0005\u0002}\nQ!\\5okN$\"\u0001\r!\t\u000baj\u0004\u0019\u0001\n\t\u000b\t\u0003A\u0011A\"\u0002\u00155,H\u000e^5qY&,G\r\u0006\u00021\t\")\u0001(\u0011a\u0001%!)!\t\u0001C\u0001\rR\u0011\u0001g\u0012\u0005\u0006\u0011\u0016\u0003\r!S\u0001\u0005e\u0006$X\r\u0005\u0002\u001b\u0015&\u00111j\u0007\u0002\u0006\r2|\u0017\r\u001e\u0005\u0006\u001b\u0002!\tAT\u0001\u0007I&4\u0018\u000eZ3\u0015\u0005Az\u0005\"\u0002\u001dM\u0001\u0004\u0011\u0002\"B'\u0001\t\u0003\tFC\u0001\u0019S\u0011\u0015A\u0005\u000b1\u0001%\u0011\u0015!\u0006\u0001\"\u0001V\u0003!iwN]3UQ\u0006tGC\u0001,Z!\tQr+\u0003\u0002Y7\t9!i\\8mK\u0006t\u0007\"\u0002\u001dT\u0001\u0004\u0011\u0002\"B.\u0001\t\u0003a\u0016\u0001C2bg\u0016luN]3\u0015\u0005Yk\u0006\"\u0002\u001d[\u0001\u0004\u0011\u0002\"B0\u0001\t\u0003\u0001\u0017\u0001C3rk\u0006d7\u000fV8\u0015\u0005Y\u000b\u0007\"\u0002\u001d_\u0001\u0004\u0011\u0002\"B2\u0001\t\u0003\"\u0017a\u00028pi2+7o\u001d\u000b\u0003-\u0016DQ\u0001\u000f2A\u0002IAQa\u001a\u0001\u0005B!\fa\u0001^8Kg>tW#A5\u0011\u0005)lgB\u0001\u000el\u0013\ta7$\u0001\u0004Qe\u0016$WMZ\u0005\u0003]>\u0014aa\u0015;sS:<'B\u00017\u001c\u0011\u0015\t\b\u0001\"\u0011s\u0003!!xn\u0015;sS:<G#A5")
public class LoadInstanceResource
extends Resource {
    private final long memory;
    private final int cores;
    private final int instances;

    public long memory() {
        return this.memory;
    }

    public int cores() {
        return this.cores;
    }

    public int instances() {
        return this.instances;
    }

    public LoadInstanceResource toLoadInstanceResource(Resource r) {
        LoadInstanceResource loadInstanceResource;
        Resource resource = r;
        if (resource instanceof LoadInstanceResource) {
            LoadInstanceResource loadInstanceResource2;
            loadInstanceResource = loadInstanceResource2 = (LoadInstanceResource)resource;
        } else if (resource instanceof LoadResource) {
            LoadResource loadResource = (LoadResource)resource;
            loadInstanceResource = new LoadInstanceResource(loadResource.memory(), loadResource.cores(), 0);
        } else if (resource instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource;
            loadInstanceResource = new LoadInstanceResource(memoryResource.memory(), 0, 0);
        } else if (resource instanceof CPUResource) {
            CPUResource cPUResource = (CPUResource)resource;
            loadInstanceResource = new LoadInstanceResource(0L, cPUResource.cores(), 0);
        } else if (resource instanceof DriverAndYarnResource) {
            DriverAndYarnResource driverAndYarnResource = (DriverAndYarnResource)resource;
            loadInstanceResource = driverAndYarnResource.loadInstanceResource();
        } else {
            loadInstanceResource = new LoadInstanceResource(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return loadInstanceResource;
    }

    @Override
    public LoadInstanceResource add(Resource r) {
        return new LoadInstanceResource(this.memory() + this.toLoadInstanceResource(r).memory(), this.cores() + this.toLoadInstanceResource(r).cores(), this.instances() + this.toLoadInstanceResource(r).instances());
    }

    @Override
    public LoadInstanceResource minus(Resource r) {
        return new LoadInstanceResource(this.memory() - this.toLoadInstanceResource(r).memory(), this.cores() - this.toLoadInstanceResource(r).cores(), this.instances() - this.toLoadInstanceResource(r).instances());
    }

    @Override
    public LoadInstanceResource multiplied(Resource r) {
        return new LoadInstanceResource(this.memory() * this.toLoadInstanceResource(r).memory(), this.cores() * this.toLoadInstanceResource(r).cores(), this.instances() * this.toLoadInstanceResource(r).instances());
    }

    @Override
    public LoadInstanceResource multiplied(float rate) {
        return new LoadInstanceResource((long)((double)this.memory() * (double)rate), package$.MODULE$.round((float)this.cores() * rate), (int)((float)this.instances() * rate));
    }

    @Override
    public LoadInstanceResource divide(Resource r) {
        return new LoadInstanceResource(this.memory() / this.toLoadInstanceResource(r).memory(), this.cores() / this.toLoadInstanceResource(r).cores(), this.instances() / this.toLoadInstanceResource(r).instances());
    }

    @Override
    public LoadInstanceResource divide(int rate) {
        return new LoadInstanceResource(this.memory() / (long)rate, this.cores() / rate, this.instances() * rate);
    }

    @Override
    public boolean moreThan(Resource r) {
        return this.memory() > this.toLoadInstanceResource(r).memory() && this.cores() > this.toLoadInstanceResource(r).cores() && this.instances() > this.toLoadInstanceResource(r).instances();
    }

    @Override
    public boolean caseMore(Resource r) {
        return this.memory() > this.toLoadInstanceResource(r).memory() || this.cores() > this.toLoadInstanceResource(r).cores() || this.instances() > this.toLoadInstanceResource(r).instances();
    }

    @Override
    public boolean equalsTo(Resource r) {
        return this.memory() == this.toLoadInstanceResource(r).memory() && this.cores() == this.toLoadInstanceResource(r).cores() && this.instances() == this.toLoadInstanceResource(r).instances();
    }

    @Override
    public boolean notLess(Resource r) {
        return this.memory() >= this.toLoadInstanceResource(r).memory() && this.cores() >= this.toLoadInstanceResource(r).cores() && this.instances() >= this.toLoadInstanceResource(r).instances();
    }

    @Override
    public String toJson() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"instance\":", ",\"memory\":\"", "\",\"cpu\":", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.instances()), ByteTimeUtils.bytesToString((long)this.memory()), BoxesRunTime.boxToInteger((int)this.cores())}));
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of instances(\u5b9e\u4f8b\u6570)\uff1a", "\uff0c(RAM)\u5185\u5b58\uff1a", ",cpu:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.instances()), ByteTimeUtils.bytesToString((long)this.memory()), BoxesRunTime.boxToInteger((int)this.cores())}));
    }

    public LoadInstanceResource(long memory, int cores, int instances) {
        this.memory = memory;
        this.cores = cores;
        this.instances = instances;
    }
}

