/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.enumeration;

import org.apache.linkis.manager.common.entity.enumeration.NodeHealthy;

public enum NodeStatus {
    Starting,
    Unlock,
    Locked,
    Idle,
    Busy,
    Running,
    ShuttingDown,
    Failed,
    Success;


    public static Boolean isAvailable(NodeStatus status) {
        if (Idle == status || Busy == status || Locked == status || Unlock == status || Running == status) {
            return true;
        }
        return false;
    }

    public static Boolean isLocked(NodeStatus status) {
        if (Busy == status || Locked == status || Idle == status) {
            return true;
        }
        return false;
    }

    public static Boolean isIdle(NodeStatus status) {
        if (Idle == status || Unlock == status) {
            return true;
        }
        return false;
    }

    public static Boolean isCompleted(NodeStatus status) {
        if (Success == status || Failed == status || ShuttingDown == status) {
            return true;
        }
        return false;
    }

    public static NodeStatus toNodeStatus(String status) throws IllegalArgumentException {
        if (null == status || "".equals(status)) {
            throw new IllegalArgumentException("Invalid status : " + status + " cannot be matched in NodeStatus");
        }
        switch (status) {
            case "Starting": {
                return Starting;
            }
            case "ShuttingDown": {
                return ShuttingDown;
            }
            case "Failed": {
                return Failed;
            }
            case "Success": {
                return Success;
            }
            case "Idle": {
                return Idle;
            }
            case "Busy": {
                return Busy;
            }
            case "Locked": {
                return Locked;
            }
            case "Unlock": {
                return Unlock;
            }
            case "Running": {
                return Running;
            }
        }
        throw new IllegalArgumentException("Invalid status : " + status + " in all values in NodeStatus");
    }

    public static NodeHealthy isEngineNodeHealthy(NodeStatus status) {
        switch (status) {
            case Starting: 
            case Running: 
            case Busy: 
            case Idle: 
            case Locked: 
            case Unlock: 
            case Success: {
                return NodeHealthy.Healthy;
            }
            case Failed: 
            case ShuttingDown: {
                return NodeHealthy.UnHealthy;
            }
        }
        return NodeHealthy.UnHealthy;
    }
}

