/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.common.utils;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.cs.common.entity.source.CommonHAContextID;
import org.apache.linkis.cs.common.entity.source.HAContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSHighAvailableUtils {
    private static final Logger logger = LoggerFactory.getLogger(CSHighAvailableUtils.class);
    private static final String HAID_PART_DELEMETER = "--";
    private static final String HAID_INS_LEN_DELEMETER = "-";
    private static final int HAID_PARTS_NUM = 2;
    private static final Gson gson = new Gson();
    private static final int TWO = 2;

    public static boolean checkHAIDBasicFormat(String haid) {
        if (StringUtils.isBlank((String)haid)) {
            return false;
        }
        String[] arr = haid.split(HAID_PART_DELEMETER);
        if (null != arr && arr.length == 2) {
            String id;
            int insLen = 0;
            String[] lenArr = arr[0].split(HAID_INS_LEN_DELEMETER);
            if (null == lenArr || lenArr.length < 2) {
                return false;
            }
            try {
                for (String len : lenArr) {
                    insLen += Integer.parseInt(len);
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (insLen < arr[1].length() && StringUtils.isNumeric((String)(id = arr[1].substring(insLen)))) {
                return true;
            }
        }
        return false;
    }

    public static String encodeHAIDKey(String contextID, String instance, List<String> backupInstanceList) throws CSErrorException {
        if (!StringUtils.isNumeric((String)contextID) || StringUtils.isBlank((String)instance) || null == backupInstanceList || backupInstanceList.isEmpty()) {
            logger.error("Cannot encodeHAIDKey, contextID : " + contextID + ", instance : " + instance + ", backupInstanceList : " + gson.toJson(backupInstanceList));
            throw new CSErrorException(70107, "Cannot encodeHAIDKey, contextID : " + contextID + ", instance : " + instance + ", backupInstanceList : " + gson.toJson(backupInstanceList));
        }
        StringBuilder idBuilder = new StringBuilder("");
        StringBuilder instBuilder = new StringBuilder("");
        idBuilder.append(instance.length());
        instBuilder.append(instance);
        for (String ins : backupInstanceList) {
            idBuilder.append(HAID_INS_LEN_DELEMETER).append(ins.length());
            instBuilder.append(ins);
        }
        idBuilder.append(HAID_PART_DELEMETER).append((CharSequence)instBuilder).append(contextID);
        return idBuilder.toString();
    }

    public static HAContextID decodeHAID(String haid) throws CSErrorException {
        if (StringUtils.isBlank((String)haid)) {
            throw new CSErrorException(70102, "HAIDKey cannot be empty.");
        }
        if (!CSHighAvailableUtils.checkHAIDBasicFormat(haid)) {
            logger.error("Invalid haid : " + haid);
            throw new CSErrorException(70108, "Invalid haid : " + haid);
        }
        String[] partArr = haid.split(HAID_PART_DELEMETER);
        String[] insArr = partArr[0].split(HAID_INS_LEN_DELEMETER);
        String contextID = null;
        ArrayList<String> instanceList = new ArrayList<String>();
        String insStr = partArr[1];
        try {
            int index = 0;
            int tmp = 0;
            for (String len : insArr) {
                tmp = Integer.parseInt(len);
                instanceList.add(insStr.substring(index, index + tmp));
                index += tmp;
            }
            contextID = insStr.substring(index);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid haid : " + haid + ", " + e.getMessage());
            throw new CSErrorException(70108, "Invalid haid : " + haid + ", " + e.getMessage());
        }
        String instance = (String)instanceList.remove(0);
        return new CommonHAContextID(instance, (String)instanceList.get(0), contextID);
    }

    public static void main(String[] args) throws Exception {
        String haid3;
        String haid1 = "24--24--YmRwaGRwMTFpZGUwMTo5MTE2YmRwaGRwMTFpZGUwMTo5MTE084835";
        System.out.println(CSHighAvailableUtils.checkHAIDBasicFormat(haid1));
        String id = "8798";
        String instance = "jslfjslfjlsdjfljsdf==+";
        String backupInstance = "sjljsljflsdjflsjd";
        ArrayList<String> list = new ArrayList<String>();
        list.add(backupInstance);
        list.add(instance);
        String haid2 = CSHighAvailableUtils.encodeHAIDKey(id, instance, list);
        System.out.println(haid2);
        System.out.println(CSHighAvailableUtils.checkHAIDBasicFormat(haid2));
        if (CSHighAvailableUtils.checkHAIDBasicFormat(haid2)) {
            System.out.println(gson.toJson((Object)CSHighAvailableUtils.decodeHAID(haid2)));
        }
        if (CSHighAvailableUtils.checkHAIDBasicFormat(haid3 = "24-24--YmRwaGRwMTFpZGUwMTo5MTE0YmRwaGRwMTFpZGUwMTo5MTE084855")) {
            System.out.println(gson.toJson((Object)CSHighAvailableUtils.decodeHAID(haid3)));
        } else {
            System.out.println("Invalid haid3 : " + haid3);
        }
    }
}

