/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.common.serialize.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.linkis.common.utils.ClassUtils;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.serialize.ContextSerializer;
import org.apache.linkis.cs.common.serialize.helper.AbstractSerializationHelper;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextSerializationHelper
extends AbstractSerializationHelper {
    private static final Logger logger = LoggerFactory.getLogger(ContextSerializationHelper.class);
    private Map<String, ContextSerializer> contextSerializerMap = new HashMap<String, ContextSerializer>(16);
    private static ContextSerializationHelper contextSerializationHelper = null;

    private void init() throws CSErrorException {
        Reflections reflections = ClassUtils.reflections();
        Set allSubClass = reflections.getSubTypesOf(ContextSerializer.class);
        if (null != allSubClass) {
            for (Class next : allSubClass) {
                if (ClassUtils.isInterfaceOrAbstract((Class)next)) continue;
                ContextSerializer contextSerializer = null;
                try {
                    contextSerializer = (ContextSerializer)next.newInstance();
                }
                catch (InstantiationException e) {
                    logger.info("Failed to Instantiation  " + next.getName());
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new CSErrorException(70112, "Failed to construct contextSerializer", e);
                }
                if (this.contextSerializerMap.containsKey(contextSerializer.getType())) {
                    throw new CSErrorException(70112, "contextSerializer Type cannot be duplicated ");
                }
                this.contextSerializerMap.put(contextSerializer.getType(), contextSerializer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContextSerializationHelper getInstance() {
        if (contextSerializationHelper != null) return contextSerializationHelper;
        Class<ContextSerializationHelper> clazz = ContextSerializationHelper.class;
        synchronized (ContextSerializationHelper.class) {
            if (contextSerializationHelper != null) return contextSerializationHelper;
            contextSerializationHelper = new ContextSerializationHelper();
            try {
                contextSerializationHelper.init();
            }
            catch (CSErrorException e) {
                logger.error("Failed init ContextSerializationHelper, now exit process", (Throwable)((Object)e));
                System.exit(1);
            }
            return contextSerializationHelper;
        }
    }

    @Override
    protected Map<String, ContextSerializer> getContextSerializerMap() {
        return this.contextSerializerMap;
    }
}

