/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.common.serialize;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.serialize.ContextSerializer;
import org.apache.linkis.cs.common.utils.CSCommonUtils;

public abstract class AbstractSerializer<T>
implements ContextSerializer<T> {
    private static final String TYPE = "type";

    public String getJsonValue(T t) throws CSErrorException {
        if (null != t) {
            return CSCommonUtils.gson.toJson(t);
        }
        return null;
    }

    public abstract T fromJson(String var1) throws CSErrorException;

    @Override
    public boolean accepts(String json) {
        if (StringUtils.isNotBlank((String)json)) {
            Map value = (Map)CSCommonUtils.gson.fromJson(json, new HashMap().getClass());
            if (this.getType().equals(value.get(TYPE))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String serialize(T t) throws CSErrorException {
        if (this.accepts(t)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(TYPE, this.getType());
            map.put("value", this.getJsonValue(t));
            return CSCommonUtils.gson.toJson(map);
        }
        return null;
    }

    @Override
    public T deserialize(String json) throws CSErrorException {
        if (this.accepts(json)) {
            Map jsonObj = (Map)CSCommonUtils.gson.fromJson(json, new HashMap().getClass());
            String value = (String)jsonObj.get("value");
            return this.fromJson(value);
        }
        return null;
    }

    @Override
    public boolean isType(String type) {
        return this.getType().equals(type);
    }
}

