/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.client.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.linkis.bml.client.AbstractBmlClient;
import org.apache.linkis.bml.client.errorcode.BmlClientErrorCodeSummary;
import org.apache.linkis.bml.common.BmlClientFailException;
import org.apache.linkis.bml.common.POSTResultNotMatchException;
import org.apache.linkis.bml.conf.BmlConfiguration$;
import org.apache.linkis.bml.http.HttpConf$;
import org.apache.linkis.bml.protocol.BmlAttachResourceAndProjectResponse;
import org.apache.linkis.bml.protocol.BmlChangeOwnerResponse;
import org.apache.linkis.bml.protocol.BmlCopyResourceResponse;
import org.apache.linkis.bml.protocol.BmlCreateProjectResponse;
import org.apache.linkis.bml.protocol.BmlDeleteResponse;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.bml.protocol.BmlProjectInfoResponse;
import org.apache.linkis.bml.protocol.BmlProjectPrivResponse;
import org.apache.linkis.bml.protocol.BmlRelateResponse;
import org.apache.linkis.bml.protocol.BmlResourceInfoResponse;
import org.apache.linkis.bml.protocol.BmlResourceVersionsResponse;
import org.apache.linkis.bml.protocol.BmlRollbackVersionResponse;
import org.apache.linkis.bml.protocol.BmlUpdateProjectPrivResponse;
import org.apache.linkis.bml.protocol.BmlUpdateResponse;
import org.apache.linkis.bml.protocol.BmlUploadResponse;
import org.apache.linkis.bml.protocol.ResourceVersions;
import org.apache.linkis.bml.request.BmlAttachAction;
import org.apache.linkis.bml.request.BmlChangeOwnerAction;
import org.apache.linkis.bml.request.BmlCopyResourceAction;
import org.apache.linkis.bml.request.BmlDeleteAction;
import org.apache.linkis.bml.request.BmlDownloadAction;
import org.apache.linkis.bml.request.BmlDownloadShareAction;
import org.apache.linkis.bml.request.BmlGetVersionsAction;
import org.apache.linkis.bml.request.BmlRollbackVersionAction;
import org.apache.linkis.bml.request.BmlUpdateAction;
import org.apache.linkis.bml.request.BmlUpdateShareResourceAction;
import org.apache.linkis.bml.request.BmlUploadAction;
import org.apache.linkis.bml.request.BmlUploadShareResourceAction;
import org.apache.linkis.bml.request.CreateBmlProjectAction;
import org.apache.linkis.bml.request.UpdateBmlProjectAction;
import org.apache.linkis.bml.response.BmlAttachResult;
import org.apache.linkis.bml.response.BmlCopyResourceResult;
import org.apache.linkis.bml.response.BmlCreateBmlProjectResult;
import org.apache.linkis.bml.response.BmlDeleteResult;
import org.apache.linkis.bml.response.BmlResourceVersionResult;
import org.apache.linkis.bml.response.BmlResult;
import org.apache.linkis.bml.response.BmlRollbackVersionResult;
import org.apache.linkis.bml.response.BmlUpdateProjectResult;
import org.apache.linkis.bml.response.BmlUpdateResult;
import org.apache.linkis.bml.response.BmlUpdateShareResourceResult;
import org.apache.linkis.bml.response.BmlUploadResult;
import org.apache.linkis.bml.response.BmlUploadShareResourceResult;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.httpclient.authentication.AuthenticationStrategy;
import org.apache.linkis.httpclient.config.ClientConfig;
import org.apache.linkis.httpclient.config.ClientConfigBuilder$;
import org.apache.linkis.httpclient.dws.DWSHttpClient;
import org.apache.linkis.httpclient.dws.authentication.TokenAuthenticationStrategy;
import org.apache.linkis.httpclient.dws.config.DWSClientConfig;
import org.apache.linkis.httpclient.request.Action;
import org.apache.linkis.httpclient.response.Result;
import org.apache.linkis.storage.FSFactory$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005h\u0001B\u0001\u0003\u0001=\u0011Q\u0002\u0013;ua\nkGn\u00117jK:$(BA\u0002\u0005\u0003\u0011IW\u000e\u001d7\u000b\u0005\u00151\u0011AB2mS\u0016tGO\u0003\u0002\b\u0011\u0005\u0019!-\u001c7\u000b\u0005%Q\u0011A\u00027j].L7O\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A!\u0002CA\t\u0013\u001b\u0005!\u0011BA\n\u0005\u0005E\t%m\u001d;sC\u000e$()\u001c7DY&,g\u000e\u001e\t\u0003+ii\u0011A\u0006\u0006\u0003/a\tQ!\u001e;jYNT!!\u0007\u0005\u0002\r\r|W.\\8o\u0013\tYbCA\u0004M_\u001e<\u0017N\\4\t\u0011u\u0001!\u0011!Q\u0001\ny\tAb\u00197jK:$8i\u001c8gS\u001e\u0004\"a\b\u0014\u000e\u0003\u0001R!!\t\u0012\u0002\r\r|gNZ5h\u0015\t\u0019C%A\u0002eoNT!!\n\u0005\u0002\u0015!$H\u000f]2mS\u0016tG/\u0003\u0002(A\tyAiV*DY&,g\u000e^\"p]\u001aLw\r\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003%\u0019XM\u001d<feV\u0013H\u000e\u0005\u0002,c9\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\rM#(/\u001b8h\u0015\t\u0001T\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005oqRc(D\u00019\u0015\tI$(\u0001\u0003vi&d'\"A\u001e\u0002\t)\fg/Y\u0005\u0003{a\u00121!T1q!\tas(\u0003\u0002A[\t\u0019\u0011I\\=\t\u000b\t\u0003A\u0011A\"\u0002\rqJg.\u001b;?)\u0011!ei\u0012%\u0011\u0005\u0015\u0003Q\"\u0001\u0002\t\u000bu\t\u0005\u0019\u0001\u0010\t\u000b%\n\u0005\u0019\u0001\u0016\t\u000bU\n\u0005\u0019\u0001\u001c\t\u000b\t\u0003A\u0011\u0001&\u0015\u0005\u0011[\u0005\"B\u0015J\u0001\u0004Q\u0003\"\u0002\"\u0001\t\u0003iE#\u0001#\t\u000b\t\u0003A\u0011A(\u0015\u0005\u0011\u0003\u0006\"B\u000fO\u0001\u0004q\u0002\"\u0002\"\u0001\t\u0003\u0011Fc\u0001#T)\")\u0011&\u0015a\u0001U!)Q'\u0015a\u0001m!9a\u000b\u0001b\u0001\n\u00139\u0016AC2mS\u0016tGOT1nKV\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\u\u0005!A.\u00198h\u0013\t\u0011$\f\u0003\u0004_\u0001\u0001\u0006I\u0001W\u0001\fG2LWM\u001c;OC6,\u0007\u0005C\u0004a\u0001\t\u0007I\u0011B1\u0002\u0013\u0011<8o\u00117jK:$X#\u00012\u0011\u0005\r$W\"\u0001\u0012\n\u0005\u0015\u0014#!\u0004#X'\"#H\u000f]\"mS\u0016tG\u000f\u0003\u0004h\u0001\u0001\u0006IAY\u0001\u000bI^\u001c8\t\\5f]R\u0004\u0003bB5\u0001\u0005\u0004%\taV\u0001\u000e\r&\u00136\u000bV0W\u000bJ\u001b\u0016j\u0014(\t\r-\u0004\u0001\u0015!\u0003Y\u000391\u0015JU*U?Z+%kU%P\u001d\u0002BQ!\u001c\u0001\u0005\n9\f!c\u0019:fCR,7\t\\5f]R\u001cuN\u001c4jOR\ta\u0004C\u0003q\u0001\u0011\u0005\u0013/\u0001\te_^tGn\\1e%\u0016\u001cx.\u001e:dKR\u0019!\u000f\u001f>\u0011\u0005M4X\"\u0001;\u000b\u0005U4\u0011\u0001\u00039s_R|7m\u001c7\n\u0005]$(a\u0005\"nY\u0012{wO\u001c7pC\u0012\u0014Vm\u001d9p]N,\u0007\"B=p\u0001\u0004Q\u0013\u0001B;tKJDQa_8A\u0002)\n!B]3t_V\u00148-Z%E\u0011\u0015\u0001\b\u0001\"\u0011~)\u0015\u0011hp`A\u0002\u0011\u0015IH\u00101\u0001+\u0011\u0019\t\t\u0001 a\u0001U\u0005Q!/Z:pkJ\u001cW-\u00133\t\r\u0005\u0015A\u00101\u0001+\u0003\u001d1XM]:j_:Da\u0001\u001d\u0001\u0005B\u0005%Ac\u0003:\u0002\f\u00055\u0011qBA\t\u0003+Aa!_A\u0004\u0001\u0004Q\u0003bBA\u0001\u0003\u000f\u0001\rA\u000b\u0005\b\u0003\u000b\t9\u00011\u0001+\u0011\u001d\t\u0019\"a\u0002A\u0002)\nA\u0001]1uQ\"Q\u0011qCA\u0004!\u0003\u0005\r!!\u0007\u0002\u0013=4XM]<sSR,\u0007c\u0001\u0017\u0002\u001c%\u0019\u0011QD\u0017\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0012!\u00063po:dw.\u00193TQ\u0006\u0014XMU3t_V\u00148-\u001a\u000b\fe\u0006\u0015\u0012qEA\u0015\u0003W\ti\u0003\u0003\u0004z\u0003?\u0001\rA\u000b\u0005\b\u0003\u0003\ty\u00021\u0001+\u0011\u001d\t)!a\bA\u0002)Bq!a\u0005\u0002 \u0001\u0007!\u0006\u0003\u0006\u0002\u0018\u0005}\u0001\u0013!a\u0001\u00033Aq!!\r\u0001\t\u0003\n\u0019$\u0001\bva\u0012\fG/\u001a*fg>,(oY3\u0015\u0011\u0005U\u00121HA\u001f\u0003\u007f\u00012a]A\u001c\u0013\r\tI\u0004\u001e\u0002\u0012\u00056dW\u000b\u001d3bi\u0016\u0014Vm\u001d9p]N,\u0007BB=\u00020\u0001\u0007!\u0006\u0003\u0004|\u0003_\u0001\rA\u000b\u0005\b\u0003\u0003\ny\u00031\u0001+\u0003!1\u0017\u000e\\3QCRD\u0007bBA\u0019\u0001\u0011\u0005\u0013Q\t\u000b\u000b\u0003k\t9%!\u0013\u0002L\u00055\u0003BB=\u0002D\u0001\u0007!\u0006\u0003\u0004|\u0003\u0007\u0002\rA\u000b\u0005\b\u0003\u0003\n\u0019\u00051\u0001+\u0011!\ty%a\u0011A\u0002\u0005E\u0013aC5oaV$8\u000b\u001e:fC6\u0004B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/R\u0014AA5p\u0013\u0011\tY&!\u0016\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003?\u0002A\u0011IA1\u00039\u0011X\r\\1uKJ+7o\\;sG\u0016$b!a\u0019\u0002j\u0005-\u0004cA:\u0002f%\u0019\u0011q\r;\u0003#\tkGNU3mCR,'+Z:q_:\u001cX\r\u0003\u0004|\u0003;\u0002\rA\u000b\u0005\b\u0003[\ni\u00061\u0001+\u00039!\u0018M]4fi\u001aKG.\u001a)bi\"Dq!!\u001d\u0001\t\u0003\n\u0019(A\u0006hKR4VM]:j_:\u001cHCBA;\u0003w\ni\bE\u0002t\u0003oJ1!!\u001fu\u0005m\u0011U\u000e\u001c*fg>,(oY3WKJ\u001c\u0018n\u001c8t%\u0016\u001c\bo\u001c8tK\"1\u00110a\u001cA\u0002)Bq!!\u0001\u0002p\u0001\u0007!\u0006C\u0004\u0002\u0002\u0002!\t%a!\u0002\u001dU\u0004Hn\\1e%\u0016\u001cx.\u001e:dKR1\u0011QQAF\u0003\u001b\u00032a]AD\u0013\r\tI\t\u001e\u0002\u0012\u00056dW\u000b\u001d7pC\u0012\u0014Vm\u001d9p]N,\u0007BB=\u0002\u0000\u0001\u0007!\u0006C\u0004\u0002B\u0005}\u0004\u0019\u0001\u0016\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\u0006Q\u0001/\u0019;i)>t\u0015-\\3\u0015\u0007)\n)\nC\u0004\u0002B\u0005=\u0005\u0019\u0001\u0016\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u001aRA\u0011QQAN\u0003;\u000by\n\u0003\u0004z\u0003/\u0003\rA\u000b\u0005\b\u0003\u0003\n9\n1\u0001+\u0011!\ty%a&A\u0002\u0005E\u0003bBAR\u0001\u0011\u0005\u0013QU\u0001\u000fI\u0016dW\r^3SKN|WO]2f)!\t9+!,\u00020\u0006E\u0006cA:\u0002*&\u0019\u00111\u0016;\u0003#\tkG\u000eR3mKR,'+Z:q_:\u001cX\r\u0003\u0004z\u0003C\u0003\rA\u000b\u0005\b\u0003\u0003\t\t\u000b1\u0001+\u0011\u001d\t)!!)A\u0002)Bq!a)\u0001\t\u0003\n)\f\u0006\u0004\u0002(\u0006]\u0016\u0011\u0018\u0005\u0007s\u0006M\u0006\u0019\u0001\u0016\t\u000f\u0005\u0005\u00111\u0017a\u0001U!9\u0011Q\u0018\u0001\u0005\n\u0005}\u0016AD4fi&s\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0005\u0003#\n\t\rC\u0004\u0002D\u0006m\u0006\u0019\u0001\u0016\u0002\u0007M$(\u000fC\u0004\u0002H\u0002!\t%!3\u0002!\r\u0014X-\u0019;f\u00056d\u0007K]8kK\u000e$HCCAf\u0003#\f).!7\u0002dB\u00191/!4\n\u0007\u0005=GO\u0001\rC[2\u001c%/Z1uKB\u0013xN[3diJ+7\u000f]8og\u0016Dq!a5\u0002F\u0002\u0007!&A\u0004de\u0016\fGo\u001c:\t\u000f\u0005]\u0017Q\u0019a\u0001U\u0005Y\u0001O]8kK\u000e$h*Y7f\u0011!\tY.!2A\u0002\u0005u\u0017aC1dG\u0016\u001c8/V:feN\u0004BaNApU%\u0019\u0011\u0011\u001d\u001d\u0003\t1K7\u000f\u001e\u0005\t\u0003K\f)\r1\u0001\u0002^\u0006IQ\rZ5u+N,'o\u001d\u0005\b\u0003S\u0004A\u0011IAv\u0003M)\b\u000f\\8bINC\u0017M]3SKN|WO]2f))\t))!<\u0002p\u0006E\u00181\u001f\u0005\u0007s\u0006\u001d\b\u0019\u0001\u0016\t\u000f\u0005]\u0017q\u001da\u0001U!9\u0011\u0011IAt\u0001\u0004Q\u0003\u0002CA(\u0003O\u0004\r!!\u0015\t\u000f\u0005%\b\u0001\"\u0011\u0002xRA\u0011QQA}\u0003w\fi\u0010\u0003\u0004z\u0003k\u0004\rA\u000b\u0005\b\u0003/\f)\u00101\u0001+\u0011\u001d\t\t%!>A\u0002)Bq!!\t\u0001\t\u0003\u0012\t\u0001F\u0004s\u0005\u0007\u0011)Aa\u0002\t\re\fy\u00101\u0001+\u0011\u001d\t\t!a@A\u0002)Bq!!\u0002\u0002\u0000\u0002\u0007!\u0006C\u0004\u0002\"\u0001!\tEa\u0003\u0015\u000bI\u0014iAa\u0004\t\re\u0014I\u00011\u0001+\u0011\u001d\t\tA!\u0003A\u0002)BqAa\u0005\u0001\t\u0003\u0012)\"A\nva\u0012\fG/Z*iCJ,'+Z:pkJ\u001cW\r\u0006\u0006\u00026\t]!\u0011\u0004B\u000e\u0005;Aa!\u001fB\t\u0001\u0004Q\u0003bBA\u0001\u0005#\u0001\rA\u000b\u0005\b\u0003\u0003\u0012\t\u00021\u0001+\u0011!\tyE!\u0005A\u0002\u0005E\u0003b\u0002B\n\u0001\u0011\u0005#\u0011\u0005\u000b\t\u0003k\u0011\u0019C!\n\u0003(!1\u0011Pa\bA\u0002)Bq!!\u0001\u0003 \u0001\u0007!\u0006C\u0004\u0002B\t}\u0001\u0019\u0001\u0016\t\u000f\t-\u0002\u0001\"\u0011\u0003.\u0005!r-\u001a;Qe>TWm\u0019;J]\u001a|')\u001f(b[\u0016$BAa\f\u00036A\u00191O!\r\n\u0007\tMBO\u0001\fC[2\u0004&o\u001c6fGRLeNZ8SKN\u0004xN\\:f\u0011\u001d\t9N!\u000bA\u0002)BqA!\u000f\u0001\t\u0003\u0012Y$A\bhKR\u0014Vm]8ve\u000e,\u0017J\u001c4p)\u0011\u0011iDa\u0011\u0011\u0007M\u0014y$C\u0002\u0003BQ\u0014qCQ7m%\u0016\u001cx.\u001e:dK&sgm\u001c*fgB|gn]3\t\u000f\u0005\u0005!q\u0007a\u0001U!9!q\t\u0001\u0005B\t%\u0013AD4fiB\u0013xN[3diB\u0013\u0018N\u001e\u000b\u0005\u0005\u0017\u0012\t\u0006E\u0002t\u0005\u001bJ1Aa\u0014u\u0005Y\u0011U\u000e\u001c)s_*,7\r\u001e)sSZ\u0014Vm\u001d9p]N,\u0007bBAl\u0005\u000b\u0002\rA\u000b\u0005\b\u0005+\u0002A\u0011\tB,\u0003a\tG\u000f^1dQJ+7o\\;sG\u0016\fe\u000e\u001a)s_*,7\r\u001e\u000b\u0007\u00053\u0012yF!\u0019\u0011\u0007M\u0014Y&C\u0002\u0003^Q\u00141EQ7m\u0003R$\u0018m\u00195SKN|WO]2f\u0003:$\u0007K]8kK\u000e$(+Z:q_:\u001cX\rC\u0004\u0002X\nM\u0003\u0019\u0001\u0016\t\u000f\u0005\u0005!1\u000ba\u0001U!9!Q\r\u0001\u0005B\t\u001d\u0014!E;qI\u0006$X\r\u0015:pU\u0016\u001cG\u000f\u0015:jmRQ!\u0011\u000eB8\u0005g\u0012)Ha\u001e\u0011\u0007M\u0014Y'C\u0002\u0003nQ\u0014ADQ7m+B$\u0017\r^3Qe>TWm\u0019;Qe&4(+Z:q_:\u001cX\rC\u0004\u0003r\t\r\u0004\u0019\u0001\u0016\u0002\u0011U\u001cXM\u001d8b[\u0016Dq!a6\u0003d\u0001\u0007!\u0006\u0003\u0005\u0002f\n\r\u0004\u0019AAo\u0011!\tYNa\u0019A\u0002\u0005u\u0007b\u0002B>\u0001\u0011\u0005#QP\u0001\u0018G\"\fgnZ3Po:,'OQ=SKN|WO]2f\u0013\u0012$\u0002Ba \u0003\u0006\n\u001d%1\u0012\t\u0004g\n\u0005\u0015b\u0001BBi\n1\")\u001c7DQ\u0006tw-Z(x]\u0016\u0014(+Z:q_:\u001cX\rC\u0004\u0002\u0002\te\u0004\u0019\u0001\u0016\t\u000f\t%%\u0011\u0010a\u0001U\u0005Aq\u000e\u001c3Po:,'\u000fC\u0004\u0003\u000e\ne\u0004\u0019\u0001\u0016\u0002\u00119,woT<oKJDqA!%\u0001\t\u0003\u0012\u0019*A\rd_BL(+Z:pkJ\u001cW\rV8B]>$\b.\u001a:Vg\u0016\u0014H\u0003\u0003BK\u00057\u0013iJ!)\u0011\u0007M\u00149*C\u0002\u0003\u001aR\u0014qCQ7m\u0007>\u0004\u0018PU3t_V\u00148-\u001a*fgB|gn]3\t\u000f\u0005\u0005!q\u0012a\u0001U!9!q\u0014BH\u0001\u0004Q\u0013aC1o_RDWM]+tKJDqAa)\u0003\u0010\u0002\u0007!&A\u0006pe&<\u0017N\\(x]\u0016\u0014\bb\u0002BT\u0001\u0011\u0005#\u0011V\u0001\u0010e>dGNY1dWZ+'o]5p]RA!1\u0016BY\u0005g\u0013)\fE\u0002t\u0005[K1Aa,u\u0005i\u0011U\u000e\u001c*pY2\u0014\u0017mY6WKJ\u001c\u0018n\u001c8SKN\u0004xN\\:f\u0011\u001d\t\tA!*A\u0002)Bq!!\u0002\u0003&\u0002\u0007!\u0006\u0003\u0004z\u0005K\u0003\rA\u000b\u0005\b\u0005s\u0003A\u0011\tB^\u0003\u0015\u0019Gn\\:f)\t\u0011i\fE\u0002-\u0005\u007fK1A!1.\u0005\u0011)f.\u001b;\t\u0013\t\u0015\u0007!%A\u0005\u0002\t\u001d\u0017A\u00073po:dw.\u00193SKN|WO]2fI\u0011,g-Y;mi\u0012*TC\u0001BeU\u0011\tIBa3,\u0005\t5\u0007\u0003\u0002Bh\u00053l!A!5\u000b\t\tM'Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa6.\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00057\u0014\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba8\u0001#\u0003%\tAa2\u0002?\u0011|wO\u001c7pC\u0012\u001c\u0006.\u0019:f%\u0016\u001cx.\u001e:dK\u0012\"WMZ1vYR$S\u0007")
public class HttpBmlClient
extends AbstractBmlClient
implements Logging {
    private final String serverUrl;
    private final Map<String, Object> properties;
    private final String clientName;
    private final DWSHttpClient dwsClient;
    private final String FIRST_VERSION;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        HttpBmlClient httpBmlClient = this;
        synchronized (httpBmlClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    private String clientName() {
        return this.clientName;
    }

    private DWSHttpClient dwsClient() {
        return this.dwsClient;
    }

    public String FIRST_VERSION() {
        return this.FIRST_VERSION;
    }

    private DWSClientConfig createClientConfig() {
        String _serverUrl;
        String string = _serverUrl = StringUtils.isEmpty((CharSequence)this.serverUrl) ? HttpConf$.MODULE$.gatewayInstance() : this.serverUrl;
        if (StringUtils.isEmpty((CharSequence)_serverUrl)) {
            throw new BmlClientFailException(BmlClientErrorCodeSummary.SERVER_URL_NOT_NULL.getErrorCode(), BmlClientErrorCodeSummary.SERVER_URL_NOT_NULL.getErrorDesc());
        }
        Map<Object, Object> config = this.properties == null ? new HashMap() : this.properties;
        int maxConnection = BoxesRunTime.unboxToInt((Object)config.getOrDefault(BmlConfiguration$.MODULE$.CONNECTION_MAX_SIZE_SHORT_NAME(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)BmlConfiguration$.MODULE$.CONNECTION_MAX_SIZE().getValue()))));
        int connectTimeout = BoxesRunTime.unboxToInt((Object)config.getOrDefault(BmlConfiguration$.MODULE$.CONNECTION_TIMEOUT_SHORT_NAME(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)BmlConfiguration$.MODULE$.CONNECTION_TIMEOUT().getValue()))));
        int readTimeout = BoxesRunTime.unboxToInt((Object)config.getOrDefault(BmlConfiguration$.MODULE$.CONNECTION_READ_TIMEOUT_SHORT_NAME(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)BmlConfiguration$.MODULE$.CONNECTION_READ_TIMEOUT().getValue()))));
        String tokenKey = (String)config.getOrDefault(BmlConfiguration$.MODULE$.AUTH_TOKEN_KEY_SHORT_NAME(), BmlConfiguration$.MODULE$.AUTH_TOKEN_KEY().getValue());
        String tokenValue = (String)config.getOrDefault(BmlConfiguration$.MODULE$.AUTH_TOKEN_VALUE_SHORT_NAME(), BmlConfiguration$.MODULE$.AUTH_TOKEN_VALUE().getValue());
        TokenAuthenticationStrategy authenticationStrategy = new TokenAuthenticationStrategy();
        ClientConfig clientConfig = ClientConfigBuilder$.MODULE$.newBuilder().addServerUrl(_serverUrl).connectionTimeout((long)connectTimeout).discoveryEnabled(false).loadbalancerEnabled(false).maxConnectionSize(maxConnection).retryEnabled(false).readTimeout((long)readTimeout).setAuthenticationStrategy((AuthenticationStrategy)authenticationStrategy).setAuthTokenKey(tokenKey).setAuthTokenValue(tokenValue).build();
        DWSClientConfig dwsClientConfig = new DWSClientConfig(clientConfig);
        dwsClientConfig.setDWSVersion((String)Configuration$.MODULE$.LINKIS_WEB_VERSION().getValue());
        return dwsClientConfig;
    }

    @Override
    public BmlDownloadResponse downloadResource(String user, String resourceID) {
        return this.downloadResource(user, resourceID, "");
    }

    @Override
    public BmlDownloadResponse downloadResource(String user, String resourceId, String version) {
        BmlDownloadAction bmlDownloadAction = new BmlDownloadAction();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(bmlDownloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resourceId));
        Object object = version == null ? BoxedUnit.UNIT : ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(bmlDownloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)version));
        bmlDownloadAction.setUser(user);
        Result downloadResult = this.dwsClient().execute((Action)bmlDownloadAction);
        return new BmlDownloadResponse(true, bmlDownloadAction.getInputStream(), resourceId, version, null);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BmlDownloadResponse downloadResource(String user, String resourceId, String version, String path, boolean overwrite) {
        OutputStream outputStream;
        String fullFileName;
        Fs fileSystem;
        block10: {
            FsPath fsPath = new FsPath(path);
            fileSystem = FSFactory$.MODULE$.getFsByProxyUser(fsPath, user);
            fileSystem.init(new HashMap());
            fullFileName = path;
            BmlDownloadAction downloadAction = new BmlDownloadAction();
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(downloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resourceId));
            Object object = StringUtils.isNotEmpty((CharSequence)version) ? ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(downloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)version)) : BoxedUnit.UNIT;
            downloadAction.setUser(user);
            InputStream inputStream = null;
            outputStream = null;
            try {
                this.dwsClient().execute((Action)downloadAction);
                FsPath fullFilePath = new FsPath(fullFileName);
                outputStream = fileSystem.write(fullFilePath, overwrite);
                inputStream = downloadAction.getInputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                HttpResponse httpResponse = downloadAction.getResponse();
                if (httpResponse instanceof CloseableHttpResponse) {
                    CloseableHttpResponse closeableHttpResponse = (CloseableHttpResponse)httpResponse;
                    BoxedUnit boxedUnit = (BoxedUnit)Utils$.MODULE$.tryAndWarn((Function0)new Serializable(this, closeableHttpResponse){
                        public static final long serialVersionUID = 0L;
                        private final CloseableHttpResponse x2$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.x2$1.close();
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    }, this.logger());
                } else {
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Download response : ", " cannot close."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{downloadAction.getResponse()})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    this.logger().error("failed to copy stream (\u6d41\u590d\u5236\u5931\u8d25)", throwable);
                    throw throwable;
                    catch (IOException iOException) {
                        this.logger().error("failed to copy inputStream and outputStream (inputStream\u548coutputStream\u6d41copy\u5931\u8d25)", (Throwable)iOException);
                        BmlClientFailException exception = new BmlClientFailException(BmlClientErrorCodeSummary.BML_CLIENT_FAILED.getErrorCode(), BmlClientErrorCodeSummary.BML_CLIENT_FAILED.getErrorDesc());
                        exception.initCause(iOException);
                        throw exception;
                    }
                }
                catch (Throwable throwable2) {
                    void var7_7;
                    void var11_11;
                    void var10_10;
                    if (var10_10 != null) {
                        IOUtils.closeQuietly((InputStream)var10_10);
                    }
                    if (var11_11 != null) {
                        IOUtils.closeQuietly((OutputStream)var11_11);
                    }
                    var7_7.close();
                    throw throwable2;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (outputStream != null) {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        fileSystem.close();
        return new BmlDownloadResponse(true, null, resourceId, version, fullFileName);
    }

    public boolean downloadResource$default$5() {
        return false;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BmlDownloadResponse downloadShareResource(String user, String resourceId, String version, String path, boolean overwrite) {
        OutputStream outputStream;
        String fullFileName;
        Fs fileSystem;
        block8: {
            FsPath fsPath = new FsPath(path);
            fileSystem = FSFactory$.MODULE$.getFsByProxyUser(fsPath, user);
            fileSystem.init(new HashMap());
            fullFileName = path;
            BmlDownloadShareAction downloadAction = new BmlDownloadShareAction();
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(downloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resourceId));
            Object object = StringUtils.isNotEmpty((CharSequence)version) ? ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(downloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)version)) : BoxedUnit.UNIT;
            downloadAction.setUser(user);
            InputStream inputStream = null;
            outputStream = null;
            try {
                this.dwsClient().execute((Action)downloadAction);
                FsPath fullFilePath = new FsPath(fullFileName);
                outputStream = fileSystem.write(fullFilePath, overwrite);
                inputStream = downloadAction.getInputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    this.logger().error("failed to copy stream (\u6d41\u590d\u5236\u5931\u8d25)", throwable);
                    throw throwable;
                    catch (IOException iOException) {
                        this.logger().error("failed to copy inputStream and outputStream (inputStream\u548coutputStream\u6d41copy\u5931\u8d25)", (Throwable)iOException);
                        BmlClientFailException exception = new BmlClientFailException(BmlClientErrorCodeSummary.BML_CLIENT_FAILED.getErrorCode(), BmlClientErrorCodeSummary.BML_CLIENT_FAILED.getErrorDesc());
                        exception.initCause(iOException);
                        throw iOException;
                    }
                }
                catch (Throwable throwable2) {
                    void var7_7;
                    void var11_11;
                    void var10_10;
                    if (var10_10 != null) {
                        IOUtils.closeQuietly((InputStream)var10_10);
                    }
                    if (var11_11 != null) {
                        IOUtils.closeQuietly((OutputStream)var11_11);
                    }
                    var7_7.close();
                    throw throwable2;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (outputStream != null) {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        fileSystem.close();
        return new BmlDownloadResponse(true, null, resourceId, version, fullFileName);
    }

    @Override
    public BmlUpdateResponse updateResource(String user, String resourceID, String filePath) {
        InputStream inputStream = this.getInputStream(filePath);
        return this.updateResource(user, resourceID, filePath, inputStream);
    }

    @Override
    public BmlUpdateResponse updateResource(String user, String resourceID, String filePath, InputStream inputStream) {
        Result result;
        HashMap<String, InputStream> _inputStreams = new HashMap<String, InputStream>();
        _inputStreams.put("file", inputStream);
        BmlUpdateAction bmlUpdateAction = new BmlUpdateAction(null, _inputStreams);
        bmlUpdateAction.setUser(user);
        bmlUpdateAction.inputStreamNames().put("file", this.pathToName(filePath));
        bmlUpdateAction.getParameters().put("resourceId", resourceID);
        Result result2 = result = this.dwsClient().execute((Action)bmlUpdateAction);
        if (result2 instanceof BmlUpdateResult) {
            BmlUpdateResponse bmlUpdateResponse;
            boolean isSuccess;
            BmlUpdateResult bmlUpdateResult = (BmlUpdateResult)result2;
            boolean bl = isSuccess = bmlUpdateResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId = bmlUpdateResult.getResourceId();
                String version = bmlUpdateResult.getVersion();
                bmlUpdateResponse = new BmlUpdateResponse(isSuccess, resourceId, version);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " update resource failed, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, BoxesRunTime.boxToInteger((int)bmlUpdateResult.getStatusCode())})));
                bmlUpdateResponse = new BmlUpdateResponse(isSuccess, null, null);
            }
            BmlUpdateResponse bmlUpdateResponse2 = bmlUpdateResponse;
            return bmlUpdateResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlResourceDownloadResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlRelateResponse relateResource(String resourceID, String targetFilePath) {
        return null;
    }

    @Override
    public BmlResourceVersionsResponse getVersions(String user, String resourceId) {
        BmlGetVersionsAction getVersionsAction = new BmlGetVersionsAction(user, resourceId);
        Result result = this.dwsClient().execute((Action)getVersionsAction);
        Result result2 = result;
        if (result2 instanceof BmlResourceVersionResult) {
            BmlResourceVersionsResponse bmlResourceVersionsResponse;
            boolean isSuccess;
            BmlResourceVersionResult bmlResourceVersionResult = (BmlResourceVersionResult)result2;
            boolean bl = isSuccess = bmlResourceVersionResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId2 = bmlResourceVersionResult.getResourceId();
                ResourceVersions resourceVersions = bmlResourceVersionResult.getResourceVersions();
                bmlResourceVersionsResponse = new BmlResourceVersionsResponse(isSuccess, resourceId2, resourceVersions);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " get versions failed, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, BoxesRunTime.boxToInteger((int)bmlResourceVersionResult.getStatusCode())})));
                bmlResourceVersionsResponse = new BmlResourceVersionsResponse(isSuccess, null, null);
            }
            BmlResourceVersionsResponse bmlResourceVersionsResponse2 = bmlResourceVersionsResponse;
            return bmlResourceVersionsResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlResourceDownloadResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlUploadResponse uploadResource(String user, String filePath) {
        InputStream inputStream = this.getInputStream(filePath);
        return this.uploadResource(user, filePath, inputStream);
    }

    private String pathToName(String filePath) {
        return new File(filePath).getName();
    }

    @Override
    public BmlUploadResponse uploadResource(String user, String filePath, InputStream inputStream) {
        Result result;
        HashMap<String, InputStream> _inputStreams = new HashMap<String, InputStream>();
        _inputStreams.put("file", inputStream);
        BmlUploadAction uploadAction = new BmlUploadAction(null, _inputStreams);
        uploadAction.inputStreamNames().put("file", this.pathToName(filePath));
        uploadAction.setUser(user);
        Result result2 = result = this.dwsClient().execute((Action)uploadAction);
        if (result2 instanceof BmlUploadResult) {
            BmlUploadResponse bmlUploadResponse;
            boolean isSuccess;
            BmlUploadResult bmlUploadResult = (BmlUploadResult)result2;
            boolean bl = isSuccess = bmlUploadResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId = bmlUploadResult.getResourceId();
                String version = bmlUploadResult.getVersion();
                bmlUploadResponse = new BmlUploadResponse(isSuccess, resourceId, version);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " upload resource failed, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, BoxesRunTime.boxToInteger((int)bmlUploadResult.getStatusCode())})));
                bmlUploadResponse = new BmlUploadResponse(isSuccess, null, null);
            }
            BmlUploadResponse bmlUploadResponse2 = bmlUploadResponse;
            return bmlUploadResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlResourceDownloadResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlDeleteResponse deleteResource(String user, String resourceId, String version) {
        return null;
    }

    @Override
    public BmlDeleteResponse deleteResource(String user, String resourceId) {
        Result result;
        BmlDeleteAction deleteAction = new BmlDeleteAction(resourceId);
        deleteAction.setUser(user);
        deleteAction.getParameters().put("resourceId", resourceId);
        Result result2 = result = this.dwsClient().execute((Action)deleteAction);
        if (result2 instanceof BmlDeleteResult) {
            BmlDeleteResponse bmlDeleteResponse;
            boolean isSuccess;
            BmlDeleteResult bmlDeleteResult = (BmlDeleteResult)result2;
            boolean bl = isSuccess = bmlDeleteResult.getStatus() == 0;
            if (isSuccess) {
                bmlDeleteResponse = new BmlDeleteResponse(isSuccess);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " update resource failed, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, BoxesRunTime.boxToInteger((int)bmlDeleteResult.getStatusCode())})));
                bmlDeleteResponse = new BmlDeleteResponse(isSuccess);
            }
            BmlDeleteResponse bmlDeleteResponse2 = bmlDeleteResponse;
            return bmlDeleteResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlResourceDownloadResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    private InputStream getInputStream(String str) {
        return null;
    }

    @Override
    public BmlCreateProjectResponse createBmlProject(String creator, String projectName, List<String> accessUsers, List<String> editUsers) {
        Result result;
        CreateBmlProjectAction createBmlProjectAction = new CreateBmlProjectAction();
        createBmlProjectAction.setUser(creator);
        createBmlProjectAction.getRequestPayloads().put("projectName", projectName);
        createBmlProjectAction.getRequestPayloads().put("editUsers", editUsers);
        createBmlProjectAction.getRequestPayloads().put("accessUsers", accessUsers);
        Result result2 = result = this.dwsClient().execute((Action)createBmlProjectAction);
        if (result2 instanceof BmlCreateBmlProjectResult) {
            BmlCreateProjectResponse bmlCreateProjectResponse;
            boolean isSuccess;
            BmlCreateBmlProjectResult bmlCreateBmlProjectResult = (BmlCreateBmlProjectResult)result2;
            boolean bl = isSuccess = bmlCreateBmlProjectResult.getStatus() == 0;
            if (isSuccess) {
                bmlCreateProjectResponse = new BmlCreateProjectResponse(isSuccess);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " create bml project, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user, BoxesRunTime.boxToInteger((int)bmlCreateBmlProjectResult.getStatusCode())})));
                bmlCreateProjectResponse = new BmlCreateProjectResponse(isSuccess);
            }
            BmlCreateProjectResponse bmlCreateProjectResponse2 = bmlCreateProjectResponse;
            return bmlCreateProjectResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlCreateBmlProjectResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlUploadResponse uploadShareResource(String user, String projectName, String filePath, InputStream inputStream) {
        Result result;
        HashMap<String, InputStream> _inputStreams = new HashMap<String, InputStream>();
        _inputStreams.put("file", inputStream);
        BmlUploadShareResourceAction uploadAction = new BmlUploadShareResourceAction(null, _inputStreams);
        uploadAction.inputStreamNames().put("file", this.pathToName(filePath));
        uploadAction.setUser(user);
        uploadAction.getParameters().put("projectName", projectName);
        uploadAction.getRequestPayloads().put("projectName", projectName);
        Result result2 = result = this.dwsClient().execute((Action)uploadAction);
        if (result2 instanceof BmlUploadShareResourceResult) {
            BmlUploadResponse bmlUploadResponse;
            boolean isSuccess;
            BmlUploadShareResourceResult bmlUploadShareResourceResult = (BmlUploadShareResourceResult)result2;
            boolean bl = isSuccess = bmlUploadShareResourceResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId = bmlUploadShareResourceResult.getResourceId();
                String version = bmlUploadShareResourceResult.getVersion();
                bmlUploadResponse = new BmlUploadResponse(isSuccess, resourceId, version);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " upload resource failed, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, BoxesRunTime.boxToInteger((int)bmlUploadShareResourceResult.getStatusCode())})));
                bmlUploadResponse = new BmlUploadResponse(isSuccess, null, null);
            }
            BmlUploadResponse bmlUploadResponse2 = bmlUploadResponse;
            return bmlUploadResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlResourceDownloadResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlUploadResponse uploadShareResource(String user, String projectName, String filePath) {
        return null;
    }

    @Override
    public BmlDownloadResponse downloadShareResource(String user, String resourceId, String version) {
        BmlDownloadShareAction bmlDownloadShareAction = new BmlDownloadShareAction();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(bmlDownloadShareAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resourceId));
        Object object = version == null ? BoxedUnit.UNIT : ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(bmlDownloadShareAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)version));
        bmlDownloadShareAction.setUser(user);
        Result result = this.dwsClient().execute((Action)bmlDownloadShareAction);
        return new BmlDownloadResponse(true, bmlDownloadShareAction.getInputStream(), resourceId, version, null);
    }

    @Override
    public BmlDownloadResponse downloadShareResource(String user, String resourceId) {
        return null;
    }

    public boolean downloadShareResource$default$5() {
        return false;
    }

    @Override
    public BmlUpdateResponse updateShareResource(String user, String resourceId, String filePath, InputStream inputStream) {
        Result result;
        HashMap<String, InputStream> _inputStreams = new HashMap<String, InputStream>();
        _inputStreams.put("file", inputStream);
        BmlUpdateShareResourceAction bmlUpdateShareResourceAction = new BmlUpdateShareResourceAction(null, _inputStreams);
        bmlUpdateShareResourceAction.setUser(user);
        bmlUpdateShareResourceAction.inputStreamNames().put("file", this.pathToName(filePath));
        bmlUpdateShareResourceAction.getParameters().put("resourceId", resourceId);
        Result result2 = result = this.dwsClient().execute((Action)bmlUpdateShareResourceAction);
        if (result2 instanceof BmlUpdateShareResourceResult) {
            BmlUpdateResponse bmlUpdateResponse;
            boolean isSuccess;
            BmlUpdateShareResourceResult bmlUpdateShareResourceResult = (BmlUpdateShareResourceResult)result2;
            boolean bl = isSuccess = bmlUpdateShareResourceResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId2 = bmlUpdateShareResourceResult.getResourceId();
                String version = bmlUpdateShareResourceResult.getVersion();
                bmlUpdateResponse = new BmlUpdateResponse(isSuccess, resourceId2, version);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " update resource failed, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, BoxesRunTime.boxToInteger((int)bmlUpdateShareResourceResult.getStatusCode())})));
                bmlUpdateResponse = new BmlUpdateResponse(isSuccess, null, null);
            }
            BmlUpdateResponse bmlUpdateResponse2 = bmlUpdateResponse;
            return bmlUpdateResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlResourceDownloadResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlUpdateResponse updateShareResource(String user, String resourceId, String filePath) {
        return null;
    }

    @Override
    public BmlProjectInfoResponse getProjectInfoByName(String projectName) {
        return null;
    }

    @Override
    public BmlResourceInfoResponse getResourceInfo(String resourceId) {
        return null;
    }

    @Override
    public BmlProjectPrivResponse getProjectPriv(String projectName) {
        return null;
    }

    @Override
    public BmlAttachResourceAndProjectResponse attachResourceAndProject(String projectName, String resourceId) {
        Result result;
        BmlAttachAction bmlAttachAction = new BmlAttachAction();
        bmlAttachAction.setUser(this.getUser());
        bmlAttachAction.getRequestPayloads().put("projectName", projectName);
        bmlAttachAction.getRequestPayloads().put("resourceId", resourceId);
        Result result2 = result = this.dwsClient().execute((Action)bmlAttachAction);
        if (result2 instanceof BmlAttachResult) {
            BmlAttachResourceAndProjectResponse bmlAttachResourceAndProjectResponse;
            boolean isSuccess;
            BmlAttachResult bmlAttachResult = (BmlAttachResult)result2;
            boolean bl = isSuccess = bmlAttachResult.getStatus() == 0;
            if (isSuccess) {
                bmlAttachResourceAndProjectResponse = new BmlAttachResourceAndProjectResponse(isSuccess);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " create bml project, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user, BoxesRunTime.boxToInteger((int)bmlAttachResult.getStatusCode())})));
                bmlAttachResourceAndProjectResponse = new BmlAttachResourceAndProjectResponse(isSuccess);
            }
            BmlAttachResourceAndProjectResponse bmlAttachResourceAndProjectResponse2 = bmlAttachResourceAndProjectResponse;
            return bmlAttachResourceAndProjectResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlCreateBmlProjectResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlUpdateProjectPrivResponse updateProjectPriv(String username, String projectName, List<String> editUsers, List<String> accessUsers) {
        Result result;
        UpdateBmlProjectAction updateBmlProjectAction = new UpdateBmlProjectAction();
        updateBmlProjectAction.setUser(username);
        updateBmlProjectAction.getRequestPayloads().put("projectName", projectName);
        updateBmlProjectAction.getRequestPayloads().put("editUsers", editUsers);
        updateBmlProjectAction.getRequestPayloads().put("accessUsers", accessUsers);
        Result result2 = result = this.dwsClient().execute((Action)updateBmlProjectAction);
        if (result2 instanceof BmlUpdateProjectResult) {
            BmlUpdateProjectPrivResponse bmlUpdateProjectPrivResponse;
            boolean isSuccess;
            BmlUpdateProjectResult bmlUpdateProjectResult = (BmlUpdateProjectResult)result2;
            boolean bl = isSuccess = bmlUpdateProjectResult.getStatus() == 0;
            if (isSuccess) {
                bmlUpdateProjectPrivResponse = new BmlUpdateProjectPrivResponse(isSuccess);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " update bml project, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user, BoxesRunTime.boxToInteger((int)bmlUpdateProjectResult.getStatusCode())})));
                bmlUpdateProjectPrivResponse = new BmlUpdateProjectPrivResponse(isSuccess);
            }
            BmlUpdateProjectPrivResponse bmlUpdateProjectPrivResponse2 = bmlUpdateProjectPrivResponse;
            return bmlUpdateProjectPrivResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlUpdateProjectResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlChangeOwnerResponse changeOwnerByResourceId(String resourceId, String oldOwner, String newOwner) {
        Result result;
        BmlChangeOwnerAction bmlChangeOwnerAction = new BmlChangeOwnerAction();
        bmlChangeOwnerAction.setUser(oldOwner);
        bmlChangeOwnerAction.getRequestPayloads().put("resourceId", resourceId);
        bmlChangeOwnerAction.getRequestPayloads().put("oldOwner", oldOwner);
        bmlChangeOwnerAction.getRequestPayloads().put("newOwner", newOwner);
        Result result2 = result = this.dwsClient().execute((Action)bmlChangeOwnerAction);
        BmlChangeOwnerResponse bmlChangeOwnerResponse = new BmlChangeOwnerResponse(true);
        return bmlChangeOwnerResponse;
    }

    @Override
    public BmlCopyResourceResponse copyResourceToAnotherUser(String resourceId, String anotherUser, String originOwner) {
        Result result;
        BmlCopyResourceAction copyResourceAction = new BmlCopyResourceAction();
        copyResourceAction.setUser(originOwner);
        copyResourceAction.getRequestPayloads().put("resourceId", resourceId);
        copyResourceAction.getRequestPayloads().put("anotherUser", anotherUser);
        Result result2 = result = this.dwsClient().execute((Action)copyResourceAction);
        if (result2 instanceof BmlCopyResourceResult) {
            BmlCopyResourceResponse bmlCopyResourceResponse;
            boolean isSuccess;
            BmlCopyResourceResult bmlCopyResourceResult = (BmlCopyResourceResult)result2;
            boolean bl = isSuccess = bmlCopyResourceResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId2 = bmlCopyResourceResult.getResourceId();
                bmlCopyResourceResponse = new BmlCopyResourceResponse(isSuccess, resourceId2);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " copy resource failed, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user, BoxesRunTime.boxToInteger((int)bmlCopyResourceResult.getStatusCode())})));
                bmlCopyResourceResponse = new BmlCopyResourceResponse(isSuccess, null);
            }
            BmlCopyResourceResponse bmlCopyResourceResponse2 = bmlCopyResourceResponse;
            return bmlCopyResourceResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlCopyResourceResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlRollbackVersionResponse rollbackVersion(String resourceId, String version, String user) {
        Result result;
        BmlRollbackVersionAction rollbackVersionAction = new BmlRollbackVersionAction();
        rollbackVersionAction.setUser(user);
        rollbackVersionAction.getRequestPayloads().put("resourceId", resourceId);
        rollbackVersionAction.getRequestPayloads().put("version", version);
        Result result2 = result = this.dwsClient().execute((Action)rollbackVersionAction);
        if (result2 instanceof BmlRollbackVersionResult) {
            BmlRollbackVersionResponse bmlRollbackVersionResponse;
            boolean isSuccess;
            BmlRollbackVersionResult bmlRollbackVersionResult = (BmlRollbackVersionResult)result2;
            boolean bl = isSuccess = bmlRollbackVersionResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId2 = bmlRollbackVersionResult.getResourceId();
                String version2 = bmlRollbackVersionResult.getVersion();
                bmlRollbackVersionResponse = new BmlRollbackVersionResponse(isSuccess, resourceId2, version2);
            } else {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " rollback version failed, status code is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, BoxesRunTime.boxToInteger((int)bmlRollbackVersionResult.getStatusCode())})));
                bmlRollbackVersionResponse = new BmlRollbackVersionResponse(isSuccess, null, null);
            }
            BmlRollbackVersionResponse bmlRollbackVersionResponse2 = bmlRollbackVersionResponse;
            return bmlRollbackVersionResponse2;
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result type ", " not match BmlRollbackVersionResult"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bmlResult.getResultType()})));
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public void close() {
        this.dwsClient().close();
    }

    public HttpBmlClient(DWSClientConfig clientConfig, String serverUrl, Map<String, Object> properties) {
        this.serverUrl = serverUrl;
        this.properties = properties;
        Logging.class.$init$((Logging)this);
        this.clientName = properties == null ? "BML-Client" : (String)properties.getOrDefault(BmlConfiguration$.MODULE$.CLIENT_NAME_SHORT_NAME(), "BML-Client");
        this.dwsClient = new DWSHttpClient(clientConfig == null ? this.createClientConfig() : clientConfig, this.clientName());
        this.FIRST_VERSION = "v000001";
    }

    public HttpBmlClient(String serverUrl) {
        this(null, null, null);
    }

    public HttpBmlClient() {
        this(null, null, null);
    }

    public HttpBmlClient(DWSClientConfig clientConfig) {
        this(clientConfig, null, null);
    }

    public HttpBmlClient(String serverUrl, Map<String, Object> properties) {
        this(null, serverUrl, properties);
    }
}

