/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.UnifiedLog;
import kafka.server.BrokerServer;
import kafka.server.KafkaConfig$;
import kafka.server.metadata.BrokerMetadataPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.MetadataPublisher;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001B\b\u0011\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013\u00051\u0005\u0003\u0004=\u0001\u0001\u0006I\u0001\n\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u001f\u0002!\tA\u0010\u0005\u0006)\u0002!\tA\u0010\u0005\u00063\u0002!\tA\u0010\u0005\u00067\u0002!I\u0001\u0018\u0005\u0006g\u0002!I\u0001\u001e\u0005\b\u0003G\u0001A\u0011BA\u0013\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kA\u0011\"a\u0017\u0001#\u0003%I!!\u0018\t\r\u0005M\u0004\u0001\"\u0001?\u0011\u0019\ty\b\u0001C\u0001}\tY\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM\u001d+fgRT!!\u0005\n\u0002\u00115,G/\u00193bi\u0006T!a\u0005\u000b\u0002\rM,'O^3s\u0015\u0005)\u0012!B6bM.\f7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0011\u00035)\u00070\u001b;Fq\u000e,\u0007\u000f^5p]V\tA\u0005E\u0002&]Aj\u0011A\n\u0006\u0003O!\na!\u0019;p[&\u001c'BA\u0015+\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003W1\nA!\u001e;jY*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018'\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA\u0019:\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026-\u00051AH]8pizJ\u0011aG\u0005\u0003qi\tq\u0001]1dW\u0006<W-\u0003\u0002;w\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003qi\ta\"\u001a=ji\u0016C8-\u001a9uS>t\u0007%A\u0003tKR,\u0006\u000fF\u0001@!\tI\u0002)\u0003\u0002B5\t!QK\\5uQ\t!1\t\u0005\u0002E\u001b6\tQI\u0003\u0002G\u000f\u0006\u0019\u0011\r]5\u000b\u0005!K\u0015a\u00026va&$XM\u001d\u0006\u0003\u0015.\u000bQA[;oSRT\u0011\u0001T\u0001\u0004_J<\u0017B\u0001(F\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012Q!\u0015\t\u0003\tJK!aU#\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u0005;fgR<U\r\u001e+pa&\u001cG)\u001a7uC\"\u0012aA\u0016\t\u0003\t^K!\u0001W#\u0003\tQ+7\u000f^\u0001\u0016i\u0016\u001cHOR5oIN#(/Y=SKBd\u0017nY1tQ\t9a+A\u0004n_\u000e\\Gj\\4\u0015\u0007u\u001bg\u000e\u0005\u0002_C6\tqL\u0003\u0002a)\u0005\u0019An\\4\n\u0005\t|&AC+oS\u001aLW\r\u001a'pO\")A\r\u0003a\u0001K\u00069Ao\u001c9jG&#\u0007C\u00014m\u001b\u00059'B\u00015j\u0003\u0019\u0019w.\\7p]*\u0011QC\u001b\u0006\u0003W.\u000ba!\u00199bG\",\u0017BA7h\u0005\u0011)V/\u001b3\t\u000b=D\u0001\u0019\u00019\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011a-]\u0005\u0003e\u001e\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0006u_BL7-S7bO\u0016$R!^>}\u0003\u001b\u0001\"A^=\u000e\u0003]T!\u0001_5\u0002\u000b%l\u0017mZ3\n\u0005i<(A\u0003+pa&\u001c\u0017*\\1hK\")A-\u0003a\u0001K\")Q0\u0003a\u0001}\u0006)Ao\u001c9jGB\u0019q0a\u0002\u000f\t\u0005\u0005\u00111\u0001\t\u0003giI1!!\u0002\u001b\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0001\u000e\t\u000f\u0005=\u0011\u00021\u0001\u0002\u0012\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000f}\f\u0019\"a\u0006\u0002\u001e%!\u0011QCA\u0006\u0005\ri\u0015\r\u001d\t\u00043\u0005e\u0011bAA\u000e5\t\u0019\u0011J\u001c;\u0011\u000bE\ny\"a\u0006\n\u0007\u0005\u00052HA\u0002TKF\f1\u0002^8qS\u000e\u001c\u0018*\\1hKR!\u0011qEA\u0017!\r1\u0018\u0011F\u0005\u0004\u0003W9(a\u0003+pa&\u001c7/S7bO\u0016Dq!a\f\u000b\u0001\u0004\t\t$\u0001\u0004u_BL7m\u001d\t\u0005c\u0005}Q/\u0001\toK^lunY6Qk\nd\u0017n\u001d5feR1\u0011qGA\u001f\u0003\u0013\u00022!IA\u001d\u0013\r\tY\u0004\u0005\u0002\u0018\u0005J|7.\u001a:NKR\fG-\u0019;b!V\u0014G.[:iKJDq!a\u0010\f\u0001\u0004\t\t%\u0001\u0004ce>\\WM\u001d\t\u0005\u0003\u0007\n)%D\u0001\u0013\u0013\r\t9E\u0005\u0002\r\u0005J|7.\u001a:TKJ4XM\u001d\u0005\n\u0003\u0017Z\u0001\u0013!a\u0001\u0003\u001b\nA\"\u001a:s_JD\u0015M\u001c3mKJ\u0004B!a\u0014\u0002X5\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n)&A\u0003gCVdGO\u0003\u0002\u0014S&!\u0011\u0011LA)\u000511\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003iqWm^'pG.\u0004VO\u00197jg\",'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tyF\u000b\u0003\u0002N\u0005\u00054FAA2!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055$$\u0001\u0006b]:|G/\u0019;j_:LA!!\u001d\u0002h\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002SQ,7\u000f\u001e*fY>\fG-\u00169eCR,GMR5mKN<\u0016\u000e\u001e5pkR\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tia\u000bK\u0002\u000e\u0003s\u00022\u0001RA>\u0013\r\ti(\u0012\u0002\t\t&\u001c\u0018M\u00197fI\u0006\u0001C/Z:u\u000bb\u001cW\r\u001d;j_:Le.\u00169eCR,7i\\8sI&t\u0017\r^8sQ\tqa\u000b")
public class BrokerMetadataPublisherTest {
    private final AtomicReference<Throwable> exitException = new AtomicReference<Object>(null);

    public AtomicReference<Throwable> exitException() {
        return this.exitException;
    }

    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((code, x$1) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Exit ").append(code).toString())));
        Exit.setHaltProcedure((code, x$2) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Halt ").append(code).toString())));
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        Throwable exception = this.exitException().get();
        if (exception != null) {
            throw exception;
        }
    }

    @Test
    public void testGetTopicDelta() {
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("not-a-topic", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable)() -> "Expected no delta for unknown topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("foo", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable)() -> "Expected no delta for deleted topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("bar", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isDefined(), (Function0 & Serializable)() -> "Expected to see delta for changed topic");
    }

    @Test
    public void testFindStrayReplicas() {
        int brokerId = 0;
        String deletedTopic = "a";
        Uuid deletedTopicId = Uuid.randomUuid();
        TopicPartition deletedTopicPartition1 = new TopicPartition(deletedTopic, 0);
        UnifiedLog deletedTopicLog1 = this.mockLog(deletedTopicId, deletedTopicPartition1);
        TopicPartition deletedTopicPartition2 = new TopicPartition(deletedTopic, 1);
        UnifiedLog deletedTopicLog2 = this.mockLog(deletedTopicId, deletedTopicPartition2);
        String recreatedTopic = "b";
        TopicPartition recreatedTopicPartition = new TopicPartition(recreatedTopic, 0);
        UnifiedLog recreatedTopicLog = this.mockLog(Uuid.randomUuid(), recreatedTopicPartition);
        TopicImage recreatedTopicImage = this.topicImage(Uuid.randomUuid(), recreatedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)recreatedTopicPartition.partition())), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))));
        String reassignedTopic = "c";
        Uuid reassignedTopicId = Uuid.randomUuid();
        TopicPartition reassignedTopicPartition = new TopicPartition(reassignedTopic, 0);
        UnifiedLog reassignedTopicLog = this.mockLog(reassignedTopicId, reassignedTopicPartition);
        TopicPartition retainedTopicPartition = new TopicPartition(reassignedTopic, 1);
        UnifiedLog retainedTopicLog = this.mockLog(reassignedTopicId, retainedTopicPartition);
        TopicImage reassignedTopicImage = this.topicImage(reassignedTopicId, reassignedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)reassignedTopicPartition.partition())), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)retainedTopicPartition.partition())), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3})))}))));
        Seq logs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnifiedLog[]{deletedTopicLog1, deletedTopicLog2, recreatedTopicLog, reassignedTopicLog, retainedTopicLog}));
        TopicsImage image = this.topicsImage((Seq<TopicImage>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicImage[]{recreatedTopicImage, reassignedTopicImage}))));
        Set expectedStrayPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{deletedTopicPartition1, deletedTopicPartition2, recreatedTopicPartition, reassignedTopicPartition}));
        Set strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, image, (Iterable)logs).toSet();
        Assertions.assertEquals((Object)expectedStrayPartitions, (Object)strayPartitions);
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog mockLog(Uuid topicId, TopicPartition topicPartition) {
        void var3_3;
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        return var3_3;
    }

    private TopicImage topicImage(Uuid topicId, String topic, scala.collection.immutable.Map<Object, Seq<Object>> partitions) {
        scala.collection.immutable.Map partitionRegistrations = (scala.collection.immutable.Map)partitions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partitionId = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionRegistration((int[])replicas.toArray((ClassTag)ClassTag$.MODULE$.Int()), (int[])replicas.toArray((ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), BoxesRunTime.unboxToInt((Object)replicas.head()), LeaderRecoveryState.RECOVERED, 0, 0));
            return tuple2;
        });
        return new TopicImage(topic, topicId, CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionRegistrations).asJava());
    }

    private TopicsImage topicsImage(Seq<TopicImage> topics) {
        scala.collection.immutable.Map idsMap = ((IterableOnceOps)topics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.id()), t))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map namesMap = ((IterableOnceOps)topics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.name()), t))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new TopicsImage(CollectionConverters$.MODULE$.MapHasAsJava((Map)idsMap).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)namesMap).asJava());
    }

    private BrokerMetadataPublisher newMockPublisher(BrokerServer broker, FaultHandler errorHandler) {
        return (BrokerMetadataPublisher)Mockito.spy((Object)new BrokerMetadataPublisher(broker.config(), broker.metadataCache(), broker.logManager(), broker.replicaManager(), broker.groupCoordinator(), broker.transactionCoordinator(), broker.clientQuotaMetadataManager(), broker.dynamicConfigHandlers().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), Option$.MODULE$.empty(), errorHandler, errorHandler));
    }

    private FaultHandler newMockPublisher$default$2() {
        return new MockFaultHandler("publisher");
    }

    @Disabled
    @Test
    public void testReloadUpdatedFilesWithoutConfigChange() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            BrokerMetadataPublisher publisher = this.newMockPublisher(broker, (FaultHandler)new MockFaultHandler("publisher"));
            AtomicInteger numTimesReloadCalled = new AtomicInteger(0);
            publisher.reloadUpdatedFilesWithoutConfigChange((Properties)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, numTimesReloadCalled){
                private final AtomicInteger numTimesReloadCalled$1;

                public void answer(InvocationOnMock invocation) {
                    this.numTimesReloadCalled$1.addAndGet(1);
                }
                {
                    this.numTimesReloadCalled$1 = numTimesReloadCalled$1;
                }
            });
            broker.metadataListener().alterPublisher((MetadataPublisher)publisher).get();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((int)0, (int)numTimesReloadCalled.get());
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l = 15000L;
                long l2 = 100L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$1(numTimesReloadCalled)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                        Assertions.fail((String)"numTimesConfigured never reached desired value");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(broker.config().nodeId())), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l3 = 15000L;
                long l4 = 100L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$3(numTimesReloadCalled)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                        Assertions.fail((String)"numTimesConfigured never reached desired value");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExceptionInUpdateCoordinator() {
        MockFaultHandler errorHandler = new MockFaultHandler("publisher");
        KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setMetadataFaultHandler(errorHandler).build();
        try {
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$1(broker);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String string;
                        String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        string = null;
                        String msgWithLogIdent_msg = string2;
                        Object var20_8 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var8_5 = null;
            Object var13_11 = null;
            BrokerMetadataPublisher publisher = (BrokerMetadataPublisher)Mockito.spy((Object)broker.metadataPublisher());
            ((BrokerMetadataPublisher)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("injected failure")}).when((Object)publisher)).updateCoordinator((MetadataImage)ArgumentMatchers.any(), (MetadataDelta)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any());
            broker.metadataListener().alterPublisher((MetadataPublisher)publisher).get();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.createTopics(Collections.singletonList(new NewTopic("foo", 1, (short)1))).all().get();
            }
            long l3 = 60000L;
            TestUtils$ retry_this2 = TestUtils$.MODULE$;
            long l4 = 1L;
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$2(errorHandler);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        String string;
                        String string3 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                        string = null;
                        String msgWithLogIdent_msg = string3;
                        Object var21_21 = null;
                        retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l4);
                    l4 += scala.math.package$.MODULE$.min(l4, 1000L);
                    continue;
                }
                break;
            }
            Object var14_16 = null;
            Object var19_20 = null;
        }
        finally {
            errorHandler.setIgnore(true);
            cluster.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$1(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 0;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$2() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$3(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 1;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$4() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$1(BrokerServer broker$1) {
        Assertions.assertNotNull((Object)broker$1.metadataPublisher());
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$2(MockFaultHandler errorHandler$1) {
        Assertions.assertTrue((boolean)((String)Option$.MODULE$.apply((Object)errorHandler$1.firstException()).flatMap((Function1 & Serializable)e -> Option$.MODULE$.apply((Object)e.getMessage())).getOrElse((Function0 & Serializable)() -> "(none)")).contains("injected failure"));
    }
}

