/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import kafka.tools.ConsumerPerformance;
import kafka.tools.ConsumerPerformance$;
import kafka.utils.Exit$;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Console$;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\t\rE\u0002\u0001\u0015!\u0003,\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u0015!\u0005\u0001\"\u00014\u0011\u00151\u0005\u0001\"\u00014\u0011\u0015A\u0005\u0001\"\u00014\u0011\u0015Q\u0005\u0001\"\u00014\u0011\u0015a\u0005\u0001\"\u00014\u0011\u0015q\u0005\u0001\"\u0003P\u0005]\u0019uN\\:v[\u0016\u0014\b+\u001a:g_Jl\u0017M\\2f)\u0016\u001cHO\u0003\u0002\u0010!\u0005)Ao\\8mg*\t\u0011#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u001d\u0005Qq.\u001e;D_:$XM\u001c;\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0005%|'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.A\u0006pkR\u001cuN\u001c;f]R\u0004\u0013A\u00033bi\u00164uN]7biV\t1\u0006\u0005\u0002-_5\tQF\u0003\u0002/I\u0005!A/\u001a=u\u0013\t\u0001TF\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\u0006YA-\u0019;f\r>\u0014X.\u0019;!\u0003m!Xm\u001d;EKR\f\u0017\u000e\\3e\u0011\u0016\fG-\u001a:NCR\u001c\u0007NQ8esR\tA\u0007\u0005\u0002\u0016k%\u0011aG\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0007qA\u0011\u0011HQ\u0007\u0002u)\u00111\bP\u0001\u0004CBL'BA\u001f?\u0003\u001dQW\u000f]5uKJT!a\u0010!\u0002\u000b),h.\u001b;\u000b\u0003\u0005\u000b1a\u001c:h\u0013\t\u0019%H\u0001\u0003UKN$\u0018A\b;fgRtuN\u001c#fi\u0006LG.\u001a3IK\u0006$WM]'bi\u000eD'i\u001c3zQ\t9\u0001(\u0001\u000buKN$8i\u001c8gS\u001e\u0014%o\\6fe2K7\u000f\u001e\u0015\u0003\u0011a\n\u0011\u0004^3ti\u000e{gNZ5h\u0005>|Go\u0015;sCB\u001cVM\u001d<fe\"\u0012\u0011\u0002O\u0001\u0017i\u0016\u001cHO\u0011:pW\u0016\u0014H*[:u\u001fZ,'O]5eK\"\u0012!\u0002O\u0001!i\u0016\u001cHoQ8oM&<w+\u001b;i+:\u0014XmY8h]&TX\rZ(qi&|g\u000e\u000b\u0002\fq\u00051B/Z:u\u0011\u0016\fG-\u001a:NCR\u001c\u0007nQ8oi\u0016tG\u000f\u0006\u00035!VS\u0006\"B)\r\u0001\u0004\u0011\u0016\u0001\u00033fi\u0006LG.\u001a3\u0011\u0005U\u0019\u0016B\u0001+\u0017\u0005\u001d\u0011un\u001c7fC:DQA\u0016\u0007A\u0002]\u000bq#\u001a=qK\u000e$X\rZ(viB,H\u000fT5oK\u000e{WO\u001c;\u0011\u0005UA\u0016BA-\u0017\u0005\rIe\u000e\u001e\u0005\u000672\u0001\r\u0001X\u0001\u0004MVt\u0007cA\u000b^i%\u0011aL\u0006\u0002\n\rVt7\r^5p]B\u0002")
public class ConsumerPerformanceTest {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    private ByteArrayOutputStream outContent() {
        return this.outContent;
    }

    private SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDetailedHeaderMatchBody() {
        void testHeaderMatchContent_fun;
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerPerformance$.MODULE$.printConsumerProgress(1, 0x100000L, 0L, 1L, 0L, 0L, 1L, this.dateFormat(), 1L);
        int testHeaderMatchContent_expectedOutputLineCount = 2;
        boolean testHeaderMatchContent_detailed = true;
        Console$.MODULE$.withOut((OutputStream)this.outContent(), (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerPerformanceTest.$anonfun$testHeaderMatchContent$1(this, testHeaderMatchContent_detailed, (Function0)testHeaderMatchContent_fun, testHeaderMatchContent_expectedOutputLineCount)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNonDetailedHeaderMatchBody() {
        void testHeaderMatchContent_fun;
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.println((Object)new StringBuilder(36).append(this.dateFormat().format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()))).append(", ").append(this.dateFormat().format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()))).append(", 1.0, 1.0, 1, 1.0, 1, 1, 1.1, 1.1").toString());
        int testHeaderMatchContent_expectedOutputLineCount = 2;
        boolean testHeaderMatchContent_detailed = false;
        Console$.MODULE$.withOut((OutputStream)this.outContent(), (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerPerformanceTest.$anonfun$testHeaderMatchContent$1(this, testHeaderMatchContent_detailed, (Function0)testHeaderMatchContent_fun, testHeaderMatchContent_expectedOutputLineCount)));
    }

    @Test
    public void testConfigBrokerList() {
        String[] args = (String[])((Object[])new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10"});
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertEquals((Object)"test", (Object)config.topic());
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testConfigBootStrapServer() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10", "--print-metrics"});
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertEquals((Object)"test", (Object)config.topic());
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testBrokerListOverride() {
        String[] args = (String[])((Object[])new String[]{"--broker-list", "localhost:9094", "--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10"});
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertEquals((Object)"test", (Object)config.topic());
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConfigWithUnrecognizedOption() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, message) -> ConsumerPerformanceTest.$anonfun$testConfigWithUnrecognizedOption$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10", "--new-consumer"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsumerPerformance.ConsumerPerfConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    private void testHeaderMatchContent(boolean detailed, int expectedOutputLineCount, Function0<BoxedUnit> fun) {
        Console$.MODULE$.withOut((OutputStream)this.outContent(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ConsumerPerformance$.MODULE$.printHeader(detailed);
            fun.apply$mcV$sp();
            String[] contents = this.outContent().toString().split("\n");
            Assertions.assertEquals((int)expectedOutputLineCount, (int)contents.length);
            String header = contents[0];
            String body = contents[1];
            Assertions.assertEquals((int)header.split(",").length, (int)body.split(",").length);
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$testConfigWithUnrecognizedOption$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }
}

