/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.log.LogManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\f\u0019\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001A\u0002\u0013\u0005\u0011\u0006C\u0004.\u0001\u0001\u0007I\u0011\u0001\u0018\t\r]\u0002\u0001\u0015)\u0003+\u0011\u001dA\u0004A1A\u0005\u0002eBaA\u0011\u0001!\u0002\u0013Q\u0004bB\"\u0001\u0005\u0004%\t!\u000f\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001e\t\u000f\u0015\u0003!\u0019!C\u0001\r\"1q\n\u0001Q\u0001\n\u001dCq\u0001\u0015\u0001C\u0002\u0013\u0005a\t\u0003\u0004R\u0001\u0001\u0006Ia\u0012\u0005\u0006%\u0002!\te\u0015\u0005\u0006C\u0002!\ta\u0015\u0005\u0006M\u0002!\ta\u0015\u0005\u0006Q\u0002!\ta\u0015\u0005\u0006U\u0002!\ta\u0015\u0005\u0006Y\u0002!I!\u001c\u0005\t\u00037\u0001\u0001\u0015\"\u0003\u0002\u001e!1\u0011q\u0006\u0001\u0005\u0002MCa!!\r\u0001\t\u0003\u0019\u0006BBA\u001b\u0001\u0011\u00051K\u0001\nTKJ4XM]*ikR$wn\u001e8UKN$(BA\r\u001b\u0003\u0019\u0019XM\u001d<fe*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#BA\u0011\u001b\u0003\tQ8.\u0003\u0002$A\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0014\u0011\u0005\u001d\u0002Q\"\u0001\r\u0002\r\r|gNZ5h+\u0005Q\u0003CA\u0014,\u0013\ta\u0003DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0005+:LG\u000fC\u00047\u0007\u0005\u0005\t\u0019\u0001\u0016\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\t!|7\u000f^\u000b\u0002uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0005Y\u0006twMC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$AB*ue&tw-A\u0003i_N$\b%A\u0003u_BL7-\u0001\u0004u_BL7\rI\u0001\u0006g\u0016tG/M\u000b\u0002\u000fB\u0019\u0001*\u0014\u001e\u000e\u0003%S!AS&\u0002\u0013%lW.\u001e;bE2,'B\u0001'2\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001d&\u0013A\u0001T5ti\u000611/\u001a8uc\u0001\nQa]3oiJ\naa]3oiJ\u0002\u0013!B:fiV\u0003H#A\u0018)\u00055)\u0006C\u0001,`\u001b\u00059&B\u0001-Z\u0003\r\t\u0007/\u001b\u0006\u00035n\u000bqA[;qSR,'O\u0003\u0002];\u0006)!.\u001e8ji*\ta,A\u0002pe\u001eL!\u0001Y,\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\tuKN$8\t\\3b]NCW\u000f\u001e3po:D#AD2\u0011\u0005Y#\u0017BA3X\u0005\u0011!Vm\u001d;\u0002OQ,7\u000f^\"mK\u0006t7\u000b[;uI><hnV5uQ\u0012+G.\u001a;f)>\u0004\u0018nY#oC\ndW\r\u001a\u0015\u0003\u001f\r\f1\u0005^3ti\u000ecW-\u00198TQV$Hm\\<o\u0003\u001a$XM\u001d$bS2,Gm\u0015;beR,\b\u000f\u000b\u0002\u0011G\u0006\u0019D/Z:u\u00072,\u0017M\\*ikR$wn\u001e8BMR,'OR1jY\u0016$7\u000b^1siV\u0004H)^3U_\u000e{'O];qi2{wm\u001d\u0015\u0003#\r\fQE^3sS\u001aL8\t\\3b]NCW\u000f\u001e3po:\fe\r^3s\r\u0006LG.\u001a3Ti\u0006\u0014H/\u001e9\u0016\u00059THcA8\u0002\u001aQ\u0011q\u0006\u001d\u0005\u0006cJ\u0001\u001dA]\u0001\u0012Kb\u001cW\r\u001d;j_:\u001cE.Y:t)\u0006<\u0007cA:wq6\tAO\u0003\u0002vc\u00059!/\u001a4mK\u000e$\u0018BA<u\u0005!\u0019E.Y:t)\u0006<\u0007CA={\u0019\u0001!Qa\u001f\nC\u0002q\u0014\u0011!R\t\u0004{\u0006\u0005\u0001C\u0001\u0019\u007f\u0013\ty\u0018GA\u0004O_RD\u0017N\\4\u0011\t\u0005\r\u00111\u0003\b\u0005\u0003\u000b\tyA\u0004\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tY\u0001H\u0001\u0007yI|w\u000e\u001e \n\u0003IJ1!!\u00052\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0006\u0002\u0018\tIQ\t_2faRLwN\u001c\u0006\u0004\u0003#\t\u0004\"\u0002\u0015\u0013\u0001\u0004Q\u0013AF5t\u001d>tG)Y3n_:\\\u0015MZ6b)\"\u0014X-\u00193\u0015\t\u0005}\u0011Q\u0005\t\u0004a\u0005\u0005\u0012bAA\u0012c\t9!i\\8mK\u0006t\u0007bBA\u0014'\u0001\u0007\u0011\u0011F\u0001\u0002iB\u00191(a\u000b\n\u0007\u00055BH\u0001\u0004UQJ,\u0017\rZ\u0001\u001dm\u0016\u0014\u0018NZ=O_:$\u0015-Z7p]RC'/Z1egN#\u0018\r^;t\u0003]!Xm\u001d;D_:\u001cXmY;uSZ,7\u000b[;uI><h\u000e\u000b\u0002\u0016G\u0006\u0001C/Z:u\u0007>tGO]8mY\u0016\u00148\u000b[;uI><h\u000eR;sS:<7+\u001a8eQ\t12\r")
public class ServerShutdownTest
extends ZooKeeperTestHarness {
    private KafkaConfig config = null;
    private final String host;
    private final String topic;
    private final List<String> sent1 = new .colon.colon((Object)"hello", (List)new .colon.colon((Object)"there", (List)Nil$.MODULE$));
    private final List<String> sent2 = new .colon.colon((Object)"more", (List)new .colon.colon((Object)"messages", (List)Nil$.MODULE$));

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @Test
    public void testCleanShutdown() {
        KafkaConfig x$12 = this.config();
        Option x$22 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$32 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$42 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$12, x$32, x$22, x$42);
        server.startup();
        ObjectRef producer = ObjectRef.create((Object)ServerShutdownTest.createProducer$1(server));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$), TestUtils$.MODULE$.createTopic$default$6());
        ((List)this.sent1().map((Function1 & Serializable & scala.Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> (RecordMetadata)x$1.get());
        server.shutdown();
        this.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        server = new KafkaServer(this.config(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$), this.topic(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        producer.elem = ServerShutdownTest.createProducer$1(server);
        KafkaConsumer consumer = ServerShutdownTest.createConsumer$1(server);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.value(), Seq$.MODULE$.canBuildFrom()));
        ((List)this.sent2().map((Function1 & Serializable & scala.Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.value(), Seq$.MODULE$.canBuildFrom()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
        server.shutdown();
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Test
    public void testCleanShutdownWithDeleteTopicEnabled() {
        Properties newProps = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        newProps.setProperty("delete.topic.enable", "true");
        KafkaConfig newConfig = KafkaConfig$.MODULE$.fromProps(newProps);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(newConfig, x$3, x$2, x$4);
        server.startup();
        server.shutdown();
        server.awaitShutdown();
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Test
    public void testCleanShutdownAfterFailedStartup() {
        Properties newProps = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        newProps.setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
        newProps.setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
        KafkaConfig newConfig = KafkaConfig$.MODULE$.fromProps(newProps);
        this.verifyCleanShutdownAfterFailedStartup(newConfig, ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
    }

    @Test
    public void testCleanShutdownAfterFailedStartupDueToCorruptLogs() {
        KafkaServer server = new KafkaServer(this.config(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$), TestUtils$.MODULE$.createTopic$default$6());
        server.shutdown();
        server.awaitShutdown();
        this.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)dirName -> {
            ServerShutdownTest.$anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$1(this, dirName);
            return BoxedUnit.UNIT;
        });
        this.verifyCleanShutdownAfterFailedStartup(this.config(), ClassTag$.MODULE$.apply(KafkaStorageException.class));
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(KafkaConfig config, ClassTag<E> exceptionClassTag) {
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(config, x$3, x$2, x$4);
        try {
            try {
                server.startup();
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)exceptionClassTag.runtimeClass().isInstance(e), (String)new StringBuilder(21).append("Unexpected exception ").append(e).toString());
                Assertions.assertEquals((Object)BrokerState.NOT_RUNNING, server.brokerState().get());
            }
        }
        finally {
            Object v = server.brokerState().get();
            BrokerState brokerState = BrokerState.NOT_RUNNING;
            if (v == null ? brokerState != null : !v.equals(brokerState)) {
                server.shutdown();
            }
            server.awaitShutdown();
        }
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray())).map((Function1 & Serializable & scala.Serializable)x$5 -> (Thread)x$5, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Thread.class))))).count((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @Test
    public void testConsecutiveShutdown() {
        KafkaServer server = new KafkaServer(this.config(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        server.shutdown();
        server.awaitShutdown();
        server.shutdown();
    }

    @Test
    public void testControllerShutdownDuringSend() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
            ((ControllerChannelManager)controllerChannelManager.elem).startup();
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 1, 0L, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), Collections.singletonMap(this.topic(), Uuid.randomUuid()), (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)brokerAndEpochs.keys().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.node(listenerName), Iterable$.MODULE$.canBuildFrom())).toSet()).asJava());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            int x$1 = 1;
            Function1 x$3 = qual$1.sendRequest$default$3();
            qual$1.sendRequest(x$1, (AbstractControlRequest.Builder)requestBuilder, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private static final KafkaProducer createProducer$1(KafkaServer server) {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        return TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3, x$16);
    }

    private static final KafkaConsumer createConsumer$1(KafkaServer server) {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$2 = SecurityProtocol.PLAINTEXT;
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String x$5 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$7 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$8 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$9 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$10 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$11 = TestUtils$.MODULE$.createConsumer$default$9();
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, x$6, x$7, x$8, x$9, x$2, x$10, x$11, x$3, x$4);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }
}

