/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import kafka.cluster.Partition;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.server.RaftReplicaChangeDelegate;
import kafka.server.RaftReplicaChangeDelegateHelper;
import kafka.server.ReplicaAlterLogDirsManager;
import kafka.server.ReplicaFetcherManager;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MetadataBroker;
import kafka.server.metadata.MetadataBrokers;
import kafka.server.metadata.MetadataPartition;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154Aa\u0002\u0005\u0001\u001b!)A\u0003\u0001C\u0001+!9\u0001\u0004\u0001b\u0001\n\u0013I\u0002BB\u0014\u0001A\u0003%!\u0004C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003I\u0001\u0011%\u0011\nC\u0003a\u0001\u0011%\u0011MA\u000fSC\u001a$(+\u001a9mS\u000e\f7\t[1oO\u0016$U\r\\3hCR,G+Z:u\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0006\t\u0003/\u0001i\u0011\u0001C\u0001\rY&\u001cH/\u001a8fe:\u000bW.Z\u000b\u00025A\u00111$J\u0007\u00029)\u0011QDH\u0001\b]\u0016$xo\u001c:l\u0015\ty\u0002%\u0001\u0004d_6lwN\u001c\u0006\u0003\u0017\u0005R!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO&\u0011a\u0005\b\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u000eY&\u001cH/\u001a8fe:\u000bW.\u001a\u0011\u00027Q,7\u000f\u001e'fC\u0012,'/\u00118e\u0013N\u0014\bK]8qC\u001e\fG/[8o)\tQS\u0006\u0005\u0002\u0010W%\u0011A\u0006\u0005\u0002\u0005+:LG\u000fC\u0003/\t\u0001\u0007q&\u0001\u0005jg2+\u0017\rZ3s!\ty\u0001'\u0003\u00022!\t9!i\\8mK\u0006t\u0007\u0006\u0002\u00034\u007f\u0001\u0003\"\u0001N\u001f\u000e\u0003UR!AN\u001c\u0002\u0011A\u0014xN^5eKJT!\u0001O\u001d\u0002\rA\f'/Y7t\u0015\tQ4(A\u0004kkBLG/\u001a:\u000b\u0005q\u001a\u0013!\u00026v]&$\u0018B\u0001 6\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]Nd#!\u0011\"\u001a\u0003\u0005I\u0012\u0001\u0001\u0015\u0003\t\u0011\u0003\"!\u0012$\u000e\u0003]J!aR\u001c\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0007bY&4XM\u0011:pW\u0016\u00148\u000f\u0006\u0002K!B\u00111JT\u0007\u0002\u0019*\u0011Q\nC\u0001\t[\u0016$\u0018\rZ1uC&\u0011q\n\u0014\u0002\u0010\u001b\u0016$\u0018\rZ1uC\n\u0013xn[3sg\")\u0011+\u0002a\u0001%\u0006A!/\u001a9mS\u000e\f7\u000fE\u0002T1jk\u0011\u0001\u0016\u0006\u0003+Z\u000bA!\u001e;jY*\tq+\u0001\u0003kCZ\f\u0017BA-U\u0005\u0011a\u0015n\u001d;\u0011\u0005msV\"\u0001/\u000b\u0005u3\u0016\u0001\u00027b]\u001eL!a\u0018/\u0003\u000f%sG/Z4fe\u0006aQn\\2lK\u0012DU\r\u001c9feR\t!\r\u0005\u0002\u0018G&\u0011A\r\u0003\u0002 %\u00064GOU3qY&\u001c\u0017m\u00115b]\u001e,G)\u001a7fO\u0006$X\rS3ma\u0016\u0014\b")
public class RaftReplicaChangeDelegateTest {
    private final ListenerName listenerName = new ListenerName("PLAINTEXT");

    private ListenerName listenerName() {
        return this.listenerName;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeaderAndIsrPropagation(boolean isLeader) {
        Set set;
        int leaderId = 0;
        TopicPartition topicPartition = new TopicPartition("foo", 5);
        List replicas = (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))).map((Function1 & Serializable & scala.Serializable)x -> RaftReplicaChangeDelegateTest.$anonfun$testLeaderAndIsrPropagation$1(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava();
        RaftReplicaChangeDelegateHelper helper = this.mockedHelper();
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)topicPartition);
        OffsetCheckpoints highWatermarkCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        Mockito.when((Object)highWatermarkCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)topicPartition))).thenReturn((Object)None$.MODULE$);
        MetadataPartition metadataPartition = new MetadataPartition(topicPartition.topic(), topicPartition.partition(), leaderId, 27, replicas, replicas, 50, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState expectedLeaderAndIsr = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topicPartition.topic()).setPartitionIndex(topicPartition.partition()).setIsNew(true).setLeader(leaderId).setLeaderEpoch(27).setReplicas(replicas).setIsr(replicas).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()).setZkVersion(50);
        RaftReplicaChangeDelegate delegate = new RaftReplicaChangeDelegate(helper);
        if (isLeader) {
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.makeLeader(expectedLeaderAndIsr, highWatermarkCheckpoints))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            set = delegate.makeLeaders((Set)Predef$.MODULE$.Set().empty(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)metadataPartition)})), highWatermarkCheckpoints, (Option)new Some((Object)BoxesRunTime.boxToLong((long)500L)));
        } else {
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.makeFollower(expectedLeaderAndIsr, highWatermarkCheckpoints))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            Mockito.when((Object)partition.leaderReplicaIdOpt()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
            set = delegate.makeFollowers((Set)Predef$.MODULE$.Set().empty(), this.aliveBrokers(replicas), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)metadataPartition)})), highWatermarkCheckpoints, (Option)new Some((Object)BoxesRunTime.boxToLong((long)500L)));
        }
        Set updatedPartitions = set;
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})), (Object)updatedPartitions);
    }

    private MetadataBrokers aliveBrokers(List<Integer> replicas) {
        scala.collection.immutable.Map brokers = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1 & Serializable & scala.Serializable)replicaId -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(replicaId), (Object)new MetadataBroker(Predef$.MODULE$.Integer2int(replicaId), "", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.listenerName().value()), (Object)RaftReplicaChangeDelegateTest.mkNode$1(Predef$.MODULE$.Integer2int(replicaId)))})), false)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new MetadataBrokers((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers.values().toList()).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)brokers).asJava());
    }

    /*
     * WARNING - void declaration
     */
    private RaftReplicaChangeDelegateHelper mockedHelper() {
        void var1_1;
        RaftReplicaChangeDelegateHelper helper = (RaftReplicaChangeDelegateHelper)Mockito.mock(RaftReplicaChangeDelegateHelper.class);
        StateChangeLogger stateChangeLogger = (StateChangeLogger)Mockito.mock(StateChangeLogger.class);
        Mockito.when((Object)helper.stateChangeLogger()).thenReturn((Object)stateChangeLogger);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateChangeLogger.isDebugEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateChangeLogger.isTraceEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ReplicaFetcherManager replicaFetcherManager = (ReplicaFetcherManager)Mockito.mock(ReplicaFetcherManager.class);
        Mockito.when((Object)helper.replicaFetcherManager()).thenReturn((Object)replicaFetcherManager);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        Mockito.when((Object)helper.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)config.interBrokerListenerName()).thenReturn((Object)this.listenerName());
        Mockito.when((Object)helper.config()).thenReturn((Object)config);
        return var1_1;
    }

    public static final /* synthetic */ Integer $anonfun$testLeaderAndIsrPropagation$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private static final Node mkNode$1(int replicaId) {
        return new Node(replicaId, "localhost", 9092 + replicaId, "");
    }
}

