/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-3AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0003a\u0002B\u0002\u0016\u0001A\u0003%Q\u0004C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\t\rE\u0002\u0001\u0015!\u0003.\u0011\u0015\u0011\u0004\u0001\"\u00114\u0011\u0015!\u0005\u0001\"\u00014\u0011\u0015I\u0005\u0001\"\u00014\u0011\u0015Q\u0005\u0001\"\u00014\u0005M\tEM^3si&\u001cXM\u0011:pW\u0016\u0014H+Z:u\u0015\taQ\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\t!R\"\u0001\u0002{W&\u0011ac\u0005\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005Y\u0011aB:feZ,'o]\u000b\u0002;A\u0019a$J\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u000f5,H/\u00192mK*\u0011!eI\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019z\"aC!se\u0006L()\u001e4gKJ\u0004\"A\u0007\u0015\n\u0005%Z!aC&bM.\f7+\u001a:wKJ\f\u0001b]3sm\u0016\u00148\u000fI\u0001\tEJ|7.\u001a:JIV\tQ\u0006\u0005\u0002/_5\t1%\u0003\u00021G\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003Q\u0002\"AL\u001b\n\u0005Y\u001a#\u0001B+oSRD#A\u0002\u001d\u0011\u0005e\u0012U\"\u0001\u001e\u000b\u0005mb\u0014aA1qS*\u0011QHP\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty\u0004)A\u0003kk:LGOC\u0001B\u0003\ry'oZ\u0005\u0003\u0007j\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002MQ,7\u000f\u001e\"s_.,'/\u00113wKJ$\u0018n]3I_N$h*Y7f\u0003:$\u0007k\u001c:u)>T6\n\u000b\u0002\b\rB\u0011\u0011hR\u0005\u0003\u0011j\u0012A\u0001V3ti\u0006\u0001C/Z:u\u0005J|7.\u001a:BIZ,'\u000f^5tK2K7\u000f^3oKJ\u001cHk\u001c.L\u0003=\"Xm\u001d;Ce>\\WM]!em\u0016\u0014H/[:f\u0019&\u001cH/\u001a8feN<\u0016\u000e\u001e5DkN$x.\u001c(b[\u0016\u001cHk\u001c.L\u0001")
public class AdvertiseBrokerTest
extends ZooKeeperTestHarness {
    private final ArrayBuffer<KafkaServer> servers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final int brokerId;

    public ArrayBuffer<KafkaServer> servers() {
        return this.servers;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
        super.tearDown();
    }

    @Test
    public void testBrokerAdvertiseHostNameAndPortToZK() {
        String advertisedHostName = "routable-host1";
        int advertisedPort = 1234;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("advertised.host.name", advertisedHostName);
        props.put("advertised.port", Integer.toString(advertisedPort));
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkClient().getBroker(this.brokerId()).get();
        Assertions.assertEquals((int)1, (int)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assertions.assertEquals((Object)advertisedHostName, (Object)endpoint.host());
        Assertions.assertEquals((int)advertisedPort, (int)endpoint.port());
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)endpoint.listenerName().value());
    }

    public void testBrokerAdvertiseListenersToZK() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("advertised.listeners", "PLAINTEXT://routable-listener:3334");
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkClient().getBroker(this.brokerId()).get();
        Assertions.assertEquals((int)1, (int)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assertions.assertEquals((Object)"routable-listener", (Object)endpoint.host());
        Assertions.assertEquals((int)3334, (int)endpoint.port());
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)endpoint.listenerName());
    }

    public void testBrokerAdvertiseListenersWithCustomNamesToZK() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("listeners", "INTERNAL://:0,EXTERNAL://:0");
        props.put("advertised.listeners", "EXTERNAL://external-listener:9999,INTERNAL://internal-listener:10999");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT,EXTERNAL:PLAINTEXT");
        props.put("inter.broker.listener.name", "INTERNAL");
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkClient().getBroker(this.brokerId()).get();
        Assertions.assertEquals((int)1, (int)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assertions.assertEquals((Object)"external-listener", (Object)endpoint.host());
        Assertions.assertEquals((int)9999, (int)endpoint.port());
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assertions.assertEquals((Object)"EXTERNAL", (Object)endpoint.listenerName().value());
        EndPoint endpoint2 = (EndPoint)brokerInfo.endPoints().apply(1);
        Assertions.assertEquals((Object)"internal-listener", (Object)endpoint2.host());
        Assertions.assertEquals((int)10999, (int)endpoint2.port());
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assertions.assertEquals((Object)"INTERNAL", (Object)endpoint2.listenerName());
    }

    public AdvertiseBrokerTest() {
        this.brokerId = 0;
    }
}

