/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.Group$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rua\u0001\u0002*T\u0001iCQ!\u0019\u0001\u0005\u0002\tDq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004k\u0001\u0001\u0006Ia\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0003g\u0011\u0019a\u0007\u0001)A\u0005O\"9Q\u000e\u0001b\u0001\n\u00131\u0007B\u00028\u0001A\u0003%q\rC\u0004p\u0001\t\u0007I\u0011\u00029\t\rQ\u0004\u0001\u0015!\u0003r\u0011\u001d)\bA1A\u0005\nADaA\u001e\u0001!\u0002\u0013\t\bbB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007y\u0002\u0001\u000b\u0011B=\t\u000fu\u0004!\u0019!C\u0005q\"1a\u0010\u0001Q\u0001\neD\u0011b \u0001A\u0002\u0003\u0007I\u0011\u00029\t\u0017\u0005\u0005\u0001\u00011AA\u0002\u0013%\u00111\u0001\u0005\u000b\u0003+\u0001\u0001\u0019!A!B\u0013\t\b\"CA\f\u0001\t\u0007I\u0011BA\r\u0011!\tY\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0017\u0001\t\u0007I\u0011BA\r\u0011!\ty\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0011!\ty\u0005\u0001Q\u0001\n\u0005U\u0002\"CA)\u0001\t\u0007I\u0011BA*\u0011!\t)\b\u0001Q\u0001\n\u0005U\u0003bCA<\u0001\u0001\u0007\t\u0019!C\u0005\u0003sB1\"a\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n\"Y\u0011Q\u0012\u0001A\u0002\u0003\u0005\u000b\u0015BA>\u0011-\ty\t\u0001a\u0001\u0002\u0004%I!!%\t\u0017\u0005}\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0015\u0005\f\u0003K\u0003\u0001\u0019!A!B\u0013\t\u0019J\u0002\u0004\u0002(\u0002\u0001\u0011\u0011\u0016\u0005\u000b\u0003W\u000b#\u0011!Q\u0001\n\u00055\u0006BCA^C\t\u0005\t\u0015!\u0003\u0002.\"1\u0011-\tC\u0001\u0003{Cq!a2\"\t\u0003\nI\rC\u0004\u0002\\\u0002!\t%!8\t\u000f\u0005U\b\u0001\"\u0011\u0002^\"9\u0011q \u0001\u0005\u0002\u0005u\u0007b\u0002B\u0005\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005\u001b\u0001A\u0011AAo\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003;DqA!\u0006\u0001\t\u0003\ti\u000eC\u0004\u0003\u001a\u0001!\t!!8\t\u000f\tu\u0001\u0001\"\u0001\u0002^\"9!\u0011\u0005\u0001\u0005\u0002\u0005u\u0007b\u0002B\u0013\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005S\u0001A\u0011AAo\u0011\u001d\u0011i\u0003\u0001C\u0001\u0003;DqA!\r\u0001\t\u0003\ti\u000eC\u0004\u00036\u0001!\t!!8\t\u000f\te\u0002\u0001\"\u0001\u0002^\"9!Q\b\u0001\u0005\u0002\u0005u\u0007b\u0002B!\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005\u000b\u0002A\u0011AAo\u0011\u001d\u0011I\u0005\u0001C\u0001\u0003;DqA!\u0014\u0001\t\u0013\u0011y\u0005C\u0004\u0003f\u0001!IAa\u001a\t\u000f\t=\u0004\u0001\"\u0001\u0002^\"9!1\u000f\u0001\u0005\u0002\u0005u\u0007b\u0002B<\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005w\u0002A\u0011AAo\u0011\u001d\u0011y\b\u0001C\u0001\u0003;DqAa!\u0001\t\u0003\ti\u000eC\u0004\u0003\b\u0002!\t!!8\t\u000f\t-\u0005\u0001\"\u0001\u0002^\"9!q\u0012\u0001\u0005\u0002\u0005u\u0007b\u0002BJ\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005/\u0003A\u0011AAo\u0011\u001d\u0011Y\n\u0001C\u0001\u0003;DqAa(\u0001\t\u0003\ti\u000eC\u0004\u0003$\u0002!\t!!8\t\u000f\t\u001d\u0006\u0001\"\u0001\u0002^\"9!1\u0016\u0001\u0005\u0002\u0005u\u0007b\u0002BX\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005g\u0003A\u0011AAo\u0011\u001d\u00119\f\u0001C\u0005\u0005sCqAa4\u0001\t\u0013\u0011\t\u000eC\u0004\u0003b\u0002!IAa9\t\u0013\tU\b!%A\u0005\n\t](aF*j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014H+Z:u\u0015\t!V+\u0001\u0003bkRD'B\u0001,X\u0003!\u0019XmY;sSRL(\"\u0001-\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=^\u000b!A_6\n\u0005\u0001l&\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002GB\u0011A\rA\u0007\u0002'\u0006a\u0011\r\u001c7poJ+\u0017\rZ!dYV\tq\r\u0005\u0002eQ&\u0011\u0011n\u0015\u0002\u0004\u0003\u000ed\u0017!D1mY><(+Z1e\u0003\u000ed\u0007%A\u0007bY2|wo\u0016:ji\u0016\f5\r\\\u0001\u000fC2dwn^,sSR,\u0017i\u00197!\u0003-!WM\\=SK\u0006$\u0017i\u00197\u0002\u0019\u0011,g.\u001f*fC\u0012\f5\r\u001c\u0011\u0002!]LG\u000eZ\"be\u0012\u0014Vm]8ve\u000e,W#A9\u0011\u0005\u0011\u0014\u0018BA:T\u0005!\u0011Vm]8ve\u000e,\u0017!E<jY\u0012\u001c\u0015M\u001d3SKN|WO]2fA\u0005\u0001\u0002O]3gSb,GMU3t_V\u00148-Z\u0001\u0012aJ,g-\u001b=fIJ+7o\\;sG\u0016\u0004\u0013aE:j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014X#A=\u0011\u0005\u0011T\u0018BA>T\u0005M\u0019\u0016.\u001c9mK\u0006\u001bG.Q;uQ>\u0014\u0018N_3s\u0003Q\u0019\u0018.\u001c9mK\u0006\u001bG.Q;uQ>\u0014\u0018N_3sA\u0005!2/[7qY\u0016\f5\r\\!vi\"|'/\u001b>feJ\nQc]5na2,\u0017i\u00197BkRDwN]5{KJ\u0014\u0004%\u0001\u0005sKN|WO]2f\u00031\u0011Xm]8ve\u000e,w\fJ3r)\u0011\t)!!\u0005\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q!!a\u0003\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005=\u0011\u0011\u0002\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0014E\t\t\u00111\u0001r\u0003\rAH%M\u0001\ne\u0016\u001cx.\u001e:dK\u0002\n!b];qKJ,6/\u001a:t+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\t1\fgn\u001a\u0006\u0003\u0003K\tAA[1wC&!\u0011\u0011FA\u0010\u0005\u0019\u0019FO]5oO\u0006Y1/\u001e9feV\u001bXM]:!\u0003!)8/\u001a:oC6,\u0017!C;tKJt\u0017-\\3!\u0003%\u0001(/\u001b8dSB\fG.\u0006\u0002\u00026A!\u0011qGA&\u001b\t\tIDC\u0002U\u0003wQ1AVA\u001f\u0015\u0011\ty$!\u0011\u0002\r\r|W.\\8o\u0015\rA\u00161\t\u0006\u0005\u0003\u000b\n9%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0013\n1a\u001c:h\u0013\u0011\ti%!\u000f\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006Q\u0001O]5oG&\u0004\u0018\r\u001c\u0011\u0002\u000fM,7o]5p]V\u0011\u0011Q\u000b\t\u0005\u0003/\nyG\u0004\u0003\u0002Z\u0005%d\u0002BA.\u0003KrA!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003CJ\u0016A\u0002\u001fs_>$h(C\u0001Y\u0013\r\t9gV\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tY'!\u001c\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY*\u0019\u0011qM,\n\t\u0005E\u00141\u000f\u0002\b'\u0016\u001c8/[8o\u0015\u0011\tY'!\u001c\u0002\u0011M,7o]5p]\u0002\naaY8oM&<WCAA>!\u0011\ti(a!\u000e\u0005\u0005}$bAAA/\u000611/\u001a:wKJLA!!\"\u0002\u0000\tY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003\u000b\tY\tC\u0005\u0002\u0014q\t\t\u00111\u0001\u0002|\u000591m\u001c8gS\u001e\u0004\u0013a\u0004>p_.+W\r]3s\u00072LWM\u001c;\u0016\u0005\u0005M\u0005\u0003BAK\u00037k!!a&\u000b\u0007\u0005eu+A\u0005{_>\\W-\u001a9fe&!\u0011QTAL\u0005=Qvn\\&fKB,'o\u00117jK:$\u0018a\u0005>p_.+W\r]3s\u00072LWM\u001c;`I\u0015\fH\u0003BA\u0003\u0003GC\u0011\"a\u0005 \u0003\u0003\u0005\r!a%\u0002!i|wnS3fa\u0016\u00148\t\\5f]R\u0004#aD\"vgR|W\u000e\u0015:j]\u000eL\u0007/\u00197\u0014\u0007\u0005\n)$A\u0007qe&t7-\u001b9bYRK\b/\u001a\t\u0005\u0003_\u000b9L\u0004\u0003\u00022\u0006M\u0006\u0003BA/\u0003\u0013IA!!.\u0002\n\u00051\u0001K]3eK\u001aLA!!\u000b\u0002:*!\u0011QWA\u0005\u0003\u0011q\u0017-\\3\u0015\r\u0005}\u00161YAc!\r\t\t-I\u0007\u0002\u0001!9\u00111\u0016\u0013A\u0002\u00055\u0006bBA^I\u0001\u0007\u0011QV\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-\u0017\u0011\u001b\t\u0005\u0003\u000f\ti-\u0003\u0003\u0002P\u0006%!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003',\u0003\u0019AAk\u0003\u0005y\u0007\u0003BA\u0004\u0003/LA!!7\u0002\n\t\u0019\u0011I\\=\u0002\u000bM,G/\u00169\u0015\u0005\u0005\u0015\u0001f\u0001\u0014\u0002bB!\u00111]Ay\u001b\t\t)O\u0003\u0003\u0002h\u0006%\u0018aA1qS*!\u00111^Aw\u0003\u001dQW\u000f]5uKJTA!a<\u0002H\u0005)!.\u001e8ji&!\u00111_As\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001aq%!?\u0011\t\u0005\r\u00181`\u0005\u0005\u0003{\f)OA\u0005BMR,'/R1dQ\u00069C/Z:u\u0003V$\bn\u001c:ju\u0016$\u0006N]8xg>sgj\u001c8MSR,'/\u00197SKN|WO]2fQ\rA#1\u0001\t\u0005\u0003G\u0014)!\u0003\u0003\u0003\b\u0005\u0015(\u0001\u0002+fgR\f!\u0005^3ti\u0006+H\u000f[8sSj,w+\u001b;i\u000b6\u0004H/\u001f*fg>,(oY3OC6,\u0007fA\u0015\u0003\u0004\u0005YB/Z:u\u000b6\u0004H/_!dYRC'o\\<t\u000bb\u001cW\r\u001d;j_:D3A\u000bB\u0002\u00031!Xm\u001d;U_BL7-Q2mQ\rY#1A\u0001#i\u0016\u001cH/\u00117m_^\f5mY3tg^KG\u000f[\"vgR|W\u000e\u0015:j]\u000eL\u0007/\u00197)\u00071\u0012\u0019!A\fuKN$H)\u001a8z)\u0006\\Wm\u001d)sK\u000e,G-\u001a8dK\"\u001aQFa\u0001\u0002%Q,7\u000f^!mY><\u0018\t\u001c7BG\u000e,7o\u001d\u0015\u0004]\t\r\u0011A\u0006;fgR\u001cV\u000f]3s+N,'\u000fS1t\u0003\u000e\u001cWm]:)\u0007=\u0012\u0019!A\u0015uKN$8+\u001e9feV\u001bXM],ji\"\u001cUo\u001d;p[B\u0013\u0018N\\2ja\u0006d\u0007*Y:BG\u000e,7o\u001d\u0015\u0004a\t\r\u0011\u0001\u0005;fgR<\u0016\u000e\u001c3DCJ$\u0017i\u00197tQ\r\t$1A\u0001\u000fi\u0016\u001cHOT8BG24u.\u001e8eQ\r\u0011$1A\u0001\u0017i\u0016\u001cHOT8BG24u.\u001e8e\u001fZ,'O]5eK\"\u001a1Ga\u0001\u0002+Q,7\u000f^!dY6\u000bg.Y4f[\u0016tG/\u0011)Jg\"\u001aAGa\u0001\u0002\u001bQ,7\u000f\u001e'pC\u0012\u001c\u0015m\u00195fQ\r)$1A\u0001.i\u0016\u001cH\u000fT8dC2\u001cuN\\2veJ,g\u000e^'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\bf\u0001\u001c\u0003\u0004\u0005\u0019D/Z:u\t&\u001cHO]5ckR,GmQ8oGV\u0014(/\u001a8u\u001b>$\u0017NZ5dCRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004o\t\r\u0011!\f;fgRD\u0015n\u001a5D_:\u001cWO\u001d:f]\u000eLXj\u001c3jM&\u001c\u0017\r^5p]>3'+Z:pkJ\u001cW-Q2mg\"\u001a\u0001Ha\u0001\u0002%Q,7\u000f^!dY&s\u0007.\u001a:ji\u0006t7-\u001a\u0015\u0004s\t\r\u0011a\u0006;fgRLU\u000e\u001d7jG\u0006$\u0018n\u001c8t\u001f\u001a\fE\u000e\\8x)\u0019\t)A!\u0015\u0003\\!9!1\u000b\u001eA\u0002\tU\u0013\u0001\u00039be\u0016tGo\u00149\u0011\u0007\u0011\u00149&C\u0002\u0003ZM\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8\t\u000f\tu#\b1\u0001\u0003`\u0005Q\u0011\r\u001c7po\u0016$w\n]:\u0011\r\u0005=&\u0011\rB+\u0013\u0011\u0011\u0019'!/\u0003\u0007M+G/\u0001\fuKN$\u0018*\u001c9mS\u000e\fG/[8og>3G)\u001a8z)\u0019\t)A!\u001b\u0003l!9!1K\u001eA\u0002\tU\u0003b\u0002B7w\u0001\u0007!qL\u0001\nI\u0016t\u0017.\u001a3PaN\f\u0011\u0006^3ti\"Kw\r[\"p]\u000e,(O]3oGf$U\r\\3uS>twJ\u001a*fg>,(oY3BG2\u001c\bf\u0001\u001f\u0003\u0004\u0005\u0019D/Z:u\u0003\u000e\u001cWm]:BY2|w/\u001a3JM\u0006cGn\\<BG2,\u00050[:ug>sw+\u001b7eG\u0006\u0014HMU3t_V\u00148-\u001a\u0015\u0004{\t\r\u0011a\b;fgR$U\r\\3uK\u0006\u001bGn\u00148XS2$7-\u0019:e%\u0016\u001cx.\u001e:dK\"\u001aaHa\u0001\u0002EQ,7\u000f\u001e#fY\u0016$X-\u00117m\u0003\u000edwJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\ry$1A\u00014i\u0016\u001cH/Q2dKN\u001c\u0018\t\u001c7po\u0016$\u0017JZ!mY><\u0018i\u00197Fq&\u001cHo](o!J,g-\u001b=fIJ+7o\\;sG\u0016D3\u0001\u0011B\u0002\u0003}!Xm\u001d;EK2,G/Z!dY>s\u0007K]3gSb,GMU3t_V\u00148-\u001a\u0015\u0004\u0003\n\r\u0011A\t;fgR$U\r\\3uK\u0006cG.Q2m\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\rK\u0002C\u0005\u0007\tA\u0004^3ti\u0006#G-Q2mg>sG*\u001b;fe\u0006d'+Z:pkJ\u001cW\rK\u0002D\u0005\u0007\tQ\u0004^3ti\u0006#G-Q2mg>sw+\u001b7eG\u0006\u0014HMU3t_V\u00148-\u001a\u0015\u0004\t\n\r\u0011A\b;fgR\fE\rZ!dYN|e\u000e\u0015:fM&,\u00070\u001a3SKN|WO]2fQ\r)%1A\u0001\"i\u0016\u001cH/Q;uQ>\u0014\u0018N_3XSRD\u0007K]3gSb,GMU3t_V\u00148-\u001a\u0015\u0004\r\n\r\u0011a\b;fgR\u001c\u0016N\\4mK\u000eC\u0017M]1di\u0016\u0014(+Z:pkJ\u001cW-Q2mg\"\u001aqIa\u0001\u0002)Q,7\u000f^$fi\u0006\u001bGn\u001d)sS:\u001c\u0017\u000e]1mQ\rA%1A\u0001=i\u0016\u001cH\u000f\u00165s_^\u001cxJ\\!eIB\u0013XMZ5yK\u0012\f5\r\\%g\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c+p_2{w\u000fK\u0002J\u0005\u0007\t1\b^3ti^\u0013\u0018\u000e^3t\u000bb$XM\u001c3fI\u0006\u001bGn\u00115b]\u001e,WI^3oi&3\u0017J\u001c;fe\n\u0013xn[3s!J|Go\\2pY:{GoU3uQ\rQ%1A\u0001Fi\u0016\u001cHo\u0016:ji\u0016\u001cX\t\u001f;f]\u0012,G-Q2m\u0007\"\fgnZ3Fm\u0016tGo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7Bi2+\u0017m\u001d;LC\u001a\\\u0017M\u0016\u001a)\u0007-\u0013\u0019!\u0001=uKN$xK]5uKNd\u0015\u000e^3sC2<&/\u001b;fg2KG/\u001a:bY\u0006\u001bGn\u00115b]\u001e,WI^3oi^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dG*Z:t)\"\fgnS1gW\u00064&'\u001a:bY\u0006\u001bGn\u00115b]\u001e,7OR8s\u001f2$WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8tQ\ra%1A\u0001@i\u0016\u001cHo\u0016:ji\u0016\u001cH*\u001b;fe\u0006d\u0017i\u00197DQ\u0006tw-Z#wK:$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\\%t\u0017\u000647.\u0019,3Q\ri%1A\u0001#O&4XM\\!vi\"|'/\u001b>fe^KG\u000f\u001b)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0015\t\u0005\u0015!1\u0018\u0005\b\u0005{s\u0005\u0019\u0001B`\u0003=\u0001(o\u001c;pG>dg+\u001a:tS>t\u0007CBA\u0004\u0005\u0003\u0014)-\u0003\u0003\u0003D\u0006%!AB(qi&|g\u000e\u0005\u0003\u0003H\n-WB\u0001Be\u0015\r\t9oV\u0005\u0005\u0005\u001b\u0014IM\u0001\u0006Ba&4VM]:j_:\f\u0011dZ3u\u0003\u000ed7\t[1oO\u0016,e/\u001a8u\u0003N\u001cFO]5oOR!\u00111\u0004Bj\u0011\u001d\u0011)n\u0014a\u0001\u0005/\f1\u0002]1ui\u0016\u0014h\u000eV=qKB!!\u0011\u001cBo\u001b\t\u0011YNC\u0002\u0000\u0003{IAAa8\u0003\\\nY\u0001+\u0019;uKJtG+\u001f9f\u0003I\u0019\u0007.\u00198hK\u0006\u001bG.\u00118e-\u0016\u0014\u0018NZ=\u0015\u0015\t\u0015(q\u001dBv\u0005_\u0014\u0019\u0010E\u0003\u00020\n\u0005t\rC\u0004\u0003jB\u0003\rA!:\u0002\u0019=\u0014\u0018nZ5oC2\f5\r\\:\t\u000f\t5\b\u000b1\u0001\u0003f\u0006I\u0011\r\u001a3fI\u0006\u001bGn\u001d\u0005\b\u0005c\u0004\u0006\u0019\u0001Bs\u0003-\u0011X-\\8wK\u0012\f5\r\\:\t\u000f}\u0004\u0006\u0013!a\u0001c\u0006a2\r[1oO\u0016\f5\r\\!oIZ+'/\u001b4zI\u0011,g-Y;mi\u0012\"TC\u0001B}U\r\t(1`\u0016\u0003\u0005{\u0004BAa@\u0004\n5\u00111\u0011\u0001\u0006\u0005\u0007\u0007\u0019)!A\u0005v]\u000eDWmY6fI*!1qAA\u0005\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0017\u0019\tAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Ds\u0001AB\b\u0007+\u0019I\u0002\u0005\u0003\u0002\b\rE\u0011\u0002BB\n\u0003\u0013\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\u00199\"A\tVg\u0016\u0004\u0013i\u00197BkRDwN]5{KJ\f#aa\u0007\u0002\u0013MKgnY3!e9\"\u0004")
public class SimpleAclAuthorizerTest
extends ZooKeeperTestHarness {
    private final Acl allowReadAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    private final Acl allowWriteAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
    private final Acl denyReadAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    private final Resource wildCardResource = new Resource((ResourceType)Topic$.MODULE$, Acl$.MODULE$.WildCardResource(), PatternType.LITERAL);
    private final Resource prefixedResource = new Resource((ResourceType)Topic$.MODULE$, "foo", PatternType.PREFIXED);
    private final SimpleAclAuthorizer simpleAclAuthorizer = new SimpleAclAuthorizer();
    private final SimpleAclAuthorizer simpleAclAuthorizer2 = new SimpleAclAuthorizer();
    private Resource resource;
    private final String superUsers;
    private final String username;
    private final KafkaPrincipal principal = new KafkaPrincipal("User", this.username());
    private final RequestChannel.Session session = new RequestChannel.Session(this.principal(), InetAddress.getByName("192.168.0.1"));
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;

    private Acl allowReadAcl() {
        return this.allowReadAcl;
    }

    private Acl allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private Acl denyReadAcl() {
        return this.denyReadAcl;
    }

    private Resource wildCardResource() {
        return this.wildCardResource;
    }

    private Resource prefixedResource() {
        return this.prefixedResource;
    }

    private SimpleAclAuthorizer simpleAclAuthorizer() {
        return this.simpleAclAuthorizer;
    }

    private SimpleAclAuthorizer simpleAclAuthorizer2() {
        return this.simpleAclAuthorizer2;
    }

    private Resource resource() {
        return this.resource;
    }

    private void resource_$eq(Resource x$1) {
        this.resource = x$1;
    }

    private String superUsers() {
        return this.superUsers;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestChannel.Session session() {
        return this.session;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    private void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.simpleAclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.simpleAclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.simpleAclAuthorizer().configure(this.config().originals());
        this.simpleAclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "SimpleAclAuthorizerTest"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.simpleAclAuthorizer().close();
        this.simpleAclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test
    public void testAuthorizeThrowsOnNonLiteralResource() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "something", PatternType.PREFIXED)));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL)));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Group$.MODULE$, Acl$.MODULE$.WildCardResource(), PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL)));
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        Acl acl5 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        Acl acl6 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        Acl acl7 = new Acl(user3, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session(user1, host2);
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()), (String)"User1 should have WRITE access from host1");
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Write$.MODULE$, this.resource()), (String)"User1 should not have WRITE access from host2 as no allow acl is defined");
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Describe$.MODULE$, this.resource()), (String)"User1 should not have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Describe$.MODULE$, this.resource()), (String)"User1 should have DESCRIBE access from host2");
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Alter$.MODULE$, this.resource()), (String)"User1 should not have edit access from host1");
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Alter$.MODULE$, this.resource()), (String)"User1 should not have edit access from host2");
        RequestChannel.Session user2Session = new RequestChannel.Session(user2, host1);
        RequestChannel.Session user3Session = new RequestChannel.Session(user3, host1);
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Describe$.MODULE$, this.resource()), (String)"User2 should have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Describe$.MODULE$, this.resource()), (String)"User3 should have DESCRIBE access from host2");
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Read$.MODULE$, this.resource()), (String)"User2 should have READ access from host1");
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Write$.MODULE$, this.resource()), (String)"User3 should have WRITE access from host2");
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session((KafkaPrincipal)customUserPrincipal, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session((KafkaPrincipal)customUserPrincipal, host2);
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestChannel.Session session = new RequestChannel.Session(user, host);
        Acl allowAll = Acl$.MODULE$.AllowAllAcl();
        Acl denyAcl = new Acl(user, (PermissionType)Deny$.MODULE$, host.getHostAddress(), (Operation)All$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()), (String)"deny should take precedence over allow.");
    }

    @Test
    public void testAllowAllAccess() {
        Acl allowAllAcl = Acl$.MODULE$.AllowAllAcl();
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"));
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()), (String)"allow all acl should allow access to all.");
    }

    @Test
    public void testSuperUserHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session1 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        RequestChannel.Session session2 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"));
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(session1, (Operation)Read$.MODULE$, this.resource()), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(session2, (Operation)Read$.MODULE$, this.resource()), (String)"superuser always has access, no matter what acls.");
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session((KafkaPrincipal)new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()), (String)"superuser with custom principal always has access, no matter what acls.");
    }

    @Test
    public void testWildCardAcls() {
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()), (String)"when acls = [],  authorizer should fail close.");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        Acl readAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Set<Acl> acls = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{readAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()), (String)"User1 should have Read access from host1");
        Acl writeAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{writeAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Acl denyWriteOnWildCardResourceAcl = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.changeAclAndVerify(acls, (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyWriteOnWildCardResourceAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()), (String)"User1 should not have Write access from host1");
    }

    @Test
    public void testNoAclFound() {
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()), (String)"when acls = [],  authorizer should fail close.");
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (SimpleAclAuthorizer testAuthorizer = new SimpleAclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assertions.assertTrue((boolean)testAuthorizer.authorize(this.session(), (Operation)Read$.MODULE$, this.resource()), (String)"when acls = null or [],  authorizer should fail open with allow.everyone = true.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Write$.MODULE$);
        Acl acl3 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Write$.MODULE$);
        ObjectRef acls = ObjectRef.create(this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4()));
        Acl acl5 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        acls.elem = this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl5}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!SimpleAclAuthorizerTest.$anonfun$testAclManagementAPIs$1(this, acl1, acl2, user1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)SimpleAclAuthorizerTest.$anonfun$testAclManagementAPIs$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!SimpleAclAuthorizerTest.$anonfun$testAclManagementAPIs$3(this, acl3, acl4, acl5, user2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)SimpleAclAuthorizerTest.$anonfun$testAclManagementAPIs$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Map resourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Topic$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Cluster$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)((Set)acls.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, "test-ConsumerGroup", PatternType.LITERAL)), (Object)((Set)acls.elem))}));
        resourceToAcls.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Resource key = (Resource)x0$1._1();
            Set value = (Set)x0$1._2();
            Set<Acl> set = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)value, (Set<Acl>)Predef$.MODULE$.Set().empty(), key);
            return set;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!SimpleAclAuthorizerTest.$anonfun$testAclManagementAPIs$6(this, resourceToAcls, acls)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)SimpleAclAuthorizerTest.$anonfun$testAclManagementAPIs$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        acls.elem = this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        this.simpleAclAuthorizer().removeAcls(this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        Assertions.assertFalse((boolean)this.zkClient().resourceExists(this.resource().toPattern()));
        acls.elem = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)acls.elem), this.changeAclAndVerify$default$4());
        Assertions.assertFalse((boolean)this.zkClient().resourceExists(this.resource().toPattern()));
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, "host-1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}));
        this.simpleAclAuthorizer().addAcls(acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, "test-2", PatternType.LITERAL);
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, "host3", (Operation)Read$.MODULE$);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2}));
        this.simpleAclAuthorizer().addAcls(acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (SimpleAclAuthorizer authorizer = new SimpleAclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assertions.assertEquals((Object)acls, (Object)authorizer.getAcls(this.resource()));
            Assertions.assertEquals((Object)acls1, (Object)authorizer.getAcls(resource1));
        }
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer2(), commonResource);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        Acl acl3 = new Acl(user3, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource), (String)"The authorizer should see a value that needs to be deleted");
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        IndexedSeq acls = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)i -> SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable & scala.Serializable)acl -> (Function0 & Serializable & scala.Serializable)() -> {
            int aclId = new StringOps(Predef$.MODULE$.augmentString(acl.principal().getName())).toInt();
            if (aclId % 2 == 0) {
                this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource);
            } else {
                this.simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource);
            }
            if (aclId % 10 == 0) {
                return BoxesRunTime.boxToBoolean((boolean)this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource));
            }
            return BoxedUnit.UNIT;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set expectedAcls = ((TraversableOnce)acls.filter((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(acl)))).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow((Operation)All$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Delete$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)All$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Delete$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Read$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Write$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Delete$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Alter$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)Describe$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow((Operation)AlterConfigs$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{DescribeConfigs$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)DescribeConfigs$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(Operation parentOp, Set<Operation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestChannel.Session hostSession = new RequestChannel.Session(user, host);
        Acl acl = new Acl(user, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), parentOp);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), Resource$.MODULE$.ClusterResource());
        Operation$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)op -> {
            SimpleAclAuthorizerTest.$anonfun$testImplicationsOfAllow$1(this, hostSession, allowedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), Resource$.MODULE$.ClusterResource());
    }

    private void testImplicationsOfDeny(Operation parentOp, Set<Operation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user1, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), parentOp), new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$)}));
        this.simpleAclAuthorizer().addAcls(acls, Resource$.MODULE$.ClusterResource());
        Operation$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)op -> {
            SimpleAclAuthorizerTest.$anonfun$testImplicationsOfDeny$1(this, host1Session, deniedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.simpleAclAuthorizer().removeAcls(acls, Resource$.MODULE$.ClusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        Acl acl = new Acl(new KafkaPrincipal("User", this.username()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        IndexedSeq concurrentFuctions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)x$1 -> SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer2(), this.resource());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.wildCardResource());
        this.simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        this.simpleAclAuthorizer().removeAcls(this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.simpleAclAuthorizer().removeAcls(this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls());
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.resource());
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.resource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.wildCardResource());
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefiexedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "a_other", PatternType.LITERAL));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "a_other", PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(8).append("foo-").append(UUID.randomUUID()).append("-zzz").toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(5).append("fooo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(3).append("fo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("fop-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("fon-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "fon-", PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "f", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "f", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "foo", PatternType.LITERAL)));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "_", PatternType.PREFIXED));
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "_foo", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "_", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        Acl aclOnSpecificPrincipal = new Acl(this.principal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{aclOnSpecificPrincipal})), this.resource());
        Assertions.assertEquals((int)0, (int)this.simpleAclAuthorizer().getAcls(Acl$.MODULE$.WildCardPrincipal()).size(), (String)"acl on specific should not be returned for wildcard request");
        Assertions.assertEquals((int)1, (int)this.simpleAclAuthorizer().getAcls(this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)1, (int)this.simpleAclAuthorizer().getAcls(new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size(), (String)"acl on specific should be returned for different principal instance");
        this.simpleAclAuthorizer().removeAcls(this.resource());
        Acl aclOnWildcardPrincipal = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{aclOnWildcardPrincipal})), this.resource());
        Assertions.assertEquals((int)1, (int)this.simpleAclAuthorizer().getAcls(Acl$.MODULE$.WildCardPrincipal()).size(), (String)"acl on wildcard should be returned for wildcard request");
        Assertions.assertEquals((int)0, (int)this.simpleAclAuthorizer().getAcls(this.principal()).size(), (String)"acl on wildcard should not be returned for specific request");
    }

    @Test
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED)));
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.empty());
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource.toPattern()).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource.toPattern()).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource.toPattern()).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource.toPattern()).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.simpleAclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        protocolVersion.foreach((Function1 & Serializable & scala.Serializable)version -> props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.toString()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.simpleAclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), true, GetChildrenRequest$.MODULE$.apply$default$3()));
        children.maybeThrow();
        Assertions.assertEquals((int)1, (int)children.children().size(), (String)"Expecting 1 change event");
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), GetDataRequest$.MODULE$.apply$default$2()));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private Set<Acl> changeAclAndVerify(Set<Acl> originalAcls, Set<Acl> addedAcls, Set<Acl> removedAcls, Resource resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().addAcls(addedAcls, resource);
            acls = (Set)originalAcls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().removeAcls(removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.simpleAclAuthorizer(), resource);
        return acls;
    }

    private Resource changeAclAndVerify$default$4() {
        return this.resource();
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$1(SimpleAclAuthorizerTest $this, Acl acl1$1, Acl acl2$1, KafkaPrincipal user1$1) {
        GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1$1, acl2$1})))}));
        Map map = $this.simpleAclAuthorizer().getAcls(user1$1);
        return !(genMap != null ? !genMap.equals(map) : map != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$2() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$3(SimpleAclAuthorizerTest $this, Acl acl3$1, Acl acl4$1, Acl acl5$1, KafkaPrincipal user2$1) {
        GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3$1, acl4$1, acl5$1})))}));
        Map map = $this.simpleAclAuthorizer().getAcls(user2$1);
        return !(genMap != null ? !genMap.equals(map) : map != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$4() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$6(SimpleAclAuthorizerTest $this, Map resourceToAcls$1, ObjectRef acls$1) {
        Map map = resourceToAcls$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.resource()), (Object)((Set)acls$1.elem)));
        Map map2 = $this.simpleAclAuthorizer().getAcls();
        return !(map != null ? !map.equals(map2) : map2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$7() {
        return "changes not propagated in timeout period.";
    }

    public static final /* synthetic */ Acl $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", Integer.toString(i));
        return new Acl(useri, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Acl acl) {
        return new StringOps(Predef$.MODULE$.augmentString(acl.principal().getName())).toInt() % 10 != 0;
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$1(SimpleAclAuthorizerTest $this, RequestChannel.Session hostSession$1, Set allowedOps$1, Operation parentOp$1, Operation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.simpleAclAuthorizer().authorize(hostSession$1, op, Resource$.MODULE$.ClusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                Operation operation = op;
                if (operation != null ? !operation.equals(parentOp$1) : parentOp$1 != null) break block3;
            }
            Assertions.assertTrue((boolean)authorized, (String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString());
            return;
        }
        Assertions.assertFalse((boolean)authorized, (String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString());
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$1(SimpleAclAuthorizerTest $this, RequestChannel.Session host1Session$1, Set deniedOps$1, Operation parentOp$2, Operation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.simpleAclAuthorizer().authorize(host1Session$1, op, Resource$.MODULE$.ClusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                Operation operation = op;
                if (operation != null ? !operation.equals(parentOp$2) : parentOp$2 != null) break block3;
            }
            Assertions.assertFalse((boolean)authorized, (String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString());
            return;
        }
        Assertions.assertTrue((boolean)authorized, (String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString());
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(SimpleAclAuthorizerTest $this, Acl acl$2, int x$1) {
        return (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl$2})), $this.resource());
            return $this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl$2})), $this.resource());
        };
    }

    public SimpleAclAuthorizerTest() {
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ SimpleAclAuthorizerTest kafka$security$auth$SimpleAclAuthorizerTest$CustomPrincipal$$$outer() {
            return SimpleAclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (SimpleAclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

