/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.JoinGroupResult$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberMetadata$;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import kafka.coordinator.group.SyncGroupResult$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001\u0002'N\u0001QCQa\u0017\u0001\u0005\u0002qCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004j\u0001\u0001\u0006I!\u0019\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019y\u0007\u0001)A\u0005Y\"9\u0001\u000f\u0001b\u0001\n\u0013\u0001\u0007BB9\u0001A\u0003%\u0011\rC\u0004s\u0001\t\u0007I\u0011\u00021\t\rM\u0004\u0001\u0015!\u0003b\u0011\u001d!\bA1A\u0005\n\u0001Da!\u001e\u0001!\u0002\u0013\t\u0007b\u0002<\u0001\u0005\u0004%Ia\u001e\u0005\u0007w\u0002\u0001\u000b\u0011\u0002=\t\u000fq\u0004!\u0019!C\u0005o\"1Q\u0010\u0001Q\u0001\naDqA\u0014\u0001A\u0002\u0013%a\u0010C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0003\u0002\b!9\u00111\u0003\u0001!B\u0013y\b\"CA\u000b\u0001\u0001\u0007I\u0011BA\f\u0011%\ty\u0002\u0001a\u0001\n\u0013\t\t\u0003\u0003\u0005\u0002&\u0001\u0001\u000b\u0015BA\r\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!!\u0012\u0001\t\u0003\tI\u0003C\u0004\u0002P\u0001!\t!!\u000b\t\u000f\u0005M\u0003\u0001\"\u0001\u0002*!9\u0011q\u000b\u0001\u0005\u0002\u0005%\u0002bBA.\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003?\u0002A\u0011AA\u0015\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003SAq!a\u001a\u0001\t\u0003\tI\u0003C\u0004\u0002l\u0001!\t!!\u000b\t\u000f\u0005=\u0004\u0001\"\u0001\u0002*!9\u00111\u000f\u0001\u0005\u0002\u0005%\u0002bBA<\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003w\u0002A\u0011AA\u0015\u0011\u001d\ty\b\u0001C\u0001\u0003SAq!a!\u0001\t\u0003\tI\u0003C\u0004\u0002\b\u0002!\t!!\u000b\t\u000f\u0005-\u0005\u0001\"\u0001\u0002*!9\u0011q\u0012\u0001\u0005\u0002\u0005%\u0002bBAI\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003+\u0003A\u0011AA\u0015\u0011\u001d\tI\n\u0001C\u0001\u0003SAq!!(\u0001\t\u0003\tI\u0003C\u0004\u0002\"\u0002!\t!!\u000b\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002*!9\u0011\u0011\u0016\u0001\u0005\u0002\u0005%\u0002bBAW\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003c\u0003A\u0011AA\u0015\u0011\u001d\t)\f\u0001C\u0001\u0003SAq!!/\u0001\t\u0003\tI\u0003C\u0004\u0002>\u0002!\t!!\u000b\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002*!9\u0011Q\u0019\u0001\u0005\u0002\u0005%\u0002bBAe\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003\u001b\u0004A\u0011AA\u0015\u0011\u001d\t\t\u000e\u0001C\u0001\u0003SAq!!6\u0001\t\u0003\tI\u0003C\u0004\u0002Z\u0002!\t!!\u000b\t\u000f\u0005u\u0007\u0001\"\u0001\u0002*!9\u0011\u0011\u001d\u0001\u0005\u0002\u0005%\u0002bBAs\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003S\u0004A\u0011AA\u0015\u0011\u001d\ti\u000f\u0001C\u0001\u0003SAq!!=\u0001\t\u0003\tI\u0003C\u0004\u0002v\u0002!\t!!\u000b\t\u000f\u0005e\b\u0001\"\u0001\u0002*!9\u0011Q \u0001\u0005\u0002\u0005%\u0002b\u0002B\u0001\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0005\u000b\u0001A\u0011AA\u0015\u0011\u001d\u0011I\u0001\u0001C\u0001\u0003SAqA!\u0004\u0001\t\u0003\tI\u0003C\u0004\u0003\u0012\u0001!\t!!\u000b\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018!9!Q\u0005\u0001\u0005\n\t\u001d\"!E$s_V\u0004X*\u001a;bI\u0006$\u0018\rV3ti*\u0011ajT\u0001\u0006OJ|W\u000f\u001d\u0006\u0003!F\u000b1bY8pe\u0012Lg.\u0019;pe*\t!+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0006C\u0001,Z\u001b\u00059&\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;B\u0011a\fA\u0007\u0002\u001b\u0006a\u0001O]8u_\u000e|G\u000eV=qKV\t\u0011\r\u0005\u0002cO6\t1M\u0003\u0002eK\u0006!A.\u00198h\u0015\u00051\u0017\u0001\u00026bm\u0006L!\u0001[2\u0003\rM#(/\u001b8h\u00035\u0001(o\u001c;pG>dG+\u001f9fA\u0005yqM]8va&s7\u000f^1oG\u0016LE-F\u0001m!\r1V.Y\u0005\u0003]^\u0013AaU8nK\u0006\u0001rM]8va&s7\u000f^1oG\u0016LE\rI\u0001\t[\u0016l'-\u001a:JI\u0006IQ.Z7cKJLE\rI\u0001\tG2LWM\u001c;JI\u0006I1\r\\5f]RLE\rI\u0001\u000bG2LWM\u001c;I_N$\u0018aC2mS\u0016tG\u000fS8ti\u0002\n!C]3cC2\fgnY3US6,w.\u001e;NgV\t\u0001\u0010\u0005\u0002Ws&\u0011!p\u0016\u0002\u0004\u0013:$\u0018a\u0005:fE\u0006d\u0017M\\2f)&lWm\\;u\u001bN\u0004\u0013\u0001E:fgNLwN\u001c+j[\u0016|W\u000f^'t\u0003E\u0019Xm]:j_:$\u0016.\\3pkRl5\u000fI\u000b\u0002\u007fB\u0019a,!\u0001\n\u0007\u0005\rQJA\u0007He>,\b/T3uC\u0012\fG/Y\u0001\nOJ|W\u000f]0%KF$B!!\u0003\u0002\u0010A\u0019a+a\u0003\n\u0007\u00055qK\u0001\u0003V]&$\b\u0002CA\t#\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013'\u0001\u0004he>,\b\u000fI\u0001\u0007[\u0016l'-\u001a:\u0016\u0005\u0005e\u0001c\u00010\u0002\u001c%\u0019\u0011QD'\u0003\u001d5+WNY3s\u001b\u0016$\u0018\rZ1uC\u0006QQ.Z7cKJ|F%Z9\u0015\t\u0005%\u00111\u0005\u0005\n\u0003#!\u0012\u0011!a\u0001\u00033\tq!\\3nE\u0016\u0014\b%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002\n!\u001aa#!\f\u0011\t\u0005=\u0012\u0011I\u0007\u0003\u0003cQA!a\r\u00026\u0005\u0019\u0011\r]5\u000b\t\u0005]\u0012\u0011H\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\tY$!\u0010\u0002\u000b),h.\u001b;\u000b\u0005\u0005}\u0012aA8sO&!\u00111IA\u0019\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001bi\u0016\u001cHoQ1o%\u0016\u0014\u0017\r\\1oG\u0016<\u0006.\u001a8Ti\u0006\u0014G.\u001a\u0015\u0004/\u0005%\u0003\u0003BA\u0018\u0003\u0017JA!!\u0014\u00022\t!A+Z:u\u0003\u001d\"Xm\u001d;DC:\u0014VMY1mC:\u001cWm\u00165f]\u000e{W\u000e\u001d7fi&twMU3cC2\fgnY3)\u0007a\tI%A\u0015uKN$8)\u00198o_R\u0014VMY1mC:\u001cWm\u00165f]B\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a\u0015\u00043\u0005%\u0013a\u0007;fgR\u001c\u0015M\u001c8piJ+'-\u00197b]\u000e,w\u000b[3o\t\u0016\fG\rK\u0002\u001b\u0003\u0013\n\u0001\u0006^3tiN#\u0018M\u00197f)>\u0004&/\u001a9be&twMU3cC2\fgnY3Ue\u0006t7/\u001b;j_:D3aGA%\u0003i!Xm\u001d;Ti\u0006\u0014G.\u001a+p\t\u0016\fG\r\u0016:b]NLG/[8oQ\ra\u0012\u0011J\u00014i\u0016\u001cH/Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f)>\u0004&/\u001a9be&twMU3cC2\fgnY3Ue\u0006t7/\u001b;j_:D3!HA%\u0003\u0019\"Xm\u001d;Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,Gk\u001c#fC\u0012$&/\u00198tSRLwN\u001c\u0015\u0004=\u0005%\u0013a\n;fgR\u0004&/\u001a9be&twMU3cC2\fgnY3U_\u0016k\u0007\u000f^=Ue\u0006t7/\u001b;j_:D3aHA%\u0003e!Xm\u001d;F[B$\u0018\u0010V8EK\u0006$GK]1og&$\u0018n\u001c8)\u0007\u0001\nI%A\u0014uKN$\u0018i^1ji&twMU3cC2\fgnY3U_N#\u0018M\u00197f)J\fgn]5uS>t\u0007fA\u0011\u0002J\u0005\u0011C/Z:u\u000b6\u0004H/\u001f+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3AIA%\u0003\r\"Xm\u001d;Ti\u0006\u0014G.\u001a+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3aIA%\u00035\"Xm\u001d;F[B$\u0018\u0010V8Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0004I\u0005%\u0013a\u000f;fgR\u0004&/\u001a9be&twMU3cC2\fgnY3U_B\u0013X\r]1sS:<'+\u001a2bY\u0006t7-Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aQ%!\u0013\u0002_Q,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$vn\u0015;bE2,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007\u0019\nI%A\u001duKN$\u0018i^1ji&twMU3cC2\fgnY3U_\u0006;\u0018-\u001b;j]\u001e\u0014VMY1mC:\u001cW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\r9\u0013\u0011J\u0001 i\u0016\u001cH\u000fR3bIR{G)Z1e\u00132dWmZ1m)J\fgn]5uS>t\u0017!\t;fgR$U-\u00193U_N#\u0018M\u00197f\u00132dWmZ1m)J\fgn]5uS>t\u0007fA\u0015\u0002J\u0005iC/Z:u\t\u0016\fG\rV8Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007)\nI%\u0001\u0017uKN$H)Z1e)>\fu/Y5uS:<'+\u001a2bY\u0006t7-Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a1&!\u0013\u0002%Q,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0004Y\u0005%\u0013a\t;fgR\u001cV\r\\3diB\u0013x\u000e^8d_2\u0014\u0016-[:fg&3gj\\'f[\n,'o\u001d\u0015\u0004[\u0005%\u0013a\u000b;fgR\u001cV\r\\3diB\u0013x\u000e^8d_2\u001c\u0005n\\8tKN\u001cu.\u001c9bi&\u0014G.\u001a)s_R|7m\u001c7)\u00079\nI%A\u000buKN$8+\u001e9q_J$8\u000f\u0015:pi>\u001cw\u000e\\:)\u0007=\nI%\u0001\u000buKN$8+\u001e2tGJL'-\u001a3U_BL7m\u001d\u0015\u0004a\u0005%\u0013\u0001\n;fgR\u001cVOY:de&\u0014W\r\u001a+pa&\u001c7OT8o\u0007>t7/^7fe\u001e\u0013x.\u001e9)\u0007E\nI%\u0001\fuKN$\u0018J\\5u\u001d\u0016DHoR3oKJ\fG/[8oQ\r\u0011\u0014\u0011J\u0001!i\u0016\u001cH/\u00138ji:+\u0007\u0010^$f]\u0016\u0014\u0018\r^5p]\u0016k\u0007\u000f^=He>,\b\u000fK\u00024\u0003\u0013\n\u0001\u0003^3ti>3gm]3u\u0007>lW.\u001b;)\u0007Q\nI%A\fuKN$xJ\u001a4tKR\u001cu.\\7ji\u001a\u000b\u0017\u000e\\;sK\"\u001aQ'!\u0013\u0002SQ,7\u000f^(gMN,GoQ8n[&$h)Y5mkJ,w+\u001b;i\u0003:|G\u000f[3s!\u0016tG-\u001b8hQ\r1\u0014\u0011J\u0001#i\u0016\u001cHo\u00144gg\u0016$8i\\7nSR<\u0016\u000e\u001e5B]>$\b.\u001a:QK:$\u0017N\\4)\u0007]\nI%\u0001\u0016uKN$8i\u001c8tk6,'OQ3biN$&/\u00198tC\u000e$\u0018n\u001c8bY>3gm]3u\u0007>lW.\u001b;)\u0007a\nI%\u0001\u0015uKN$HK]1og\u0006\u001cG/[8o\u0005\u0016\fGo]\"p]N,X.\u001a:PM\u001a\u001cX\r^\"p[6LG\u000fK\u0002:\u0003\u0013\nQ\u0007^3tiR\u0013\u0018M\\:bGRLwN\\1m\u0007>lW.\u001b;Jg\u0006\u0013wN\u001d;fI\u0006sGmQ8ogVlWM]\"p[6LGoV5og\"\u001a!(!\u0013\u0002[Q,7\u000f\u001e$bS2,G\r\u0016=o\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e'fCZ,7OT8QK:$\u0017N\\4Ti\u0006$X\rK\u0002<\u0003\u0013\n\u0001\u0007^3tiJ+\u0007\u000f\\1dK\u001e\u0013x.\u001e9J]N$\u0018M\\2f/&$\b.R7qif<%o\\;q\u0013:\u001cH/\u00198dK&#\u0007f\u0001\u001f\u0002J\u0005iC/Z:u%\u0016\u0004H.Y2f\u000fJ|W\u000f]%ogR\fgnY3XSRDgj\u001c8Fq&\u001cH/\u001b8h\u001b\u0016l'-\u001a:)\u0007u\nI%\u0001\ruKN$(+\u001a9mC\u000e,wI]8va&s7\u000f^1oG\u0016D3APA%\u0003Y!Xm\u001d;J]Z|7.\u001a&pS:\u001c\u0015\r\u001c7cC\u000e\\\u0007fA \u0002J\u0005IB/Z:u\u001d>$\u0018J\u001c<pW\u0016Tu.\u001b8DC2d'-Y2lQ\r\u0001\u0015\u0011J\u0001\u0017i\u0016\u001cH/\u00138w_.,7+\u001f8d\u0007\u0006dGNY1dW\"\u001a\u0011)!\u0013\u00023Q,7\u000f\u001e(pi&sgo\\6f'ft7mQ1mY\n\f7m\u001b\u0015\u0004\u0005\u0006%\u0013a\u0007;fgRD\u0015m\u001d)f]\u0012Lgn\u001a(p]RChn\u00144gg\u0016$8\u000fK\u0002D\u0003\u0013\n\u0001\u0004^3ti\"\u000b7\u000fU3oI&tw\r\u0016=o\u001f\u001a47/\u001a;tQ\r!\u0015\u0011J\u0001(i\u0016\u001cHoQ1o]>$\u0018\t\u001a3QK:$\u0017N\\4Ts:\u001cwJZ+oW:|wO\\'f[\n,'\u000fK\u0002F\u0003\u0013\n!\u0006^3ti\u000e\u000bgN\\8u%\u0016lwN^3QK:$\u0017N\\4Ts:\u001cwJZ+oW:|wO\\'f[\n,'\u000fK\u0002G\u0003\u0013\nA\u0005^3ti\u000e\u000bg.\u00113e\u0003:$'+Z7pm\u0016\u0004VM\u001c3j]\u001e\u001c\u0016P\\2NK6\u0014WM\u001d\u0015\u0004\u000f\u0006%\u0013!\f;fgR\u0014V-\\8wC24%o\\7QK:$\u0017N\\4Ts:\u001cw\u000b[3o\u001b\u0016l'-\u001a:JgJ+Wn\u001c<fI\"\u001a\u0001*!\u0013\u0002SQ,7\u000f\u001e(fo\u001e+g.\u001a:bi&|gn\u00117fCJ\u001c\b+\u001a8eS:<7+\u001f8d\u001b\u0016l'-\u001a:tQ\rI\u0015\u0011J\u0001\fCN\u001cXM\u001d;Ti\u0006$X\r\u0006\u0004\u0002\n\te!1\u0004\u0005\u0006\u001d*\u0003\ra \u0005\b\u0005;Q\u0005\u0019\u0001B\u0010\u0003-!\u0018M]4fiN#\u0018\r^3\u0011\u0007y\u0013\t#C\u0002\u0003$5\u0013!b\u0012:pkB\u001cF/\u0019;f\u0003EygMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u000b\u0005\u0005S\u0011)\u0004\u0005\u0003\u0003,\tERB\u0001B\u0017\u0015\r\u0011y#U\u0001\u0007G>lWn\u001c8\n\t\tM\"Q\u0006\u0002\u0012\u001f\u001a47/\u001a;B]\u0012lU\r^1eCR\f\u0007b\u0002B\u001c\u0017\u0002\u0007!\u0011H\u0001\u0007_\u001a47/\u001a;\u0011\u0007Y\u0013Y$C\u0002\u0003>]\u0013A\u0001T8oO\u0002")
public class GroupMetadataTest {
    private final String protocolType;
    private final Some<String> groupInstanceId = new Some((Object)"groupInstanceId");
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;
    private MemberMetadata member = null;

    private String protocolType() {
        return this.protocolType;
    }

    private Some<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    private MemberMetadata member() {
        return this.member;
    }

    private void member_$eq(MemberMetadata x$1) {
        this.member = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
        this.member_$eq(new MemberMetadata(this.memberId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9()));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test
    public void testEmptyToStableIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$3 = this.group();
        Function1 x$6 = qual$3.add$default$2();
        qual$3.add(lastMember, x$6);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolRaisesIfNoMembers() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testSubscribedTopics() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava())).array()), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(memberId);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().empty()), (Object)this.group().getSubscribedTopics());
        MemberMetadata memberWithFaultyProtocol = new MemberMetadata(memberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(memberWithFaultyProtocol, x$4);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), "My Protocol", (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testInitNextGeneration() {
        this.member().supportedProtocols_$eq((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(this.member(), (Function1 & Serializable & scala.Serializable)x$1 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testReplaceGroupInstanceWithEmptyGroupInstanceId() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assertions.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assertions.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.group().replaceGroupInstance(this.memberId(), newMemberId, Option$.MODULE$.empty()));
    }

    @Test
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId()));
    }

    @Test
    public void testReplaceGroupInstance() {
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1 & Serializable & scala.Serializable)joinGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$1(joinAwaitingMemberFenced, joinGroupResult);
            return BoxedUnit.UNIT;
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.member().awaitingSyncCallback_$eq((Function1 & Serializable & scala.Serializable)syncGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$2(syncAwaitingMemberFenced, syncGroupResult);
            return BoxedUnit.UNIT;
        });
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assertions.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assertions.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
        Assertions.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assertions.assertEquals((Object)newMemberId, (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        Assertions.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assertions.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assertions.assertFalse((boolean)this.member().isAwaitingJoin());
        Assertions.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1 & Serializable & scala.Serializable)x$2 -> {
            invoked.elem = true;
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(this.member(), JoinGroupResult$.MODULE$.apply(this.member().memberId(), Errors.NONE));
        Assertions.assertTrue((boolean)invoked.elem);
        Assertions.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        Assertions.assertFalse((boolean)this.member().isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(this.member(), JoinGroupResult$.MODULE$.apply(this.member().memberId(), Errors.NONE));
        Assertions.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.member().awaitingSyncCallback_$eq((Function1 & Serializable & scala.Serializable)x$3 -> {
            GroupMetadataTest.$anonfun$testInvokeSyncCallback$1(x$3);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().maybeInvokeSyncCallback(this.member(), SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        Assertions.assertFalse((boolean)this.group().maybeInvokeSyncCallback(this.member(), SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testHasPendingNonTxnOffsets() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(partition));
    }

    @Test
    public void testHasPendingTxnOffsets() {
        TopicPartition txnPartition = new TopicPartition("foo", 1);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int producerId = 5;
        this.group().prepareTxnOffsetCommit((long)producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)txnPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(txnPartition));
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(new TopicPartition("non-exist", 0)));
    }

    @Test
    public void testCannotAddPendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingSyncMember(this.memberId()));
    }

    @Test
    public void testCannotRemovePendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().removePendingSyncMember(this.memberId()));
    }

    @Test
    public void testCanAddAndRemovePendingSyncMember() {
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().removePendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testRemovalFromPendingSyncWhenMemberIsRemoved() {
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().remove(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testNewGenerationClearsPendingSyncMembers() {
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        ((Set)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}))).$minus((Object)targetState)).foreach((Function1 & Serializable & scala.Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", Time.SYSTEM.milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$1(BooleanRef joinAwaitingMemberFenced$1, JoinGroupResult joinGroupResult) {
        Errors errors = joinGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$2(BooleanRef syncAwaitingMemberFenced$1, SyncGroupResult syncGroupResult) {
        Errors errors = syncGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testInvokeSyncCallback$1(SyncGroupResult x$3) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assertions.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

