/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerState;
import kafka.controller.KafkaController;
import kafka.controller.MockEvent;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionState;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\n\u0015\u0001eAQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00047\u0001\u0001\u0006I\u0001\f\u0005\bo\u0001\u0011\r\u0011\"\u00019\u0011\u0019y\u0004\u0001)A\u0005s!9\u0001\t\u0001b\u0001\n\u0003A\u0004BB!\u0001A\u0003%\u0011\bC\u0004C\u0001\t\u0007I\u0011\u0001\u001d\t\r\r\u0003\u0001\u0015!\u0003:\u0011\u001d!\u0005A1A\u0005\u0002\u0015CaA\u0014\u0001!\u0002\u00131\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007/\u0002\u0001\u000b\u0011B)\t\u000fa\u0003!\u0019!C\u00013\"1!\r\u0001Q\u0001\niCQa\u0019\u0001\u0005B\u0011DQ!\u001d\u0001\u0005BIDa!a\u0001\u0001\t\u0003\u0011(AF\"p]R\u0014x\u000e\u001c7fe\u001a\u000b\u0017\u000e\\8wKJ$Vm\u001d;\u000b\u0005U1\u0012AC2p]R\u0014x\u000e\u001c7fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e-\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\tyBD\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\t\tC%D\u0001#\u0015\t\u0019c#A\u0003vi&d7/\u0003\u0002&E\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u0015\u0003\rawnZ\u000b\u0002YA\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u0006Y><GG\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014x-\u0003\u00026]\t1Aj\\4hKJ\fA\u0001\\8hA\u0005Aa.^7O_\u0012,7/F\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\rIe\u000e^\u0001\n]Vlgj\u001c3fg\u0002\n\u0001B\\;n!\u0006\u0014Ho]\u0001\n]Vl\u0007+\u0019:ug\u0002\nA\"\\:h#V,W/Z*ju\u0016\fQ\"\\:h#V,W/Z*ju\u0016\u0004\u0013!\u0002;pa&\u001cW#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003E\u0003\"AU+\u000e\u0003MS!\u0001\u0016&\u0002\tU$\u0018\u000e\\\u0005\u0003-N\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b%A\u0004nKR\u0014\u0018nY:\u0016\u0003i\u0003\"a\u00171\u000e\u0003qS!\u0001W/\u000b\u0005y{\u0016AB2p[6|gN\u0003\u0002\u0018a%\u0011\u0011\r\u0018\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003\u0015\u00042AZ5l\u001b\u00059'B\u00015<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003U\u001e\u00141aU3r!\taw.D\u0001n\u0015\tqg#\u0001\u0004tKJ4XM]\u0005\u0003a6\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006AA/Z1s\t><h\u000eF\u0001t!\tQD/\u0003\u0002vw\t!QK\\5uQ\t\tr\u000f\u0005\u0002y\u007f6\t\u0011P\u0003\u0002{w\u0006\u0019\u0011\r]5\u000b\u0005ql\u0018a\u00026va&$XM\u001d\u0006\u0003}J\nQA[;oSRL1!!\u0001z\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0010uKN$\b*\u00198eY\u0016LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:D3AEA\u0004!\rA\u0018\u0011B\u0005\u0004\u0003\u0017I(\u0001\u0002+fgR\u0004")
public class ControllerFailoverTest
extends KafkaServerTestHarness {
    private final Logger log = Logger.getLogger(ControllerFailoverTest.class);
    private final int numNodes;
    private final int numParts;
    private final int msgQueueSize;
    private final String topic;
    private final Properties overridingProps = new Properties();
    private final Metrics metrics = new Metrics();

    public Logger log() {
        return this.log;
    }

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public int msgQueueSize() {
        return this.msgQueueSize;
    }

    public String topic() {
        return this.topic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandleIllegalStateException() {
        KafkaController initialController = (KafkaController)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$1(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.kafkaController()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)"Could not find controller");
        });
        int initialEpoch = initialController.epoch();
        this.createTopic(this.topic(), 1, 1, this.createTopic$default$4());
        TopicPartition topicPartition = new TopicPartition("topic1", 0);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerFailoverTest.$anonfun$testHandleIllegalStateException$4(initialController, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$5(topicPartition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference exceptionThrown = new AtomicReference();
        MockEvent illegalStateEvent = new MockEvent(null, initialController, exceptionThrown, latch){
            private final KafkaController initialController$1;
            private final AtomicReference exceptionThrown$1;
            private final CountDownLatch latch$1;

            public void process() {
                try {
                    throw this.initialController$1.handleIllegalState(new IllegalStateException("Thrown for test purposes"));
                }
                catch (Throwable t) {
                    this.exceptionThrown$1.set(t);
                    this.latch$1.await();
                    return;
                }
            }

            public void preempt() {
            }
            {
                this.initialController$1 = initialController$1;
                this.exceptionThrown$1 = exceptionThrown$1;
                this.latch$1 = latch$1;
                super((ControllerState)ControllerState.BrokerChange$.MODULE$);
            }
        };
        initialController.eventManager().put((ControllerEvent)illegalStateEvent);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerFailoverTest.$anonfun$testHandleIllegalStateException$6(initialController)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ControllerFailoverTest.$anonfun$testHandleIllegalStateException$8(initialController)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        latch.countDown();
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ControllerFailoverTest.$anonfun$testHandleIllegalStateException$10(exceptionThrown)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)(exceptionThrown.get() instanceof IllegalStateException), (String)new StringBuilder(73).append("handleIllegalState should throw an IllegalStateException, but ").append(exceptionThrown).append(" was thrown").toString());
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ControllerFailoverTest.$anonfun$testHandleIllegalStateException$12(this, initialEpoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$14());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$1(KafkaServer x$2) {
        return x$2.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$4(KafkaController initialController$1, TopicPartition topicPartition$1) {
        return initialController$1.controllerContext().partitionsInState((PartitionState)OnlinePartition$.MODULE$).contains((Object)topicPartition$1);
    }

    public static final /* synthetic */ String $anonfun$testHandleIllegalStateException$5(TopicPartition topicPartition$1) {
        return new StringBuilder(45).append("Partition ").append(topicPartition$1).append(" did not transition to online state").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$6(KafkaController initialController$1) {
        return !initialController$1.kafkaScheduler().isStarted();
    }

    public static final /* synthetic */ String $anonfun$testHandleIllegalStateException$7() {
        return "Scheduler was not shutdown";
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$8(KafkaController initialController$1) {
        return !initialController$1.isActive();
    }

    public static final /* synthetic */ String $anonfun$testHandleIllegalStateException$9() {
        return "Controller did not become inactive";
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$10(AtomicReference exceptionThrown$1) {
        return Option$.MODULE$.apply(exceptionThrown$1.get()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testHandleIllegalStateException$11() {
        return "handleIllegalState did not throw an exception";
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$13(int initialEpoch$1, KafkaServer server) {
        return server.kafkaController().isActive() && server.kafkaController().epoch() > initialEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$12(ControllerFailoverTest $this, int initialEpoch$1) {
        return $this.servers().exists((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$13(initialEpoch$1, server)));
    }

    public static final /* synthetic */ String $anonfun$testHandleIllegalStateException$14() {
        return "Failed to find controller";
    }

    public ControllerFailoverTest() {
        this.numNodes = 2;
        this.numParts = 1;
        this.msgQueueSize = 1;
        this.topic = "topic1";
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
    }
}

