/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.GroupAuthorizerIntegrationTest$;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ru!B\u000f\u001f\u0011\u0003\u0019c!B\u0013\u001f\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003bB\u0018\u0002\u0005\u0004%\t\u0001\r\u0005\u0007\u0001\u0006\u0001\u000b\u0011B\u0019\t\u000f\u0005\u000b!\u0019!C\u0001a!1!)\u0001Q\u0001\nEBqaQ\u0001C\u0002\u0013\u0005A\t\u0003\u0004N\u0003\u0001\u0006I!\u0012\u0005\b\u001d\u0006\u0011\r\u0011\"\u0001E\u0011\u0019y\u0015\u0001)A\u0005\u000b\u001a!\u0001+\u0001\u0001R\u0011\u0015i3\u0002\"\u0001Y\u0011\u0015Y6\u0002\"\u0011]\r\u0011)c\u0004\u00012\t\u000b5rA\u0011A5\t\u000f-t!\u0019!C\u0001Y\"1\u0001O\u0004Q\u0001\n5DQ!\u001d\b\u0005BIDQA\u001e\b\u0005B]DQA \b\u0005B]DQa \b\u0005\u0002ABa!!\u0001\u000f\t\u0003\u0001\u0004bBA\u0002\u001d\u0011\u0005\u0013Q\u0001\u0005\b\u0003;qA\u0011IA\u0010\u0011\u001d\t)D\u0004C\u0005\u0003oA\u0011\"!\u0018\u000f#\u0003%I!a\u0018\t\u000f\u0005Ud\u0002\"\u0001\u0002 !9\u0011q\u0010\b\u0005\u0002\u0005}\u0011AH$s_V\u0004\u0018)\u001e;i_JL'0\u001a:J]R,wM]1uS>tG+Z:u\u0015\ty\u0002%A\u0002ba&T\u0011!I\u0001\u0006W\u000647.Y\u0002\u0001!\t!\u0013!D\u0001\u001f\u0005y9%o\\;q\u0003V$\bn\u001c:ju\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHo\u0005\u0002\u0002OA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0012\u0002\u001f\t\u0013xn[3s!JLgnY5qC2,\u0012!\r\t\u0003eyj\u0011a\r\u0006\u0003iU\nA!Y;uQ*\u0011agN\u0001\tg\u0016\u001cWO]5us*\u0011\u0001(O\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005R$BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001eL!aP\u001a\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006\u0001\"I]8lKJ\u0004&/\u001b8dSB\fG\u000eI\u0001\u0010\u00072LWM\u001c;Qe&t7-\u001b9bY\u0006\u00012\t\\5f]R\u0004&/\u001b8dSB\fG\u000eI\u0001\u0013\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW-F\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0003mC:<'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013aa\u0015;sS:<\u0017a\u0005\"s_.,'\u000fT5ti\u0016tWM\u001d(b[\u0016\u0004\u0013AE\"mS\u0016tG\u000fT5ti\u0016tWM\u001d(b[\u0016\f1c\u00117jK:$H*[:uK:,'OT1nK\u0002\u0012Qc\u0012:pkB\u0004&/\u001b8dSB\fGNQ;jY\u0012,'oE\u0002\f%V\u0003\"AR*\n\u0005Q;%AB(cU\u0016\u001cG\u000f\u0005\u00023-&\u0011qk\r\u0002\u0016\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0005VLG\u000eZ3s)\u0005I\u0006C\u0001.\f\u001b\u0005\t\u0011!\u00022vS2$GCA\u0019^\u0011\u0015qV\u00021\u0001`\u0003\u001d\u0019wN\u001c;fqR\u0004\"A\r1\n\u0005\u0005\u001c$!F!vi\",g\u000e^5dCRLwN\\\"p]R,\u0007\u0010^\n\u0003\u001d\r\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a\u0011\u0002\rM,'O^3s\u0013\tAWMA\bCCN,'+Z9vKN$H+Z:u)\u0005Q\u0007C\u0001\u0013\u000f\u0003!\u0011'o\\6fe&#W#A7\u0011\u0005\u0019s\u0017BA8H\u0005\u001dIe\u000e^3hKJ\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002gB\u0011\u0001\u0006^\u0005\u0003k&\u00121!\u00138u\u0003]Ig\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW-F\u0001y!\tIH0D\u0001{\u0015\tYx'A\u0004oKR<xN]6\n\u0005uT(\u0001\u0004'jgR,g.\u001a:OC6,\u0017\u0001\u00047jgR,g.\u001a:OC6,\u0017a\u00042s_.,'\u000f\u0015:j]\u000eL\u0007/\u00197\u0002\u001f\rd\u0017.\u001a8u!JLgnY5qC2\fqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004Q\u0005%\u0011bAA\u0006S\t!QK\\5u\u0011\u001d\tya\u0006a\u0001\u0003#\t!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f\u0013\u0006!Q\u000f^5m\u0013\u0011\tY\"!\u0006\u0003\u0015A\u0013x\u000e]3si&,7/A\u0003tKR,\u0006\u000f\u0006\u0002\u0002\b!\u001a\u0001$a\t\u0011\t\u0005\u0015\u0012\u0011G\u0007\u0003\u0003OQ1aHA\u0015\u0015\u0011\tY#!\f\u0002\u000f),\b/\u001b;fe*\u0019\u0011q\u0006\u001f\u0002\u000b),h.\u001b;\n\t\u0005M\u0012q\u0005\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!C2sK\u0006$X-Q2m)!\tI$!\u0012\u0002P\u0005e\u0003\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}r'A\u0002bG2LA!a\u0011\u0002>\t\u0011\u0012iY2fgN\u001cuN\u001c;s_2,e\u000e\u001e:z\u0011\u001d\t9%\u0007a\u0001\u0003\u0013\nA\"Y2m\u001fB,'/\u0019;j_:\u0004B!a\u000f\u0002L%!\u0011QJA\u001f\u00051\t5\r\\(qKJ\fG/[8o\u0011\u001d\t\t&\u0007a\u0001\u0003'\n\u0011#Y2m!\u0016\u0014X.[:tS>tG+\u001f9f!\u0011\tY$!\u0016\n\t\u0005]\u0013Q\b\u0002\u0012\u0003\u000ed\u0007+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0007\u0002CA.3A\u0005\t\u0019A\u0019\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0017aE2sK\u0006$X-Q2mI\u0011,g-Y;mi\u0012\u001aTCAA1U\r\t\u00141M\u0016\u0003\u0003K\u0002B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'A\u0005v]\u000eDWmY6fI*\u0019\u0011qN\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002t\u0005%$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tC/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a)s_\u0012,8-Z!oI\u000e{gn];nK\"\u001a1$!\u001f\u0011\t\u0005\u0015\u00121P\u0005\u0005\u0003{\n9C\u0001\u0003UKN$\u0018a\b;fgR\fU\u000f\u001e5pe&TX\r\u001a)s_\u0012,8-Z!oI\u000e{gn];nK\"\u001aA$!\u001f")
public class GroupAuthorizerIntegrationTest
extends BaseRequestTest {
    private final Integer brokerId = Predef$.MODULE$.int2Integer(0);

    public static String ClientListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName();
    }

    public static String BrokerListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName();
    }

    public static KafkaPrincipal ClientPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    public static KafkaPrincipal BrokerPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
    }

    public Integer brokerId() {
        return this.brokerId;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName(GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName());
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName(GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName());
    }

    public KafkaPrincipal brokerPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
    }

    public KafkaPrincipal clientPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), SimpleAclAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.BrokerIdProp(), this.brokerId().toString());
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
        properties.put("principal.builder.class", GroupPrincipalBuilder.class.getName());
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.doSetup(false);
        TestUtils$.MODULE$.addAndVerifyAcls((KafkaServer)this.servers().head(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.CLUSTER_ACTION, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal())}))), new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL));
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
    }

    private AccessControlEntry createAcl(AclOperation aclOperation, AclPermissionType aclPermissionType, KafkaPrincipal principal) {
        return new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), aclOperation, aclPermissionType);
    }

    private KafkaPrincipal createAcl$default$3() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    @Test
    public void testUnauthorizedProduceAndConsume() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Throwable produceException = Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(topic, (Object)"message".getBytes())).get()).getCause();
        Assertions.assertTrue((boolean)(produceException instanceof TopicAuthorizationException));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(((TopicAuthorizationException)produceException).unauthorizedTopics()).asScala());
        .colon.colon x$1 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        Properties x$4 = this.createConsumer$default$3();
        KafkaConsumer consumer = this.createConsumer(x$2, x$3, x$4, (List<String>)x$1);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        TopicAuthorizationException consumeException = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(consumeException.unauthorizedTopics()).asScala());
    }

    @Test
    public void testAuthorizedProduceAndConsume() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        TestUtils$.MODULE$.addAndVerifyAcls((KafkaServer)this.servers().head(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.WRITE, AclPermissionType.ALLOW, this.createAcl$default$3())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(topic, (Object)"message".getBytes())).get();
        TestUtils$.MODULE$.addAndVerifyAcls((KafkaServer)this.servers().head(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, this.createAcl$default$3())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
        .colon.colon x$1 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        Properties x$4 = this.createConsumer$default$3();
        KafkaConsumer consumer = this.createConsumer(x$2, x$3, x$4, (List<String>)x$1);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
    }

    public static class GroupPrincipalBuilder
    implements KafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            KafkaPrincipal kafkaPrincipal;
            String string = context.listenerName();
            String string2 = GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName();
            if (!(string2 != null ? !string2.equals(string) : string != null)) {
                kafkaPrincipal = GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
            } else {
                String string3 = GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName();
                if (!(string3 != null ? !string3.equals(string) : string != null)) {
                    kafkaPrincipal = GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
                } else {
                    throw new IllegalArgumentException(new StringBuilder(32).append("No principal mapped to listener ").append(string).toString());
                }
            }
            return kafkaPrincipal;
        }
    }
}

