/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import junit.framework.Assert;
import kafka.api.ProducerRequest;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.server.DelayedRequest;
import kafka.server.RequestPurgatory;
import kafka.server.RequestPurgatory$;
import kafka.utils.TestUtils$;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u000f\t!\"+Z9vKN$\b+\u001e:hCR|'/\u001f+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\f\u0015Vs\u0017\u000e^\u001aTk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!9\u0001\u0004\u0001b\u0001\n\u0003I\u0012\u0001\u00059s_\u0012,8-\u001a:SKF,Xm\u001d;2+\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0005\u0003\r\t\u0007/[\u0005\u0003?q\u0011q\u0002\u0015:pIV\u001cWM\u001d*fcV,7\u000f\u001e\u0005\u0007C\u0001\u0001\u000b\u0011\u0002\u000e\u0002#A\u0014x\u000eZ;dKJ\u0014V-];fgR\f\u0004\u0005C\u0004$\u0001\t\u0007I\u0011A\r\u0002!A\u0014x\u000eZ;dKJ\u0014V-];fgR\u0014\u0004BB\u0013\u0001A\u0003%!$A\tqe>$WoY3s%\u0016\fX/Z:ue\u0001Bqa\n\u0001A\u0002\u0013\u0005\u0001&A\u0005qkJ<\u0017\r^8ssV\t\u0011\u0006\u0005\u0002+W5\t\u0001A\u0002\u0003-\u0001\u0001i#\u0001F'pG.\u0014V-];fgR\u0004VO]4bi>\u0014\u0018p\u0005\u0002,]A\u0019acL\u0019\n\u0005A\u0012!\u0001\u0005*fcV,7\u000f\u001e)ve\u001e\fGo\u001c:z!\t1\"'\u0003\u00024\u0005\tqA)\u001a7bs\u0016$'+Z9vKN$\b\u0002C\u001b,\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u000bA,(oZ3\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\u0007%sG\u000fC\u0003\u0014W\u0011\u0005Q\b\u0006\u0002*}!)Q\u0007\u0010a\u0001m!9\u0001i\u000bb\u0001\n\u0003\t\u0015!C:bi&\u001ch-[3e+\u0005\u0011\u0005cA\"Ic5\tAI\u0003\u0002F\r\u00069Q.\u001e;bE2,'BA$9\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0013\u0012\u00131aU3u\u0011\u0019Y5\u0006)A\u0005\u0005\u0006Q1/\u0019;jg\u001aLW\r\u001a\u0011\t\u000f5[#\u0019!C\u0001\u0003\u00069Q\r\u001f9je\u0016$\u0007BB(,A\u0003%!)\u0001\u0005fqBL'/\u001a3!\u0011\u0015\t6\u0006\"\u0001S\u0003=\tw/Y5u\u000bb\u0004\u0018N]1uS>tGCA*W!\t9D+\u0003\u0002Vq\t!QK\\5u\u0011\u00159\u0006\u000b1\u00012\u0003\u001d!W\r\\1zK\u0012DQ!W\u0016\u0005\u0002i\u000bab\u00195fG.\u001c\u0016\r^5tM&,G\r\u0006\u0002\\=B\u0011q\u0007X\u0005\u0003;b\u0012qAQ8pY\u0016\fg\u000eC\u0003X1\u0002\u0007\u0011\u0007C\u0003aW\u0011\u0005\u0011-\u0001\u0004fqBL'/\u001a\u000b\u0003'\nDQaV0A\u0002EBq\u0001\u001a\u0001A\u0002\u0013\u0005Q-A\u0007qkJ<\u0017\r^8ss~#S-\u001d\u000b\u0003'\u001aDqaZ2\u0002\u0002\u0003\u0007\u0011&A\u0002yIEBa!\u001b\u0001!B\u0013I\u0013A\u00039ve\u001e\fGo\u001c:zA!)1\u000e\u0001C!Y\u0006)1/\u001a;VaR\t1\u000bC\u0003o\u0001\u0011\u0005C.\u0001\u0005uK\u0006\u0014Hi\\<o\u0011\u0015\u0001\b\u0001\"\u0001m\u0003]!Xm\u001d;SKF,Xm\u001d;TCRL7OZ1di&|g\u000e\u000b\u0002peB\u00111/^\u0007\u0002i*\u00111BD\u0005\u0003mR\u0014A\u0001V3ti\")\u0001\u0010\u0001C\u0001Y\u0006\tB/Z:u%\u0016\fX/Z:u\u000bb\u0004\u0018N]=)\u0005]\u0014\b\"B>\u0001\t\u0003a\u0017\u0001\u0005;fgR\u0014V-];fgR\u0004VO]4fQ\tQ(\u000f")
public class RequestPurgatoryTest
extends JUnit3Suite {
    private final ProducerRequest producerRequest1 = TestUtils$.MODULE$.produceRequest("test", 0, new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello1".getBytes())})), TestUtils$.MODULE$.produceRequest$default$4(), TestUtils$.MODULE$.produceRequest$default$5(), TestUtils$.MODULE$.produceRequest$default$6(), TestUtils$.MODULE$.produceRequest$default$7());
    private final ProducerRequest producerRequest2 = TestUtils$.MODULE$.produceRequest("test", 0, new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello2".getBytes())})), TestUtils$.MODULE$.produceRequest$default$4(), TestUtils$.MODULE$.produceRequest$default$5(), TestUtils$.MODULE$.produceRequest$default$6(), TestUtils$.MODULE$.produceRequest$default$7());
    private MockRequestPurgatory purgatory = null;

    public ProducerRequest producerRequest1() {
        return this.producerRequest1;
    }

    public ProducerRequest producerRequest2() {
        return this.producerRequest2;
    }

    public MockRequestPurgatory purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(MockRequestPurgatory x$1) {
        this.purgatory = x$1;
    }

    public void setUp() {
        super.setUp();
        this.purgatory_$eq(new MockRequestPurgatory(5));
    }

    public void tearDown() {
        this.purgatory().shutdown();
        super.tearDown();
    }

    @Test
    public void testRequestSatisfaction() {
        DelayedRequest r1 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}), null, 100000L);
        DelayedRequest r2 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"}), null, 100000L);
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (int)0, (int)this.purgatory().update("test1").size());
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().checkAndMaybeWatch(r1));
        Assert.assertEquals((String)"Still nothing satisfied", (int)0, (int)this.purgatory().update("test1").size());
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().checkAndMaybeWatch(r2));
        Assert.assertEquals((String)"Still nothing satisfied", (int)0, (int)this.purgatory().update("test2").size());
        this.purgatory().satisfied().$plus$eq((Object)r1);
        Assert.assertEquals((String)"r1 satisfied", (Object)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DelayedRequest[]{r1})), (Object)this.purgatory().update("test1"));
        Assert.assertEquals((String)"Nothing satisfied", (int)0, (int)this.purgatory().update("test1").size());
        this.purgatory().satisfied().$plus$eq((Object)r2);
        Assert.assertEquals((String)"r2 satisfied", (Object)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DelayedRequest[]{r2})), (Object)this.purgatory().update("test2"));
        Assert.assertEquals((String)"Nothing satisfied", (int)0, (int)this.purgatory().update("test2").size());
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        DelayedRequest r1 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}), null, expiration);
        DelayedRequest r2 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}), null, 200000L);
        long start = System.currentTimeMillis();
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().checkAndMaybeWatch(r1));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().checkAndMaybeWatch(r2));
        this.purgatory().awaitExpiration(r1);
        long elapsed = System.currentTimeMillis() - start;
        Assert.assertTrue((String)"r1 expired", (boolean)this.purgatory().expired().contains((Object)r1));
        Assert.assertTrue((String)"r2 hasn't expired", (!this.purgatory().expired().contains((Object)r2) ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("Time for expiration %d should at least %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)elapsed), BoxesRunTime.boxToLong((long)expiration)})), (elapsed >= expiration ? 1 : 0) != 0);
    }

    @Test
    public void testRequestPurge() {
        DelayedRequest r1 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}), null, 100000L);
        DelayedRequest r12 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}), null, 100000L);
        DelayedRequest r23 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2", "test3"}), null, 100000L);
        this.purgatory().checkAndMaybeWatch(r1);
        this.purgatory().checkAndMaybeWatch(r12);
        this.purgatory().checkAndMaybeWatch(r23);
        Assert.assertEquals((String)"Purgatory should have 5 watched elements", (int)5, (int)this.purgatory().watched());
        Assert.assertEquals((String)"Purgatory should have 3 total delayed requests", (int)3, (int)this.purgatory().delayed());
        r12.satisfied().set(true);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RequestPurgatoryTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.purgatory().watched() == 3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new StringBuilder().append((Object)"Purgatory should have 3 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), 1000L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RequestPurgatoryTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.purgatory().delayed() == 3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new StringBuilder().append((Object)"Purgatory should still have 3 total delayed requests instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().delayed())).toString(), 1000L);
        this.purgatory().checkAndMaybeWatch(r1);
        this.purgatory().checkAndMaybeWatch(r1);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RequestPurgatoryTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.purgatory().watched() == 5;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new StringBuilder().append((Object)"Purgatory should have 5 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), 1000L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RequestPurgatoryTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.purgatory().delayed() == 4;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new StringBuilder().append((Object)"Purgatory should have 4 total delayed requests instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().delayed())).toString(), 1000L);
    }

    public class MockRequestPurgatory
    extends RequestPurgatory<DelayedRequest> {
        private final Set<DelayedRequest> satisfied;
        private final Set<DelayedRequest> expired;

        public Set<DelayedRequest> satisfied() {
            return this.satisfied;
        }

        public Set<DelayedRequest> expired() {
            return this.expired;
        }

        public void awaitExpiration(DelayedRequest delayed) {
            DelayedRequest delayedRequest = delayed;
            synchronized (delayedRequest) {
                delayed.wait();
                return;
            }
        }

        public boolean checkSatisfied(DelayedRequest delayed) {
            return this.satisfied().contains((Object)delayed);
        }

        public void expire(DelayedRequest delayed) {
            this.expired().$plus$eq((Object)delayed);
            DelayedRequest delayedRequest = delayed;
            synchronized (delayedRequest) {
                delayed.notify();
                return;
            }
        }

        public /* synthetic */ RequestPurgatoryTest kafka$server$RequestPurgatoryTest$MockRequestPurgatory$$$outer() {
            return RequestPurgatoryTest.this;
        }

        public MockRequestPurgatory(int purge) {
            if (RequestPurgatoryTest.this == null) {
                throw null;
            }
            int x$1 = purge;
            int x$2 = RequestPurgatory$.MODULE$.$lessinit$greater$default$1();
            super(x$2, x$1);
            this.satisfied = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.expired = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    }
}

