/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import junit.framework.Assert;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.common.TopicAndPartition;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u000f\t9B)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\n\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u00111BS+oSR\u001c4+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u0018)\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001b\u0001\n\u0003z\u0012aB2p]\u001aLwm]\u000b\u0002AA\u0019\u0011\u0005\u000b\u0016\u000e\u0003\tR!a\t\u0013\u0002\u0013%lW.\u001e;bE2,'BA\u0013'\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\t\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002\u001dW%\u0011AF\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0004/\u0001\u0001\u0006I\u0001I\u0001\tG>tg-[4tA!)\u0001\u0007\u0001C\u0001c\u0005\u0001B/Z:u\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0002eA\u00111\u0007N\u0007\u0002M%\u0011QG\n\u0002\u0005+:LG\u000f\u000b\u00020oA\u0011\u0001HO\u0007\u0002s)\u00111BD\u0005\u0003we\u0012A\u0001V3ti\")Q\b\u0001C\u0001c\u0005\u0011C/Z:u\u0007>tg-[4DQ\u0006tw-Z(o\u001d>tW\t_5ti&tw\rV8qS\u000eD#\u0001P\u001c")
public class DynamicConfigChangeTest
extends JUnit3Suite
implements KafkaServerTestHarness {
    private final List<KafkaConfig> configs;
    private List<KafkaServer> servers;
    private String brokerList;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public List<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    @TraitSetter
    public void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    @TraitSetter
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public List<KafkaConfig> configs() {
        return this.configs;
    }

    @Test
    public void testConfigChange() {
        int oldVal = 100000;
        int newVal = 200000;
        TopicAndPartition tp = new TopicAndPartition("test", 0);
        long x$1 = oldVal;
        int x$2 = LogConfig$.MODULE$.apply$default$1();
        long x$3 = LogConfig$.MODULE$.apply$default$2();
        long x$4 = LogConfig$.MODULE$.apply$default$3();
        long x$5 = LogConfig$.MODULE$.apply$default$5();
        long x$6 = LogConfig$.MODULE$.apply$default$6();
        long x$7 = LogConfig$.MODULE$.apply$default$7();
        int x$8 = LogConfig$.MODULE$.apply$default$8();
        int x$9 = LogConfig$.MODULE$.apply$default$9();
        int x$10 = LogConfig$.MODULE$.apply$default$10();
        long x$11 = LogConfig$.MODULE$.apply$default$11();
        long x$12 = LogConfig$.MODULE$.apply$default$12();
        double x$13 = LogConfig$.MODULE$.apply$default$13();
        boolean x$14 = LogConfig$.MODULE$.apply$default$14();
        boolean x$15 = LogConfig$.MODULE$.apply$default$15();
        int x$16 = LogConfig$.MODULE$.apply$default$16();
        AdminUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), 1, 1, new LogConfig(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16).toProps());
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, oldVal, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;
            private final int oldVal$1;
            private final TopicAndPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option logOpt = ((KafkaServer)this.$outer.servers().apply(0)).logManager().getLog(this.tp$1);
                Assert.assertTrue((boolean)logOpt.isDefined());
                Assert.assertEquals((long)this.oldVal$1, (long)((Log)logOpt.get()).config().flushInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.oldVal$1 = oldVal$1;
                this.tp$1 = tp$1;
            }
        });
        long x$17 = newVal;
        int x$18 = LogConfig$.MODULE$.apply$default$1();
        long x$19 = LogConfig$.MODULE$.apply$default$2();
        long x$20 = LogConfig$.MODULE$.apply$default$3();
        long x$21 = LogConfig$.MODULE$.apply$default$5();
        long x$22 = LogConfig$.MODULE$.apply$default$6();
        long x$23 = LogConfig$.MODULE$.apply$default$7();
        int x$24 = LogConfig$.MODULE$.apply$default$8();
        int x$25 = LogConfig$.MODULE$.apply$default$9();
        int x$26 = LogConfig$.MODULE$.apply$default$10();
        long x$27 = LogConfig$.MODULE$.apply$default$11();
        long x$28 = LogConfig$.MODULE$.apply$default$12();
        double x$29 = LogConfig$.MODULE$.apply$default$13();
        boolean x$30 = LogConfig$.MODULE$.apply$default$14();
        boolean x$31 = LogConfig$.MODULE$.apply$default$15();
        int x$32 = LogConfig$.MODULE$.apply$default$16();
        AdminUtils$.MODULE$.changeTopicConfig(this.zkClient(), tp.topic(), new LogConfig(x$18, x$19, x$20, x$17, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32).toProps());
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, newVal, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;
            private final int newVal$1;
            private final TopicAndPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertEquals((long)this.newVal$1, (long)((Log)((KafkaServer)this.$outer.servers().apply(0)).logManager().getLog(this.tp$1).get()).config().flushInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newVal$1 = newVal$1;
                this.tp$1 = tp$1;
            }
        });
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try {
            long x$33 = 10000L;
            int x$34 = LogConfig$.MODULE$.apply$default$1();
            long x$35 = LogConfig$.MODULE$.apply$default$2();
            long x$36 = LogConfig$.MODULE$.apply$default$3();
            long x$37 = LogConfig$.MODULE$.apply$default$5();
            long x$38 = LogConfig$.MODULE$.apply$default$6();
            long x$39 = LogConfig$.MODULE$.apply$default$7();
            int x$40 = LogConfig$.MODULE$.apply$default$8();
            int x$41 = LogConfig$.MODULE$.apply$default$9();
            int x$42 = LogConfig$.MODULE$.apply$default$10();
            long x$43 = LogConfig$.MODULE$.apply$default$11();
            long x$44 = LogConfig$.MODULE$.apply$default$12();
            double x$45 = LogConfig$.MODULE$.apply$default$13();
            boolean x$46 = LogConfig$.MODULE$.apply$default$14();
            boolean x$47 = LogConfig$.MODULE$.apply$default$15();
            int x$48 = LogConfig$.MODULE$.apply$default$16();
            AdminUtils$.MODULE$.changeTopicConfig(this.zkClient(), topic, new LogConfig(x$34, x$35, x$36, x$33, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48).toProps());
            throw this.fail("Should fail with AdminOperationException for topic doesn't exist");
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    public DynamicConfigChangeTest() {
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.configs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{new KafkaConfig(TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.choosePort(), TestUtils$.MODULE$.createBrokerConfig$default$3()))}));
    }
}

