/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminTest$;
import kafka.admin.AdminUtils$;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentStatus;
import kafka.api.PartitionStateInfo;
import kafka.common.TopicAndPartition;
import kafka.common.TopicExistsException;
import kafka.controller.KafkaController;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u000f\tI\u0011\tZ7j]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0005\r\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u00111BS+oSR\u001c4+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\tIB$D\u0001\u001b\u0015\tYB!A\u0003vi&d7/\u0003\u0002\u001e5\t9Aj\\4hS:<\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u0011\u0015!\u0003\u0001\"\u0001&\u0003U!Xm\u001d;SKBd\u0017nY1BgNLwM\\7f]R$\u0012A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0005+:LG\u000f\u000b\u0002$[A\u0011a\u0006M\u0007\u0002_)\u00111BD\u0005\u0003c=\u0012A\u0001V3ti\")1\u0007\u0001C\u0001K\u0005YB/Z:u\u001b\u0006tW/\u00197SKBd\u0017nY1BgNLwM\\7f]RD#AM\u0017\t\u000bY\u0002A\u0011A\u0013\u0002+Q,7\u000f\u001e+pa&\u001c7I]3bi&|g.\u00138[\u0017\"\u0012Q'\f\u0005\u0006s\u0001!IAO\u0001\u001bO\u0016$(I]8lKJ\u001cx+\u001b;i!\u0006\u0014H/\u001b;j_:$\u0015N\u001d\u000b\u0005w\u0015Kf\fE\u0002=\u007f\ts!aJ\u001f\n\u0005yB\u0013A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n\u00191+\u001a;\u000b\u0005yB\u0003CA\u0014D\u0013\t!\u0005FA\u0002J]RDQA\u0012\u001dA\u0002\u001d\u000bqa]3sm\u0016\u00148\u000fE\u0002I!Ns!!\u0013(\u000f\u0005)kU\"A&\u000b\u000513\u0011A\u0002\u001fs_>$h(C\u0001*\u0013\ty\u0005&A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0013&\u0001C%uKJ\f'\r\\3\u000b\u0005=C\u0003C\u0001+X\u001b\u0005)&B\u0001,\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001,\u0016\u0002\f\u0017\u000647.Y*feZ,'\u000fC\u0003[q\u0001\u00071,A\u0003u_BL7\r\u0005\u0002=9&\u0011Q,\u0011\u0002\u0007'R\u0014\u0018N\\4\t\u000b}C\u0004\u0019\u0001\"\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\u0006C\u0002!\t!J\u00011i\u0016\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGoV5uQ2+\u0017\rZ3s\u0013:tUm\u001e*fa2L7-Y:)\u0005\u0001l\u0003\"\u00023\u0001\t\u0003)\u0013a\r;fgR\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R<\u0016\u000e\u001e5MK\u0006$WM\u001d(pi&sg*Z<SKBd\u0017nY1tQ\t\u0019W\u0006C\u0003h\u0001\u0011\u0005Q%A\u0018uKN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$hj\u001c8Pm\u0016\u0014H.\u00199qS:<'+\u001a9mS\u000e\f7\u000f\u000b\u0002g[!)!\u000e\u0001C\u0001K\u0005\u0019C/Z:u%\u0016\f7o]5h]&twMT8o\u000bbL7\u000f^5oOB\u000b'\u000f^5uS>t\u0007FA5.\u0011\u0015i\u0007\u0001\"\u0001&\u0003=\"Xm\u001d;SKN,X.\u001a)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e+iCR<\u0016m]\"p[BdW\r^3eQ\taW\u0006C\u0003q\u0001\u0011\u0005Q%\u0001\u000fuKN$\bK]3gKJ\u0014X\r\u001a*fa2L7-\u0019&t_:$\u0015\r^1)\u0005=l\u0003\"B:\u0001\t\u0003)\u0013!\t;fgR\u0014\u0015m]5d!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006,E.Z2uS>t\u0007F\u0001:.\u0011\u00151\b\u0001\"\u0001&\u0003I!Xm\u001d;TQV$Hm\\<o\u0005J|7.\u001a:)\u0005Ul\u0003\"B=\u0001\t\u0003)\u0013!\u0006;fgR$v\u000e]5d\u0007>tg-[4DQ\u0006tw-\u001a\u0015\u0003q6\u0002")
public class AdminTest
extends JUnit3Suite
implements ZooKeeperTestHarness,
Logging {
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminTest adminTest = this;
        synchronized (adminTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testReplicaAssignment() {
        List brokerList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        this.intercept((Function0)new Serializable(this, brokerList){
            public static final long serialVersionUID = 0L;
            private final List brokerList$1;

            public final Map<Object, Seq<Object>> apply() {
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)this.brokerList$1, 10, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            }
            {
                this.brokerList$1 = brokerList$1;
            }
        }, ManifestFactory$.MODULE$.classType(AdminOperationException.class));
        this.intercept((Function0)new Serializable(this, brokerList){
            public static final long serialVersionUID = 0L;
            private final List brokerList$1;

            public final Map<Object, Seq<Object>> apply() {
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)this.brokerList$1, 10, 6, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            }
            {
                this.brokerList$1 = brokerList$1;
            }
        }, ManifestFactory$.MODULE$.classType(AdminOperationException.class));
        scala.collection.immutable.Map expectedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2})))}));
        Map actualAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)brokerList, 10, 3, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        List list = expectedAssignment.toList();
        List list2 = actualAssignment.toList();
        boolean e = !(list != null ? !list.equals(list2) : list2 != null);
        List list3 = expectedAssignment.toList();
        List list4 = actualAssignment.toList();
        Assert.assertTrue((!(list3 != null ? !list3.equals(list4) : list4 != null) ? 1 : 0) != 0);
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkClient(), "test", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkClient(), "test", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), "test", (Map)assignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        scala.collection.mutable.Map found = ZkUtils$.MODULE$.getPartitionAssignmentForTopics(this.zkClient(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assert.assertEquals((Object)assignment, (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkClient(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaList = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps((int[])leaderForPartitionMap.keys().toArray(ClassTag$.MODULE$.Int())).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$1;

            public final Tuple2<Object, Seq<Object>> apply(int p) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p)), (Object)ZkUtils$.MODULE$.getReplicasForPartition(this.$outer.zkClient(), this.topic$1, p));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((int)expectedReplicaAssignment.size(), (int)actualReplicaList.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), actualReplicaList.size()).foreach$mVc$sp((Function1)new Serializable(this, expectedReplicaAssignment, actualReplicaList){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map expectedReplicaAssignment$1;
            private final scala.collection.immutable.Map actualReplicaList$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((Object)this.expectedReplicaAssignment$1.get((Object)BoxesRunTime.boxToInteger((int)i)).get(), (Object)this.actualReplicaList$1.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.actualReplicaList$1 = actualReplicaList$1;
            }
        });
        this.intercept((Function0)new Serializable(this, expectedReplicaAssignment, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final scala.collection.immutable.Map expectedReplicaAssignment$1;
            private final String topic$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkClient(), this.topic$1, (Map)this.expectedReplicaAssignment$1, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.topic$1 = topic$1;
            }
        }, ManifestFactory$.MODULE$.classType(TopicExistsException.class));
    }

    public scala.collection.immutable.Set<Object> kafka$admin$AdminTest$$getBrokersWithPartitionDir(Iterable<KafkaServer> servers, String topic, int partitionId) {
        return ((TraversableOnce)((TraversableLike)servers.filter((Function1)new Serializable(this, topic, partitionId){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final int partitionId$1;

            public final boolean apply(KafkaServer server) {
                return new File((String)server.config().logDirs().head(), new StringBuilder().append((Object)this.topic$2).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1)).toString()).exists();
            }
            {
                this.topic$2 = topic$2;
                this.partitionId$1 = partitionId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$1) {
                return x$1.config().brokerId();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Test
    public void testPartitionReassignmentWithLeaderInNewReplicas() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        List servers = (List)TestUtils$.MODULE$.createBrokerConfigs(4, false).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(new KafkaConfig(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment attempt failed for [test, 0]", (boolean)reassignPartitionsCommand.reassignPartitions());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$1;
            private final TopicAndPartition topicAndPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = ZkUtils$.MODULE$.getPartitionsBeingReassigned(this.$outer.zkClient()).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$2) {
                        return x$2.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkClient(), this.topicAndPartition$1, this.newReplicas$1, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition$1), (Object)this.newReplicas$1)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newReplicas$1 = newReplicas$1;
                this.topicAndPartition$1 = topicAndPartition$1;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.zkClient(), topic, partitionToBeReassigned);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$3;
            private final List servers$1;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$1, this.topic$3, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$1.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.servers$1 = servers$1;
                this.newReplicas$1 = newReplicas$1;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$3) {
                x$3.shutdown();
            }
        });
    }

    @Test
    public void testPartitionReassignmentWithLeaderNotInNewReplicas() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        List servers = (List)TestUtils$.MODULE$.createBrokerConfigs(4, false).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(new KafkaConfig(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$2;
            private final TopicAndPartition topicAndPartition$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = ZkUtils$.MODULE$.getPartitionsBeingReassigned(this.$outer.zkClient()).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$4) {
                        return x$4.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkClient(), this.topicAndPartition$2, this.newReplicas$2, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition$2), (Object)this.newReplicas$2)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newReplicas$2 = newReplicas$2;
                this.topicAndPartition$2 = topicAndPartition$2;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.zkClient(), topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$4;
            private final List servers$2;
            private final Seq newReplicas$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$2, this.topic$4, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$2.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$4 = topic$4;
                this.servers$2 = servers$2;
                this.newReplicas$2 = newReplicas$2;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$5) {
                x$5.shutdown();
            }
        });
    }

    @Test
    public void testPartitionReassignmentNonOverlappingReplicas() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        List servers = (List)TestUtils$.MODULE$.createBrokerConfigs(4, false).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(new KafkaConfig(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$3;
            private final TopicAndPartition topicAndPartition$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = ZkUtils$.MODULE$.getPartitionsBeingReassigned(this.$outer.zkClient()).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$6) {
                        return x$6.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkClient(), this.topicAndPartition$3, this.newReplicas$3, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition$3), (Object)this.newReplicas$3)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newReplicas$3 = newReplicas$3;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.zkClient(), topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$5;
            private final List servers$3;
            private final Seq newReplicas$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$3, this.topic$5, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$3.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$5 = topic$5;
                this.servers$3 = servers$3;
                this.newReplicas$3 = newReplicas$3;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$7) {
                x$7.shutdown();
            }
        });
    }

    @Test
    public void testReassigningNonExistingPartition() {
        String topic = "test";
        List servers = (List)TestUtils$.MODULE$.createBrokerConfigs(4, false).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(new KafkaConfig(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions());
        Map reassignedPartitions = ZkUtils$.MODULE$.getPartitionsBeingReassigned(this.zkClient());
        Assert.assertFalse((String)"Partition should not be reassigned", (boolean)reassignedPartitions.contains((Object)topicAndPartition));
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$8) {
                x$8.shutdown();
            }
        });
    }

    @Test
    public void testResumePartitionReassignmentThatWasCompleted() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        reassignPartitionsCommand.reassignPartitions();
        List servers = (List)TestUtils$.MODULE$.createBrokerConfigs(2, false).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(new KafkaConfig(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !TestUtils$.MODULE$.checkIfReassignPartitionPathExists(this.$outer.zkClient());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.zkClient(), topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 1", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkClient(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, newReplicas, servers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$6;
            private final Seq newReplicas$4;
            private final List servers$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$4, this.topic$6, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$4.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$6 = topic$6;
                this.newReplicas$4 = newReplicas$4;
                this.servers$4 = servers$4;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$9) {
                x$9.shutdown();
            }
        });
    }

    @Test
    public void testPreferredReplicaJsonData() {
        scala.collection.immutable.Set partitionsForPreferredReplicaElection = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test", 1), new TopicAndPartition("test2", 1)}));
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkClient(), (Set)partitionsForPreferredReplicaElection);
        String preferredReplicaElectionZkData = (String)ZkUtils$.MODULE$.readData(this.zkClient(), ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath())._1();
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData(preferredReplicaElectionZkData);
        Assert.assertEquals((String)"Preferred replica election ser-de failed", (Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection);
    }

    @Test
    public void testBasicPreferredReplicaElection() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        int preferredReplica = 0;
        List serverConfigs = (List)TestUtils$.MODULE$.createBrokerConfigs(3, false).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties x$10) {
                return new KafkaConfig(x$10);
            }
        }, List$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        List servers = (List)serverConfigs.reverse().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        ZkClient x$21 = this.zkClient();
        String x$22 = topic;
        int x$23 = partition;
        None$ x$24 = None$.MODULE$;
        long x$25 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$26 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int currentLeader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$21, x$22, x$23, x$25, (Option<Object>)x$24, x$26).get());
        PreferredReplicaLeaderElectionCommand preferredReplicaElection = new PreferredReplicaLeaderElectionCommand(this.zkClient(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, partition)})));
        preferredReplicaElection.moveLeaderToPreferredReplica();
        ZkClient x$27 = this.zkClient();
        String x$28 = topic;
        int x$29 = partition;
        Some x$30 = new Some((Object)BoxesRunTime.boxToInteger((int)currentLeader));
        long x$31 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$32 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int newLeader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$27, x$28, x$29, x$31, (Option<Object>)x$30, x$32).get());
        Assert.assertEquals((String)"Preferred replica election failed", (int)preferredReplica, (int)newLeader);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$11) {
                x$11.shutdown();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShutdownBroker() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        List serverConfigs = (List)TestUtils$.MODULE$.createBrokerConfigs(3, false).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties x$12) {
                return new KafkaConfig(x$12);
            }
        }, List$.MODULE$.canBuildFrom());
        List servers = (List)serverConfigs.reverse().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)servers);
        int controllerId = ZkUtils$.MODULE$.getController(this.zkClient());
        KafkaController controller = ((KafkaServer)servers.find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer p) {
                return p.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        }).get()).kafkaController();
        Set partitionsRemaining = controller.shutdownBroker(2);
        ObjectRef activeServers = ObjectRef.create((Object)((List)servers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != 2;
            }
        })));
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, partition, activeServers){
                public static final long serialVersionUID = 0L;
                public final String topic$7;
                public final int partition$1;
                private final ObjectRef activeServers$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return BoxesRunTime.unboxToBoolean((Object)((List)this.activeServers$1.elem).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testShutdownBroker$1 $outer;

                        public final boolean apply(boolean x$13, KafkaServer x$14) {
                            return x$13 && ((PartitionStateInfo)x$14.apis().metadataCache().getPartitionInfo(this.$outer.topic$7, this.$outer.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().isr().size() != 3;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                {
                    this.topic$7 = topic$7;
                    this.partition$1 = partition$1;
                    this.activeServers$1 = activeServers$1;
                }
            }, "Topic test not created after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
            Assert.assertEquals((int)0, (int)partitionsRemaining.size());
            PartitionStateInfo partitionStateInfo = (PartitionStateInfo)((KafkaServer)((List)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
            int leaderAfterShutdown = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
            Assert.assertEquals((int)0, (int)leaderAfterShutdown);
            Assert.assertEquals((int)2, (int)partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().isr().size());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().isr());
            partitionsRemaining = controller.shutdownBroker(1);
            Assert.assertEquals((int)0, (int)partitionsRemaining.size());
            activeServers.elem = (List)servers.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer s) {
                    return s.config().brokerId() == 0;
                }
            });
            partitionStateInfo = (PartitionStateInfo)((KafkaServer)((List)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
            leaderAfterShutdown = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
            Assert.assertEquals((int)0, (int)leaderAfterShutdown);
            Assert.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)servers.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this, topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$7;
                private final int partition$1;

                public final boolean apply(boolean x$15, KafkaServer x$16) {
                    return x$15 && ((PartitionStateInfo)x$16.apis().metadataCache().getPartitionInfo(this.topic$7, this.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == 0;
                }
                {
                    this.topic$7 = topic$7;
                    this.partition$1 = partition$1;
                }
            })));
            partitionsRemaining = controller.shutdownBroker(0);
            Assert.assertEquals((int)1, (int)partitionsRemaining.size());
            Assert.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)servers.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this, topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$7;
                private final int partition$1;

                public final boolean apply(boolean x$17, KafkaServer x$18) {
                    return x$17 && ((PartitionStateInfo)x$18.apis().metadataCache().getPartitionInfo(this.topic$7, this.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == 0;
                }
                {
                    this.topic$7 = topic$7;
                    this.partition$1 = partition$1;
                }
            })));
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$19) {
                    x$19.shutdown();
                }
            });
            throw throwable;
        }
        servers.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicConfigChange() {
        int partitions = 3;
        String topic = "my-topic";
        KafkaServer server = TestUtils$.MODULE$.createServer(new KafkaConfig(TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.createBrokerConfig$default$2(), TestUtils$.MODULE$.createBrokerConfig$default$3())), TestUtils$.MODULE$.createServer$default$2());
        try {
            int maxMessageSize = 1024;
            int retentionMs = 1000000;
            AdminUtils$.MODULE$.createTopic(server.zkClient(), topic, partitions, 1, this.makeConfig$1(maxMessageSize, retentionMs));
            this.checkConfig$1(maxMessageSize, retentionMs, partitions, topic, server);
            AdminUtils$.MODULE$.changeTopicConfig(server.zkClient(), topic, this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs));
            this.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, partitions, topic, server);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.shutdown();
            var3_3.config().logDirs().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$20) {
                    Utils$.MODULE$.rm(x$20);
                }
            }, Seq$.MODULE$.canBuildFrom());
            throw throwable;
        }
        server.shutdown();
        server.config().logDirs().map((Function1)new /* invalid duplicate definition of identical inner class */, Seq$.MODULE$.canBuildFrom());
    }

    private final Properties makeConfig$1(int messageSize, long retentionMs) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)messageSize)).toString());
        props.setProperty(LogConfig$.MODULE$.RententionMsProp(), ((Object)BoxesRunTime.boxToLong((long)retentionMs)).toString());
        return props;
    }

    private final void checkConfig$1(int messageSize, long retentionMs, int partitions$1, String topic$8, KafkaServer server$1) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, partitions$1, topic$8, server$1, messageSize, retentionMs){
            public static final long serialVersionUID = 0L;
            private final int partitions$1;
            public final String topic$8;
            public final KafkaServer server$1;
            public final int messageSize$1;
            public final long retentionMs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitions$1).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkConfig$1$1 $outer;

                    public final void apply(int part) {
                        this.apply$mcVI$sp(part);
                    }

                    public void apply$mcVI$sp(int part) {
                        Option logOpt = this.$outer.server$1.logManager().getLog(new TopicAndPartition(this.$outer.topic$8, part));
                        Assert.assertTrue((boolean)logOpt.isDefined());
                        Assert.assertEquals((long)this.$outer.retentionMs$1, (long)((Log)logOpt.get()).config().retentionMs());
                        Assert.assertEquals((int)this.$outer.messageSize$1, (int)((Log)logOpt.get()).config().maxMessageSize());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.partitions$1 = partitions$1;
                this.topic$8 = topic$8;
                this.server$1 = server$1;
                this.messageSize$1 = messageSize$1;
                this.retentionMs$1 = retentionMs$1;
            }
        });
    }

    public AdminTest() {
        ZooKeeperTestHarness$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }
}

