/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtils$;
import kafka.admin.ConfigCommand;
import kafka.common.Config;
import kafka.common.Config$class;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.QuotaId$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConfigCommand$
implements Config {
    public static final ConfigCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConfigCommand$();
    }

    @Override
    public void validateChars(String prop, String value2) {
        Config$class.validateChars(this, prop, value2);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConfigCommand$ configCommand$ = this;
        synchronized (configCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Add/Remove entity config for a topic, client, user or broker");
        }
        opts.checkArgs();
        try (ZkUtils zkUtils = ZkUtils$.MODULE$.apply((String)opts.options().valueOf(opts.zkConnectOpt()), 30000, 30000, JaasUtils.isZkSecurityEnabled());){
            try {
                if (opts.options().has((OptionSpec)opts.alterOpt())) {
                    this.alterConfig(zkUtils, opts, this.alterConfig$default$3());
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeConfig(zkUtils, opts);
                }
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Error while executing config command ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)throwable));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterConfig(ZkUtils zkUtils, ConfigCommand.ConfigCommandOptions opts, AdminUtilities utils) {
        void var7_7;
        block6: {
            ConfigCommand.ConfigEntity entity;
            block3: {
                String string;
                Properties configs;
                String entityName;
                block5: {
                    block4: {
                        block2: {
                            Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
                            Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
                            entity = this.parseEntity(opts);
                            String entityType = entity.root().entityType();
                            entityName = entity.fullSanitizedName();
                            configs = utils.fetchEntityConfig(zkUtils, entityType, entityName);
                            configs.putAll((Map<?, ?>)configsToBeAdded);
                            configsToBeDeleted.foreach((Function1)new Serializable(configs){
                                public static final long serialVersionUID = 0L;
                                private final Properties configs$1;

                                public final Object apply(String config) {
                                    return this.configs$1.remove(config);
                                }
                                {
                                    this.configs$1 = configs$1;
                                }
                            });
                            string = entityType;
                            String string2 = ConfigType$.MODULE$.Topic();
                            String string3 = string;
                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                            utils.changeTopicConfig(zkUtils, entityName, configs);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        String string4 = ConfigType$.MODULE$.Client();
                        String string5 = string;
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                        utils.changeClientIdConfig(zkUtils, entityName, configs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    String string6 = ConfigType$.MODULE$.User();
                    String string7 = string;
                    if (string6 != null ? !string6.equals(string7) : string7 != null) break block5;
                    utils.changeUserOrUserClientIdConfig(zkUtils, entityName, configs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                String string8 = ConfigType$.MODULE$.Broker();
                String string9 = string;
                if (string8 != null ? !string8.equals(string9) : string9 != null) break block6;
                utils.changeBrokerConfig(zkUtils, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.parseBroker(entityName)}))), configs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated config for entity: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity})));
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a known entityType. Should be one of ", ", ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_7, ConfigType$.MODULE$.Topic(), ConfigType$.MODULE$.Client(), ConfigType$.MODULE$.Broker()})));
    }

    public AdminUtilities alterConfig$default$3() {
        return AdminUtils$.MODULE$;
    }

    private int parseBroker(String broker) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(broker)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing broker ", ". The broker's Entity Name must be a single integer value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{broker})));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfig(ZkUtils zkUtils, ConfigCommand.ConfigCommandOptions opts) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var5_4 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var5_4) == false : var5_4 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        entities = configEntity.getAllEntities(zkUtils);
        entities.foreach((Function1)new Serializable(zkUtils, describeAllUsers){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;
            private final boolean describeAllUsers$1;

            public final void apply(ConfigCommand.ConfigEntity entity) {
                Properties configs = AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$1, entity.root().entityType(), entity.fullSanitizedName());
                if (!configs.isEmpty() || !this.describeAllUsers$1) {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Configs for %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, ((TraversableOnce)JavaConversions$.MODULE$.propertiesAsScalaMap(configs).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, String> kv) {
                            return new StringBuilder().append((Object)((String)kv._1())).append((Object)"=").append(kv._2()).toString();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
                }
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.describeAllUsers$1 = describeAllUsers$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        void var2_2;
        Properties props = new Properties();
        if (opts.options().has(opts.addConfig())) {
            String[][] configsToBeAdded = (String[][])Predef$.MODULE$.refArrayOps((Object[])((String)opts.options().valueOf(opts.addConfig())).split(",(?=[^\\]]*(?:\\[|$))")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String[] apply(String x$1) {
                    return x$1.split("\\s*=\\s*");
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
            Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded).forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String[] config) {
                    return config.length == 2;
                }
            }), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Invalid entity config: all configs to be added must be in the format \"key=val\".";
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded).foreach((Function1)new Serializable(props){
                public static final long serialVersionUID = 0L;
                private final Properties props$1;

                public final Object apply(String[] pair) {
                    return this.props$1.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim());
                }
                {
                    this.props$1 = props$1;
                }
            });
            if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: The configuration ", "=", " is specified. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker."})).s((Seq)Nil$.MODULE$)).toString());
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.deleteConfig())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$2) {
                    return x$2.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1)new Serializable(propsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Properties propsToBeDeleted$1;

                public final Object apply(String x$3) {
                    return this.propsToBeDeleted$1.setProperty(x$3, "");
                }
                {
                    this.propsToBeDeleted$1 = propsToBeDeleted$1;
                }
            });
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        ConfigCommand.ConfigEntity configEntity;
        List entityTypes;
        block3: {
            block2: {
                entityTypes = opts.options().valuesOf(opts.entityType());
                Object object = JavaConversions$.MODULE$.asScalaBuffer(entityTypes).head();
                String string = ConfigType$.MODULE$.User();
                if (!(object == null ? string != null : !object.equals(string))) break block2;
                Object object2 = JavaConversions$.MODULE$.asScalaBuffer(entityTypes).head();
                String string2 = ConfigType$.MODULE$.Client();
                if (object2 != null ? !object2.equals(string2) : string2 != null) break block3;
            }
            configEntity = this.parseQuotaEntity(opts);
            return configEntity;
        }
        None$ name = opts.options().has(opts.entityName()) ? new Some(opts.options().valueOf(opts.entityName())) : None$.MODULE$;
        configEntity = new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)JavaConversions$.MODULE$.asScalaBuffer(entityTypes).head(), (Option<String>)name), (Option<ConfigCommand.Entity>)None$.MODULE$);
        return configEntity;
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseQuotaEntity(ConfigCommand.ConfigCommandOptions opts) {
        types = opts.options().valuesOf(opts.entityType());
        namesIterator = opts.options().valuesOf(opts.entityName()).iterator();
        names = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(opts.options().specs()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OptionSpec<?> spec) {
                return spec.options().contains("entity-name") || spec.options().contains("entity-default");
            }
        })).map((Function1)new Serializable(namesIterator){
            public static final long serialVersionUID = 0L;
            private final java.util.Iterator namesIterator$1;

            public final String apply(OptionSpec<?> spec) {
                return spec.options().contains("entity-name") ? (String)this.namesIterator$1.next() : "";
            }
            {
                this.namesIterator$1 = namesIterator$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        if (opts.options().has((OptionSpec)opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = JavaConversions$.MODULE$.asScalaBuffer(types).apply(0);
        var6_5 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? (Buffer)JavaConversions$.MODULE$.asScalaBuffer(types).reverse() : JavaConversions$.MODULE$.asScalaBuffer(types).toBuffer();
        sortedNames = ((IterableLike)(reverse != false && names.length() == 2 ? names.reverse() : names)).iterator();
        entities = (Buffer)entityTypes.map((Function1)new Serializable(sortedNames){
            public static final long serialVersionUID = 0L;
            private final Iterator sortedNames$1;

            public final ConfigCommand.Entity apply(String t) {
                return new ConfigCommand.Entity(t, (Option<String>)(this.sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$sanitizeName$1(t, (String)this.sortedNames$1.next())) : None$.MODULE$));
            }
            {
                this.sortedNames$1 = sortedNames$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), (Option<ConfigCommand.Entity>)(entities.size() > 1 ? new Some(entities.apply(1)) : None$.MODULE$));
    }

    public final String kafka$admin$ConfigCommand$$sanitizeName$1(String entityType, String name) {
        block6: {
            String string;
            block3: {
                String string2;
                block5: {
                    String string3;
                    block4: {
                        block2: {
                            if (!name.isEmpty()) break block2;
                            string = ConfigEntityName$.MODULE$.Default();
                            break block3;
                        }
                        string3 = entityType;
                        String string4 = ConfigType$.MODULE$.User();
                        String string5 = string3;
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                        string2 = QuotaId$.MODULE$.sanitize(name);
                        break block5;
                    }
                    String string6 = ConfigType$.MODULE$.Client();
                    String string7 = string3;
                    if (string6 != null ? !string6.equals(string7) : string7 != null) break block6;
                    this.validateChars("Client-id", name);
                    string2 = name;
                }
                string = string2;
            }
            return string;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid entity type ").append((Object)entityType).toString());
    }

    private ConfigCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        Config$class.$init$(this);
    }
}

