/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.AbstractWindowBytesStoreTest;
import org.apache.kafka.streams.state.internals.ChangeLoggingWindowBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueSegments;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;
import org.apache.kafka.streams.state.internals.RocksDbIndexedTimeOrderedWindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RocksDBWindowStoreTest
extends AbstractWindowBytesStoreTest {
    private static final String STORE_NAME = "rocksDB window store";
    private static final String METRICS_SCOPE = "test-state-id";
    private final KeyValueSegments segments = new KeyValueSegments("rocksDB window store", "test-state-id", 120000L, 60000L);
    @Parameterized.Parameter
    public StoreType storeType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> getKeySchema() {
        return Arrays.asList({StoreType.RocksDBWindowStore}, {StoreType.RocksDBTimeOrderedWindowStoreWithIndex}, {StoreType.RocksDBTimeOrderedWindowStoreWithoutIndex});
    }

    @Override
    <K, V> WindowStore<K, V> buildWindowStore(long retentionPeriod, long windowSize, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde) {
        switch (this.storeType) {
            case RocksDBWindowStore: {
                return (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)STORE_NAME, (Duration)Duration.ofMillis(retentionPeriod), (Duration)Duration.ofMillis(windowSize), (boolean)retainDuplicates), keySerde, valueSerde).build();
            }
            case RocksDBTimeOrderedWindowStoreWithIndex: {
                long defaultSegmentInterval = Math.max(retentionPeriod / 2L, 60000L);
                return (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)new RocksDbIndexedTimeOrderedWindowBytesStoreSupplier(STORE_NAME, retentionPeriod, defaultSegmentInterval, windowSize, retainDuplicates, true), keySerde, valueSerde).build();
            }
            case RocksDBTimeOrderedWindowStoreWithoutIndex: {
                long defaultSegmentInterval = Math.max(retentionPeriod / 2L, 60000L);
                return (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)new RocksDbIndexedTimeOrderedWindowBytesStoreSupplier(STORE_NAME, retentionPeriod, defaultSegmentInterval, windowSize, retainDuplicates, false), keySerde, valueSerde).build();
            }
        }
        throw new IllegalStateException("Unknown StoreType: " + (Object)((Object)this.storeType));
    }

    @Test
    public void shouldOnlyIterateOpenSegments() {
        long currentTime = 0L;
        this.windowStore.put((Object)1, (Object)"one", currentTime);
        this.windowStore.put((Object)1, (Object)"two", currentTime += 60000L);
        this.windowStore.put((Object)1, (Object)"three", currentTime += 60000L);
        try (WindowStoreIterator iterator = this.windowStore.fetch((Object)1, 0L, currentTime);){
            this.windowStore.put((Object)1, (Object)"four", currentTime += 60000L);
            Assert.assertEquals((Object)new KeyValue((Object)60000L, (Object)"two"), (Object)iterator.next());
            Assert.assertEquals((Object)new KeyValue((Object)120000L, (Object)"three"), (Object)iterator.next());
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testRolling() {
        long startTime = 120000L;
        long increment = 30000L;
        this.windowStore.put((Object)0, (Object)"zero", 120000L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(2L)}), this.segmentDirs(this.baseDir));
        this.windowStore.put((Object)1, (Object)"one", 150000L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(2L)}), this.segmentDirs(this.baseDir));
        this.windowStore.put((Object)2, (Object)"two", 180000L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(2L), this.segments.segmentName(3L)}), this.segmentDirs(this.baseDir));
        this.windowStore.put((Object)4, (Object)"four", 240000L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(2L), this.segments.segmentName(3L), this.segments.segmentName(4L)}), this.segmentDirs(this.baseDir));
        this.windowStore.put((Object)5, (Object)"five", 270000L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(2L), this.segments.segmentName(3L), this.segments.segmentName(4L)}), this.segmentDirs(this.baseDir));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)0, Instant.ofEpochMilli(119997L), Instant.ofEpochMilli(120003L))));
        if (this.storeType == StoreType.RocksDBWindowStore) {
            Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)1, Instant.ofEpochMilli(149997L), Instant.ofEpochMilli(150003L))));
        } else {
            Assert.assertEquals(new HashSet<String>(Collections.singletonList("one")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)1, Instant.ofEpochMilli(149997L), Instant.ofEpochMilli(150003L))));
        }
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("two")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)2, Instant.ofEpochMilli(179997L), Instant.ofEpochMilli(180003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)3, Instant.ofEpochMilli(209997L), Instant.ofEpochMilli(210003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("four")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)4, Instant.ofEpochMilli(239997L), Instant.ofEpochMilli(240003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("five")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)5, Instant.ofEpochMilli(269997L), Instant.ofEpochMilli(270003L))));
        this.windowStore.put((Object)6, (Object)"six", 300000L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(3L), this.segments.segmentName(4L), this.segments.segmentName(5L)}), this.segmentDirs(this.baseDir));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)0, Instant.ofEpochMilli(119997L), Instant.ofEpochMilli(120003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)1, Instant.ofEpochMilli(149997L), Instant.ofEpochMilli(150003L))));
        if (this.storeType == StoreType.RocksDBWindowStore) {
            Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)2, Instant.ofEpochMilli(179997L), Instant.ofEpochMilli(180003L))));
        } else {
            Assert.assertEquals(new HashSet<String>(Collections.singletonList("two")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)2, Instant.ofEpochMilli(179997L), Instant.ofEpochMilli(180003L))));
        }
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)3, Instant.ofEpochMilli(209997L), Instant.ofEpochMilli(210003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("four")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)4, Instant.ofEpochMilli(239997L), Instant.ofEpochMilli(240003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("five")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)5, Instant.ofEpochMilli(269997L), Instant.ofEpochMilli(270003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("six")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)6, Instant.ofEpochMilli(299997L), Instant.ofEpochMilli(300003L))));
        this.windowStore.put((Object)7, (Object)"seven", 330000L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(3L), this.segments.segmentName(4L), this.segments.segmentName(5L)}), this.segmentDirs(this.baseDir));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)0, Instant.ofEpochMilli(119997L), Instant.ofEpochMilli(120003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)1, Instant.ofEpochMilli(149997L), Instant.ofEpochMilli(150003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)2, Instant.ofEpochMilli(179997L), Instant.ofEpochMilli(180003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)3, Instant.ofEpochMilli(209997L), Instant.ofEpochMilli(210003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("four")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)4, Instant.ofEpochMilli(239997L), Instant.ofEpochMilli(240003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("five")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)5, Instant.ofEpochMilli(269997L), Instant.ofEpochMilli(270003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("six")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)6, Instant.ofEpochMilli(299997L), Instant.ofEpochMilli(300003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("seven")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)7, Instant.ofEpochMilli(329997L), Instant.ofEpochMilli(330003L))));
        this.windowStore.put((Object)8, (Object)"eight", 360000L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(4L), this.segments.segmentName(5L), this.segments.segmentName(6L)}), this.segmentDirs(this.baseDir));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)0, Instant.ofEpochMilli(119997L), Instant.ofEpochMilli(120003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)1, Instant.ofEpochMilli(149997L), Instant.ofEpochMilli(150003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)2, Instant.ofEpochMilli(179997L), Instant.ofEpochMilli(180003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)3, Instant.ofEpochMilli(209997L), Instant.ofEpochMilli(210003L))));
        if (this.storeType == StoreType.RocksDBWindowStore) {
            Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)4, Instant.ofEpochMilli(239997L), Instant.ofEpochMilli(240003L))));
        } else {
            Assert.assertEquals(new HashSet<String>(Collections.singletonList("four")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)4, Instant.ofEpochMilli(239997L), Instant.ofEpochMilli(240003L))));
        }
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("five")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)5, Instant.ofEpochMilli(269997L), Instant.ofEpochMilli(270003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("six")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)6, Instant.ofEpochMilli(299997L), Instant.ofEpochMilli(300003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("seven")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)7, Instant.ofEpochMilli(329997L), Instant.ofEpochMilli(330003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("eight")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)8, Instant.ofEpochMilli(359997L), Instant.ofEpochMilli(360003L))));
        this.windowStore.flush();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(4L), this.segments.segmentName(5L), this.segments.segmentName(6L)}), this.segmentDirs(this.baseDir));
    }

    @Test
    public void testSegmentMaintenance() {
        this.windowStore.close();
        this.windowStore = this.buildWindowStore(120000L, 3L, true, Serdes.Integer(), Serdes.String());
        this.windowStore.init((StateStoreContext)this.context, (StateStore)this.windowStore);
        this.context.setTime(0L);
        this.windowStore.put((Object)0, (Object)"v", 0L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(0L)}), this.segmentDirs(this.baseDir));
        this.windowStore.put((Object)0, (Object)"v", 59999L);
        this.windowStore.put((Object)0, (Object)"v", 59999L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(0L)}), this.segmentDirs(this.baseDir));
        this.windowStore.put((Object)0, (Object)"v", 60000L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(0L), this.segments.segmentName(1L)}), this.segmentDirs(this.baseDir));
        WindowStoreIterator iter = this.windowStore.fetch((Object)0, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(240000L));
        int fetchedCount = 0;
        while (iter.hasNext()) {
            iter.next();
            ++fetchedCount;
        }
        Assert.assertEquals((long)4L, (long)fetchedCount);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(0L), this.segments.segmentName(1L)}), this.segmentDirs(this.baseDir));
        this.windowStore.put((Object)0, (Object)"v", 180000L);
        iter = this.windowStore.fetch((Object)0, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(240000L));
        fetchedCount = 0;
        while (iter.hasNext()) {
            iter.next();
            ++fetchedCount;
        }
        if (this.storeType == StoreType.RocksDBWindowStore) {
            Assert.assertEquals((long)1L, (long)fetchedCount);
        } else {
            Assert.assertEquals((long)2L, (long)fetchedCount);
        }
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(1L), this.segments.segmentName(3L)}), this.segmentDirs(this.baseDir));
        this.windowStore.put((Object)0, (Object)"v", 300000L);
        iter = this.windowStore.fetch((Object)0, Instant.ofEpochMilli(240000L), Instant.ofEpochMilli(600000L));
        fetchedCount = 0;
        while (iter.hasNext()) {
            iter.next();
            ++fetchedCount;
        }
        Assert.assertEquals((long)1L, (long)fetchedCount);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(3L), this.segments.segmentName(5L)}), this.segmentDirs(this.baseDir));
    }

    @Test
    public void testInitialLoading() {
        File storeDir = new File(this.baseDir, STORE_NAME);
        new File(storeDir, this.segments.segmentName(0L)).mkdir();
        new File(storeDir, this.segments.segmentName(1L)).mkdir();
        new File(storeDir, this.segments.segmentName(2L)).mkdir();
        new File(storeDir, this.segments.segmentName(3L)).mkdir();
        new File(storeDir, this.segments.segmentName(4L)).mkdir();
        new File(storeDir, this.segments.segmentName(5L)).mkdir();
        new File(storeDir, this.segments.segmentName(6L)).mkdir();
        this.windowStore.close();
        this.windowStore = this.buildWindowStore(120000L, 3L, false, Serdes.Integer(), Serdes.String());
        this.windowStore.init((StateStoreContext)this.context, (StateStore)this.windowStore);
        this.windowStore.put((Object)1, (Object)"v", 360000L);
        List<String> expected = Arrays.asList(this.segments.segmentName(4L), this.segments.segmentName(5L), this.segments.segmentName(6L));
        expected.sort(String::compareTo);
        List actual = Utils.toList(this.segmentDirs(this.baseDir).iterator());
        actual.sort(String::compareTo);
        Assert.assertEquals(expected, (Object)actual);
        try (WindowStoreIterator iter = this.windowStore.fetch((Object)0, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000000L));){
            while (iter.hasNext()) {
                iter.next();
            }
        }
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(4L), this.segments.segmentName(5L), this.segments.segmentName(6L)}), this.segmentDirs(this.baseDir));
    }

    @Test
    public void testRestore() throws Exception {
        long startTime = 120000L;
        long increment = 30000L;
        this.windowStore.put((Object)0, (Object)"zero", 120000L);
        this.windowStore.put((Object)1, (Object)"one", 150000L);
        this.windowStore.put((Object)2, (Object)"two", 180000L);
        this.windowStore.put((Object)3, (Object)"three", 210000L);
        this.windowStore.put((Object)4, (Object)"four", 240000L);
        this.windowStore.put((Object)5, (Object)"five", 270000L);
        this.windowStore.put((Object)6, (Object)"six", 300000L);
        this.windowStore.put((Object)7, (Object)"seven", 330000L);
        this.windowStore.put((Object)8, (Object)"eight", 360000L);
        this.windowStore.flush();
        this.windowStore.close();
        Utils.delete((File)this.baseDir);
        this.windowStore = this.buildWindowStore(120000L, 3L, false, Serdes.Integer(), Serdes.String());
        this.windowStore.init((StateStoreContext)this.context, (StateStore)this.windowStore);
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)0, Instant.ofEpochMilli(119997L), Instant.ofEpochMilli(120003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)1, Instant.ofEpochMilli(149997L), Instant.ofEpochMilli(150003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)2, Instant.ofEpochMilli(179997L), Instant.ofEpochMilli(180003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)3, Instant.ofEpochMilli(209997L), Instant.ofEpochMilli(210003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)4, Instant.ofEpochMilli(239997L), Instant.ofEpochMilli(240003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)5, Instant.ofEpochMilli(269997L), Instant.ofEpochMilli(270003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)6, Instant.ofEpochMilli(299997L), Instant.ofEpochMilli(300003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)7, Instant.ofEpochMilli(329997L), Instant.ofEpochMilli(330003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)8, Instant.ofEpochMilli(359997L), Instant.ofEpochMilli(360003L))));
        ArrayList<KeyValue<byte[], byte[]>> changeLog = new ArrayList<KeyValue<byte[], byte[]>>();
        for (ProducerRecord<Object, Object> record : this.recordCollector.collected()) {
            changeLog.add((KeyValue<byte[], byte[]>)new KeyValue((Object)((Bytes)record.key()).get(), (Object)((byte[])record.value())));
        }
        this.context.restore(STORE_NAME, changeLog);
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)0, Instant.ofEpochMilli(119997L), Instant.ofEpochMilli(120003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)1, Instant.ofEpochMilli(149997L), Instant.ofEpochMilli(150003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)2, Instant.ofEpochMilli(179997L), Instant.ofEpochMilli(180003L))));
        Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)3, Instant.ofEpochMilli(209997L), Instant.ofEpochMilli(210003L))));
        if (this.storeType == StoreType.RocksDBWindowStore) {
            Assert.assertEquals(new HashSet(Collections.emptyList()), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)4, Instant.ofEpochMilli(239997L), Instant.ofEpochMilli(240003L))));
        } else {
            Assert.assertEquals(new HashSet<String>(Collections.singletonList("four")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)4, Instant.ofEpochMilli(239997L), Instant.ofEpochMilli(240003L))));
        }
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("five")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)5, Instant.ofEpochMilli(269997L), Instant.ofEpochMilli(270003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("six")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)6, Instant.ofEpochMilli(299997L), Instant.ofEpochMilli(300003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("seven")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)7, Instant.ofEpochMilli(329997L), Instant.ofEpochMilli(330003L))));
        Assert.assertEquals(new HashSet<String>(Collections.singletonList("eight")), StreamsTestUtils.valuesToSet(this.windowStore.fetch((Object)8, Instant.ofEpochMilli(359997L), Instant.ofEpochMilli(360003L))));
        this.windowStore.flush();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(4L), this.segments.segmentName(5L), this.segments.segmentName(6L)}), this.segmentDirs(this.baseDir));
    }

    @Test
    public void shouldMatchPositionAfterPut() {
        MeteredWindowStore meteredSessionStore = (MeteredWindowStore)this.windowStore;
        ChangeLoggingWindowBytesStore changeLoggingSessionBytesStore = (ChangeLoggingWindowBytesStore)meteredSessionStore.wrapped();
        WrappedStateStore rocksDBWindowStore = (WrappedStateStore)changeLoggingSessionBytesStore.wrapped();
        this.context.setRecordContext(new ProcessorRecordContext(0L, 1L, 0, "", (Headers)new RecordHeaders()));
        this.windowStore.put((Object)0, (Object)"0", 60000L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 2L, 0, "", (Headers)new RecordHeaders()));
        this.windowStore.put((Object)1, (Object)"1", 60000L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 3L, 0, "", (Headers)new RecordHeaders()));
        this.windowStore.put((Object)2, (Object)"2", 60000L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 4L, 0, "", (Headers)new RecordHeaders()));
        this.windowStore.put((Object)3, (Object)"3", 60000L);
        Position expected = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)4L)}))}));
        Position actual = rocksDBWindowStore.getPosition();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private Set<String> segmentDirs(File baseDir) {
        File windowDir = new File(baseDir, this.windowStore.name());
        return new HashSet<Object>(Arrays.asList((Object[])Objects.requireNonNull(windowDir.list())));
    }

    static enum StoreType {
        RocksDBWindowStore,
        RocksDBTimeOrderedWindowStoreWithIndex,
        RocksDBTimeOrderedWindowStoreWithoutIndex;

    }
}

