/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueIteratorFacade;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class KeyValueIteratorFacadeTest {
    @Mock
    private KeyValueIterator<String, ValueAndTimestamp<String>> mockedKeyValueIterator;
    private KeyValueIteratorFacade<String, String> keyValueIteratorFacade;

    @Before
    public void setup() {
        this.keyValueIteratorFacade = new KeyValueIteratorFacade(this.mockedKeyValueIterator);
    }

    @Test
    public void shouldForwardHasNext() {
        Mockito.when((Object)this.mockedKeyValueIterator.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.keyValueIteratorFacade.hasNext());
        Assert.assertFalse((boolean)this.keyValueIteratorFacade.hasNext());
    }

    @Test
    public void shouldForwardPeekNextKey() {
        Mockito.when((Object)this.mockedKeyValueIterator.peekNextKey()).thenReturn((Object)"key");
        MatcherAssert.assertThat((Object)this.keyValueIteratorFacade.peekNextKey(), (Matcher)Matchers.is((Object)"key"));
    }

    @Test
    public void shouldReturnPlainKeyValuePairOnGet() {
        Mockito.when((Object)this.mockedKeyValueIterator.next()).thenReturn((Object)new KeyValue((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)42L)));
        MatcherAssert.assertThat((Object)this.keyValueIteratorFacade.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key", (Object)"value")));
    }

    @Test
    public void shouldCloseInnerIterator() {
        ((KeyValueIterator)Mockito.doNothing().when(this.mockedKeyValueIterator)).close();
        this.keyValueIteratorFacade.close();
    }
}

