/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.StateQueryResult;
import org.apache.kafka.streams.query.internals.SucceededQueryResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class StateQueryResultTest {
    StateQueryResult<String> stringStateQueryResult;
    final QueryResult<String> noResultsFound = new SucceededQueryResult(null);
    final QueryResult<String> validResult = new SucceededQueryResult((Object)"Foo");

    StateQueryResultTest() {
    }

    @BeforeEach
    public void setUp() {
        this.stringStateQueryResult = new StateQueryResult();
    }

    @Test
    @DisplayName(value="Zero query results shouldn't error")
    void getOnlyPartitionResultNoResultsTest() {
        this.stringStateQueryResult.addResult(0, this.noResultsFound);
        QueryResult result = this.stringStateQueryResult.getOnlyPartitionResult();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.nullValue());
    }

    @Test
    @DisplayName(value="Valid query results still works")
    void getOnlyPartitionResultWithSingleResultTest() {
        this.stringStateQueryResult.addResult(0, this.validResult);
        QueryResult result = this.stringStateQueryResult.getOnlyPartitionResult();
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)Matchers.is((Object)"Foo"));
    }

    @Test
    @DisplayName(value="More than one query result throws IllegalArgumentException ")
    void getOnlyPartitionResultMultipleResults() {
        this.stringStateQueryResult.addResult(0, this.validResult);
        this.stringStateQueryResult.addResult(1, this.validResult);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.stringStateQueryResult.getOnlyPartitionResult());
    }
}

