/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.StoreToProcessorContextAdapter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class StoreToProcessorContextAdapterTest {
    @Mock
    private StateStoreContext delegate;
    private ProcessorContext context;
    @Mock
    private Punctuator punctuator;

    @Before
    public void setUp() {
        this.context = StoreToProcessorContextAdapter.adapt((StateStoreContext)this.delegate);
    }

    @Test
    public void shouldThrowOnCurrentSystemTime() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.currentSystemTimeMs());
    }

    @Test
    public void shouldThrowOnCurrentStreamTime() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.currentStreamTimeMs());
    }

    @Test
    public void shouldThrowOnGetStateStore() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.getStateStore("store"));
    }

    @Test
    public void shouldThrowOnScheduleWithDuration() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.schedule(Duration.ZERO, PunctuationType.WALL_CLOCK_TIME, this.punctuator));
    }

    @Test
    public void shouldThrowOnForward() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.forward((Object)"key", (Object)"value"));
    }

    @Test
    public void shouldThrowOnForwardWithTo() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.forward((Object)"key", (Object)"value", To.all()));
    }

    @Test
    public void shouldThrowOnCommit() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.commit());
    }

    @Test
    public void shouldThrowOnTopic() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.topic());
    }

    @Test
    public void shouldThrowOnPartition() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.partition());
    }

    @Test
    public void shouldThrowOnOffset() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.offset());
    }

    @Test
    public void shouldThrowOnHeaders() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.headers());
    }

    @Test
    public void shouldThrowOnTimestamp() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.context.timestamp());
    }
}

