/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Arrays;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.Named;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NamedTest {
    @Test
    public void shouldThrowExceptionGivenNullName() {
        Assertions.assertThrows(NullPointerException.class, () -> Named.as(null));
    }

    @Test
    public void shouldThrowExceptionOnInvalidTopicNames() {
        String[] invalidNames;
        char[] longString = new char[250];
        Arrays.fill(longString, 'a');
        for (String name : invalidNames = new String[]{"", "foo bar", "..", "foo:bar", "foo=bar", ".", new String(longString)}) {
            try {
                Named.validate((String)name);
                Assertions.fail((String)("No exception was thrown for named with invalid name: " + name));
            }
            catch (TopologyException topologyException) {
                // empty catch block
            }
        }
    }
}

