/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RelaxedNullKeyRequirementJoinTest {
    private static final JoinWindows WINDOW = JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(60L), (Duration)Duration.ofSeconds(10L));
    private static final ValueJoiner<String, String, String> JOINER = (lv, rv) -> lv + "|" + rv;
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String OUT = "out";
    private TopologyTestDriver testDriver;
    private StreamsBuilder builder;
    private KStream<String, String> leftStream;
    private KStream<String, String> rightStream;
    private TestInputTopic<String, String> left;
    private TestInputTopic<String, String> right;
    private TestOutputTopic<String, String> out;

    @BeforeEach
    void beforeEach() {
        this.builder = new StreamsBuilder();
        this.leftStream = this.builder.stream(LEFT).repartition();
        this.rightStream = this.builder.stream(RIGHT).repartition();
    }

    @AfterEach
    void afterEach() {
        this.testDriver.close();
    }

    @Test
    void testRelaxedLeftStreamStreamJoin() {
        this.leftStream.leftJoin(this.rightStream, JOINER, WINDOW).to(OUT);
        this.initTopology();
        this.left.pipeInput(null, (Object)"leftValue", 1L);
        Assertions.assertEquals(Collections.singletonList(new KeyValue(null, (Object)"leftValue|null")), (Object)this.out.readKeyValuesToList());
    }

    @Test
    void testRelaxedLeftStreamTableJoin() {
        this.leftStream.leftJoin(this.rightStream.toTable(), JOINER).to(OUT);
        this.initTopology();
        this.left.pipeInput(null, (Object)"leftValue", 1L);
        Assertions.assertEquals(Collections.singletonList(new KeyValue(null, (Object)"leftValue|null")), (Object)this.out.readKeyValuesToList());
    }

    @Test
    void testRelaxedOuterStreamStreamJoin() {
        this.leftStream.outerJoin(this.rightStream, JOINER, WINDOW).to(OUT);
        this.initTopology();
        this.right.pipeInput(null, (Object)"rightValue", 1L);
        this.left.pipeInput(null, (Object)"leftValue");
        Assertions.assertEquals(Arrays.asList(new KeyValue(null, (Object)"null|rightValue"), new KeyValue(null, (Object)"leftValue|null")), (Object)this.out.readKeyValuesToList());
    }

    @Test
    void testRelaxedLeftStreamGlobalTableJoin() {
        GlobalKTable global = this.builder.globalTable("global");
        this.leftStream.leftJoin(global, (key, value) -> null, JOINER).to(OUT);
        this.initTopology();
        this.left.pipeInput(null, (Object)"leftValue", 1L);
        Assertions.assertEquals(Collections.singletonList(new KeyValue(null, (Object)"leftValue|null")), (Object)this.out.readKeyValuesToList());
    }

    @Test
    void testDropNullKeyRecordsForRepartitionNodesWithNoRelaxedJoinDownstream() {
        this.leftStream.repartition().to(OUT);
        this.initTopology();
        this.left.pipeInput(null, (Object)"leftValue", 1L);
        Assertions.assertEquals(Collections.emptyList(), (Object)this.out.readKeyValuesToList());
    }

    private void initTopology() {
        this.testDriver = new TopologyTestDriver(this.builder.build(), RelaxedNullKeyRequirementJoinTest.props());
        this.left = this.testDriver.createInputTopic(LEFT, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        this.right = this.testDriver.createInputTopic(RIGHT, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        this.out = this.testDriver.createOutputTopic(OUT, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
    }

    private static Properties props() {
        Properties props = new Properties();
        props.setProperty("default.key.serde", Serdes.String().getClass().getName());
        props.setProperty("default.value.serde", Serdes.String().getClass().getName());
        return props;
    }
}

