/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.TimeWindowedKStream;
import org.apache.kafka.streams.kstream.UnlimitedWindows;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.FullTimeWindowedSerde;
import org.apache.kafka.streams.kstream.internals.GroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KStreamWindowAggregate;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.RocksDbIndexedTimeOrderedWindowBytesStoreSupplier;

public class TimeWindowedKStreamImpl<K, V, W extends Window>
extends AbstractStream<K, V>
implements TimeWindowedKStream<K, V> {
    private final Windows<W> windows;
    private final GroupedStreamAggregateBuilder<K, V> aggregateBuilder;
    private EmitStrategy emitStrategy = EmitStrategy.onWindowUpdate();

    TimeWindowedKStreamImpl(Windows<W> windows, InternalStreamsBuilder builder, Set<String> subTopologySourceNodes, String name, Serde<K> keySerde, Serde<V> valueSerde, GroupedStreamAggregateBuilder<K, V> aggregateBuilder, GraphNode graphNode) {
        super(name, keySerde, valueSerde, subTopologySourceNodes, graphNode, builder);
        this.windows = Objects.requireNonNull(windows, "windows can't be null");
        this.aggregateBuilder = aggregateBuilder;
    }

    @Override
    public KTable<Windowed<K>, Long> count() {
        return this.count(NamedInternal.empty());
    }

    @Override
    public KTable<Windowed<K>, Long> count(Named named) {
        return this.doCount(named, Materialized.with(this.keySerde, Serdes.Long()));
    }

    @Override
    public KTable<Windowed<K>, Long> count(Materialized<K, Long, WindowStore<Bytes, byte[]>> materialized) {
        return this.count(NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<Windowed<K>, Long> count(Named named, Materialized<K, Long, WindowStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(materialized, "materialized can't be null");
        if (new MaterializedInternal<K, Long, WindowStore<Bytes, byte[]>>(materialized).storeName() == null) {
            this.builder.newStoreName("KSTREAM-AGGREGATE-");
        }
        return this.doCount(named, materialized);
    }

    private KTable<Windowed<K>, Long> doCount(Named named, Materialized<K, Long, WindowStore<Bytes, byte[]>> materialized) {
        MaterializedInternal<K, Long, WindowStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, Long, WindowStore<Bytes, byte[]>>(materialized, this.builder, "KSTREAM-AGGREGATE-");
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        if (materializedInternal.valueSerde() == null) {
            materializedInternal.withValueSerde((Serde<Long>)Serdes.Long());
        }
        String aggregateName = new NamedInternal(named).orElseGenerateWithPrefix(this.builder, "KSTREAM-AGGREGATE-");
        return this.aggregateBuilder.build(new NamedInternal(aggregateName), this.materialize(materializedInternal), new KStreamWindowAggregate(this.windows, materializedInternal.storeName(), this.emitStrategy, this.aggregateBuilder.countInitializer, this.aggregateBuilder.countAggregator), materializedInternal.queryableStoreName(), materializedInternal.keySerde() != null ? new FullTimeWindowedSerde<K>(materializedInternal.keySerde(), this.windows.size()) : null, materializedInternal.valueSerde());
    }

    @Override
    public <VR> KTable<Windowed<K>, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator) {
        return this.aggregate(initializer, aggregator, Materialized.with(this.keySerde, null));
    }

    @Override
    public <VR> KTable<Windowed<K>, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator, Named named) {
        return this.aggregate(initializer, aggregator, named, Materialized.with(this.keySerde, null));
    }

    @Override
    public <VR> KTable<Windowed<K>, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator, Materialized<K, VR, WindowStore<Bytes, byte[]>> materialized) {
        return this.aggregate(initializer, aggregator, NamedInternal.empty(), materialized);
    }

    @Override
    public <VR> KTable<Windowed<K>, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator, Named named, Materialized<K, VR, WindowStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, VR, WindowStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, WindowStore<Bytes, byte[]>>(materialized, this.builder, "KSTREAM-AGGREGATE-");
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        String aggregateName = new NamedInternal(named).orElseGenerateWithPrefix(this.builder, "KSTREAM-AGGREGATE-");
        return this.aggregateBuilder.build(new NamedInternal(aggregateName), this.materialize(materializedInternal), new KStreamWindowAggregate<K, V, VR, W>(this.windows, materializedInternal.storeName(), this.emitStrategy, initializer, aggregator), materializedInternal.queryableStoreName(), materializedInternal.keySerde() != null ? new FullTimeWindowedSerde<K>(materializedInternal.keySerde(), this.windows.size()) : null, materializedInternal.valueSerde());
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer) {
        return this.reduce(reducer, NamedInternal.empty());
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Named named) {
        return this.reduce(reducer, named, Materialized.with(this.keySerde, this.valueSerde));
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Materialized<K, V, WindowStore<Bytes, byte[]>> materialized) {
        return this.reduce(reducer, NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Named named, Materialized<K, V, WindowStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(reducer, "reducer can't be null");
        Objects.requireNonNull(named, "named can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, V, WindowStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, WindowStore<Bytes, byte[]>>(materialized, this.builder, "KSTREAM-REDUCE-");
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        if (materializedInternal.valueSerde() == null) {
            materializedInternal.withValueSerde(this.valueSerde);
        }
        String reduceName = new NamedInternal(named).orElseGenerateWithPrefix(this.builder, "KSTREAM-REDUCE-");
        return this.aggregateBuilder.build(new NamedInternal(reduceName), this.materialize(materializedInternal), new KStreamWindowAggregate(this.windows, materializedInternal.storeName(), this.emitStrategy, this.aggregateBuilder.reduceInitializer, this.aggregatorForReducer(reducer)), materializedInternal.queryableStoreName(), materializedInternal.keySerde() != null ? new FullTimeWindowedSerde<K>(materializedInternal.keySerde(), this.windows.size()) : null, materializedInternal.valueSerde());
    }

    @Override
    public TimeWindowedKStream<K, V> emitStrategy(EmitStrategy emitStrategy) {
        if (this.windows instanceof UnlimitedWindows && emitStrategy.type() == EmitStrategy.StrategyType.ON_WINDOW_CLOSE) {
            throw new IllegalArgumentException("ON_WINDOW_CLOSE emit strategy cannot be used for UnlimitedWindows");
        }
        this.emitStrategy = emitStrategy;
        return this;
    }

    private <VR> StoreBuilder<TimestampedWindowStore<K, VR>> materialize(MaterializedInternal<K, VR, WindowStore<Bytes, byte[]>> materialized) {
        WindowBytesStoreSupplier supplier = (WindowBytesStoreSupplier)materialized.storeSupplier();
        if (supplier == null) {
            long retentionPeriod;
            long l = retentionPeriod = materialized.retention() != null ? materialized.retention().toMillis() : this.windows.size() + this.windows.gracePeriodMs();
            if (this.windows.size() + this.windows.gracePeriodMs() > retentionPeriod) {
                throw new IllegalArgumentException("The retention period of the window store " + this.name + " must be no smaller than its window size plus the grace period. Got size=[" + this.windows.size() + "], grace=[" + this.windows.gracePeriodMs() + "], retention=[" + retentionPeriod + "]");
            }
            switch (materialized.storeType()) {
                case IN_MEMORY: {
                    supplier = Stores.inMemoryWindowStore(materialized.storeName(), Duration.ofMillis(retentionPeriod), Duration.ofMillis(this.windows.size()), false);
                    break;
                }
                case ROCKS_DB: {
                    supplier = this.emitStrategy.type() == EmitStrategy.StrategyType.ON_WINDOW_CLOSE ? RocksDbIndexedTimeOrderedWindowBytesStoreSupplier.create(materialized.storeName(), Duration.ofMillis(retentionPeriod), Duration.ofMillis(this.windows.size()), false, false) : Stores.persistentTimestampedWindowStore(materialized.storeName(), Duration.ofMillis(retentionPeriod), Duration.ofMillis(this.windows.size()), false);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown store type: " + (Object)((Object)materialized.storeType()));
                }
            }
        }
        StoreBuilder<TimestampedWindowStore<K, VR>> builder = Stores.timestampedWindowStoreBuilder(supplier, materialized.keySerde(), materialized.valueSerde());
        if (materialized.loggingEnabled()) {
            builder.withLoggingEnabled(materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (materialized.cachingEnabled()) {
            builder.withCachingEnabled();
        }
        return builder;
    }

    private Aggregator<K, V, V> aggregatorForReducer(Reducer<V> reducer) {
        return (aggKey, value, aggregate) -> aggregate == null ? value : reducer.apply(aggregate, value);
    }
}

