/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecordingTrigger;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RocksDBMetricsRecordingTriggerTest {
    private static final String STORE_NAME1 = "store-name1";
    private static final String STORE_NAME2 = "store-name2";
    private static final TaskId TASK_ID1 = new TaskId(1, 2);
    private static final TaskId TASK_ID2 = new TaskId(2, 4);
    private final RocksDBMetricsRecorder recorder1 = (RocksDBMetricsRecorder)EasyMock.niceMock(RocksDBMetricsRecorder.class);
    private final RocksDBMetricsRecorder recorder2 = (RocksDBMetricsRecorder)EasyMock.niceMock(RocksDBMetricsRecorder.class);
    private final Time time = new MockTime();
    private final RocksDBMetricsRecordingTrigger recordingTrigger = new RocksDBMetricsRecordingTrigger(this.time);

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.recorder1.storeName()).andStubReturn((Object)STORE_NAME1);
        EasyMock.expect((Object)this.recorder1.taskId()).andStubReturn((Object)TASK_ID1);
        EasyMock.replay((Object[])new Object[]{this.recorder1});
        EasyMock.expect((Object)this.recorder2.storeName()).andStubReturn((Object)STORE_NAME2);
        EasyMock.expect((Object)this.recorder2.taskId()).andStubReturn((Object)TASK_ID2);
        EasyMock.replay((Object[])new Object[]{this.recorder2});
    }

    @Test
    public void shouldTriggerAddedMetricsRecorders() {
        this.recordingTrigger.addMetricsRecorder(this.recorder1);
        this.recordingTrigger.addMetricsRecorder(this.recorder2);
        EasyMock.resetToDefault((Object[])new Object[]{this.recorder1});
        this.recorder1.record(this.time.milliseconds());
        EasyMock.replay((Object[])new Object[]{this.recorder1});
        EasyMock.resetToDefault((Object[])new Object[]{this.recorder2});
        this.recorder2.record(this.time.milliseconds());
        EasyMock.replay((Object[])new Object[]{this.recorder2});
        this.recordingTrigger.run();
        EasyMock.verify((Object[])new Object[]{this.recorder1});
        EasyMock.verify((Object[])new Object[]{this.recorder2});
    }

    @Test
    public void shouldThrowIfRecorderToAddHasBeenAlreadyAdded() {
        this.recordingTrigger.addMetricsRecorder(this.recorder1);
        Assert.assertThrows(IllegalStateException.class, () -> this.recordingTrigger.addMetricsRecorder(this.recorder1));
    }

    @Test
    public void shouldThrowIfRecorderToRemoveCouldNotBeFound() {
        this.recordingTrigger.addMetricsRecorder(this.recorder1);
        Assert.assertThrows(IllegalStateException.class, () -> this.recordingTrigger.removeMetricsRecorder(this.recorder2));
    }
}

