/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.CachingSessionStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingSessionBytesStore;
import org.apache.kafka.streams.state.internals.MeteredSessionStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBSessionStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.SessionStoreBuilder;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class SessionStoreBuilderTest {
    @Mock(type=MockType.NICE)
    private SessionBytesStoreSupplier supplier;
    @Mock(type=MockType.NICE)
    private SessionStore<Bytes, byte[]> inner;
    private SessionStoreBuilder<String, String> builder;

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.supplier.get()).andReturn(this.inner);
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.expect((Object)this.supplier.metricsScope()).andReturn((Object)"metricScope");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        this.builder = new SessionStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        SessionStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        SessionStore store = this.builder.build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingSessionBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        SessionStore store = (SessionStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingStoreWhenEnabled() {
        SessionStore store = (SessionStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingSessionStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        SessionStore store = (SessionStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingSessionBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrapped(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled() {
        SessionStore store = (SessionStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingSessionStore.class));
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingSessionBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrapped(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldThrowNullPointerIfInnerIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new SessionStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"storeSupplier cannot be null"));
    }

    @Test
    public void shouldThrowNullPointerIfKeySerdeIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new SessionStoreBuilder(this.supplier, null, Serdes.String(), (Time)new MockTime()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"name cannot be null"));
    }

    @Test
    public void shouldThrowNullPointerIfValueSerdeIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new SessionStoreBuilder(this.supplier, Serdes.String(), null, (Time)new MockTime()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"name cannot be null"));
    }

    @Test
    public void shouldThrowNullPointerIfTimeIsNull() {
        EasyMock.reset((Object[])new Object[]{this.supplier});
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new SessionStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"time cannot be null"));
    }

    @Test
    public void shouldThrowNullPointerIfMetricsScopeIsNull() {
        EasyMock.reset((Object[])new Object[]{this.supplier});
        EasyMock.expect((Object)this.supplier.get()).andReturn((Object)new RocksDBSessionStore((SegmentedBytesStore)new RocksDBSegmentedBytesStore("name", null, 10L, 5L, (SegmentedBytesStore.KeySchema)new SessionKeySchema())));
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new SessionStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"storeSupplier's metricsScope can't be null"));
    }
}

