/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.ReadOnlySessionStore;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GlobalStateStoreProviderTest {
    private final Map<String, StateStore> stores = new HashMap<String, StateStore>();

    @Before
    public void before() {
        this.stores.put("kv-store", Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"kv-store"), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("ts-kv-store", Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"ts-kv-store"), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("w-store", Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)"w-store", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(2L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("ts-w-store", Stores.timestampedWindowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)"ts-w-store", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(2L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("s-store", Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.inMemorySessionStore((String)"s-store", (Duration)Duration.ofMillis(10L)), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        ProcessorContextImpl mockContext = (ProcessorContextImpl)EasyMock.niceMock(ProcessorContextImpl.class);
        EasyMock.expect((Object)mockContext.applicationId()).andStubReturn((Object)"appId");
        EasyMock.expect((Object)mockContext.metrics()).andStubReturn((Object)new StreamsMetricsImpl(new Metrics(), "threadName", "latest", (Time)new MockTime()));
        EasyMock.expect((Object)mockContext.taskId()).andStubReturn((Object)new TaskId(0, 0));
        EasyMock.expect((Object)mockContext.recordCollector()).andStubReturn(null);
        GlobalStateStoreProviderTest.expectSerdes(mockContext);
        EasyMock.replay((Object[])new Object[]{mockContext});
        for (StateStore store : this.stores.values()) {
            store.init((StateStoreContext)mockContext, null);
        }
    }

    private static void expectSerdes(ProcessorContextImpl context) {
        EasyMock.expect((Object)context.keySerde()).andStubReturn((Object)Serdes.String());
        EasyMock.expect((Object)context.valueSerde()).andStubReturn((Object)Serdes.Long());
    }

    @Test
    public void shouldReturnSingleItemListIfStoreExists() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.singletonMap("global", new NoOpReadOnlyStore()));
        List stores = provider.stores("global", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)stores.size(), (long)1L);
    }

    @Test
    public void shouldReturnEmptyItemListIfStoreDoesntExist() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.emptyMap());
        List stores = provider.stores("global", QueryableStoreTypes.keyValueStore());
        Assert.assertTrue((boolean)stores.isEmpty());
    }

    @Test
    public void shouldThrowExceptionIfStoreIsntOpen() {
        NoOpReadOnlyStore store = new NoOpReadOnlyStore();
        store.close();
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.singletonMap("global", store));
        Assert.assertThrows(InvalidStateStoreException.class, () -> provider.stores("global", QueryableStoreTypes.keyValueStore()));
    }

    @Test
    public void shouldReturnKeyValueStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("kv-store", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)1L, (long)stores.size());
        for (ReadOnlyKeyValueStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class)));
        }
    }

    @Test
    public void shouldReturnTimestampedKeyValueStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("ts-kv-store", QueryableStoreTypes.timestampedKeyValueStore());
        Assert.assertEquals((long)1L, (long)stores.size());
        for (ReadOnlyKeyValueStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class));
        }
    }

    @Test
    public void shouldNotReturnKeyValueStoreAsTimestampedStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("kv-store", QueryableStoreTypes.timestampedKeyValueStore());
        Assert.assertEquals((long)0L, (long)stores.size());
    }

    @Test
    public void shouldReturnTimestampedKeyValueStoreAsKeyValueStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("ts-kv-store", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)1L, (long)stores.size());
        for (ReadOnlyKeyValueStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class)));
        }
    }

    @Test
    public void shouldReturnWindowStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("w-store", QueryableStoreTypes.windowStore());
        Assert.assertEquals((long)1L, (long)stores.size());
        for (ReadOnlyWindowStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyWindowStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedWindowStore.class)));
        }
    }

    @Test
    public void shouldNotReturnWindowStoreAsTimestampedStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("w-store", QueryableStoreTypes.timestampedWindowStore());
        Assert.assertEquals((long)0L, (long)stores.size());
    }

    @Test
    public void shouldReturnTimestampedWindowStoreAsWindowStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("ts-w-store", QueryableStoreTypes.windowStore());
        Assert.assertEquals((long)1L, (long)stores.size());
        for (ReadOnlyWindowStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyWindowStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedWindowStore.class)));
        }
    }

    @Test
    public void shouldReturnSessionStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("s-store", QueryableStoreTypes.sessionStore());
        Assert.assertEquals((long)1L, (long)stores.size());
        for (ReadOnlySessionStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlySessionStore.class));
        }
    }
}

