/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.TableSourceNode;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={InternalTopologyBuilder.class})
public class TableSourceNodeTest {
    private static final String STORE_NAME = "store-name";
    private static final String TOPIC = "input-topic";
    private final InternalTopologyBuilder topologyBuilder = (InternalTopologyBuilder)PowerMock.createNiceMock(InternalTopologyBuilder.class);

    @Test
    public void shouldConnectStateStoreToInputTopicIfInputTopicIsUsedAsChangelog() {
        boolean shouldReuseSourceTopicForChangelog = true;
        this.topologyBuilder.connectSourceStoreAndTopic(STORE_NAME, TOPIC);
        EasyMock.replay((Object[])new Object[]{this.topologyBuilder});
        this.buildTableSourceNode(true);
        EasyMock.verify((Object[])new Object[]{this.topologyBuilder});
    }

    @Test
    public void shouldConnectStateStoreToChangelogTopic() {
        boolean shouldReuseSourceTopicForChangelog = false;
        EasyMock.replay((Object[])new Object[]{this.topologyBuilder});
        this.buildTableSourceNode(false);
        EasyMock.verify((Object[])new Object[]{this.topologyBuilder});
    }

    private void buildTableSourceNode(boolean shouldReuseSourceTopicForChangelog) {
        TableSourceNode.TableSourceNodeBuilder tableSourceNodeBuilder = TableSourceNode.tableSourceNodeBuilder();
        TableSourceNode tableSourceNode = tableSourceNodeBuilder.withTopic(TOPIC).withMaterializedInternal(new MaterializedInternal(Materialized.as((String)STORE_NAME))).withConsumedInternal(new ConsumedInternal(Consumed.as((String)"node-name"))).withProcessorParameters(new ProcessorParameters((ProcessorSupplier)new KTableSource(STORE_NAME, STORE_NAME), null)).build();
        tableSourceNode.reuseSourceTopicForChangeLog(shouldReuseSourceTopicForChangelog);
        tableSourceNode.writeToTopology(this.topologyBuilder);
    }
}

