/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.streams.kstream.SessionWindowedDeserializer;
import org.junit.Assert;
import org.junit.Test;

public class SessionWindowedDeserializerTest {
    private final SessionWindowedDeserializer<?> sessionWindowedDeserializer = new SessionWindowedDeserializer((Deserializer)new StringDeserializer());
    private final Map<String, String> props = new HashMap<String, String>();

    @Test
    public void testSessionWindowedDeserializerConstructor() {
        this.sessionWindowedDeserializer.configure(this.props, true);
        Deserializer inner = this.sessionWindowedDeserializer.innerDeserializer();
        Assert.assertNotNull((String)"Inner deserializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner deserializer type should be StringDeserializer", (boolean)(inner instanceof StringDeserializer));
    }

    @Test
    public void shouldSetWindowedInnerClassDeserialiserThroughConfig() {
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        SessionWindowedDeserializer deserializer = new SessionWindowedDeserializer();
        deserializer.configure(this.props, false);
        Assert.assertTrue((boolean)(deserializer.innerDeserializer() instanceof ByteArrayDeserializer));
    }

    @Test
    public void shouldThrowErrorIfWindowInnerClassDeserialiserIsNotSet() {
        SessionWindowedDeserializer deserializer = new SessionWindowedDeserializer();
        Assert.assertThrows(IllegalArgumentException.class, () -> deserializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowErrorIfDeserialisersConflictInConstructorAndConfig() {
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.sessionWindowedDeserializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowConfigExceptionWhenInvalidWindowInnerClassDeserialiserSupplied() {
        this.props.put("windowed.inner.class.serde", "some.non.existent.class");
        Assert.assertThrows(ConfigException.class, () -> this.sessionWindowedDeserializer.configure(this.props, false));
    }
}

