/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.MemoryLRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryNavigableLRUCache
extends MemoryLRUCache {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryNavigableLRUCache.class);

    public MemoryNavigableLRUCache(String name, int maxCacheSize) {
        super(name, maxCacheSize);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        if (from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        TreeMap<Bytes, byte[]> treeMap = this.toTreeMap();
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name(), new CacheIterator(treeMap.navigableKeySet().subSet(from, true, to, true).iterator(), treeMap));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
        if (from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        TreeMap<Bytes, byte[]> treeMap = this.toTreeMap();
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name(), new CacheIterator(treeMap.subMap(from, true, to, true).descendingKeySet().iterator(), treeMap));
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
        Bytes from = Bytes.wrap((byte[])prefixKeySerializer.serialize(null, prefix));
        Bytes to = Bytes.increment((Bytes)from);
        TreeMap<Bytes, byte[]> treeMap = this.toTreeMap();
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name(), new CacheIterator(treeMap.subMap(from, true, to, false).keySet().iterator(), treeMap));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        TreeMap<Bytes, byte[]> treeMap = this.toTreeMap();
        return new CacheIterator(treeMap.navigableKeySet().iterator(), treeMap);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseAll() {
        TreeMap<Bytes, byte[]> treeMap = this.toTreeMap();
        return new CacheIterator(treeMap.descendingKeySet().iterator(), treeMap);
    }

    private synchronized TreeMap<Bytes, byte[]> toTreeMap() {
        return new TreeMap<Bytes, byte[]>(this.map);
    }

    private static class CacheIterator
    implements KeyValueIterator<Bytes, byte[]> {
        private final Iterator<Bytes> keys;
        private final Map<Bytes, byte[]> entries;
        private Bytes lastKey;

        private CacheIterator(Iterator<Bytes> keys, Map<Bytes, byte[]> entries) {
            this.keys = keys;
            this.entries = entries;
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public KeyValue<Bytes, byte[]> next() {
            this.lastKey = this.keys.next();
            return new KeyValue<Bytes, byte[]>(this.lastKey, this.entries.get(this.lastKey));
        }

        @Override
        public void close() {
        }

        @Override
        public Bytes peekNextKey() {
            throw new UnsupportedOperationException("peekNextKey not supported");
        }
    }
}

