/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;

public final class SlidingWindows {
    private final long timeDifferenceMs;
    private final long graceMs;

    private SlidingWindows(long timeDifferenceMs, long graceMs) {
        this.timeDifferenceMs = timeDifferenceMs;
        this.graceMs = graceMs;
    }

    public static SlidingWindows withTimeDifferenceAndGrace(Duration timeDifference, Duration grace) throws IllegalArgumentException {
        String msgPrefixSize = ApiUtils.prepareMillisCheckFailMsgPrefix(timeDifference, "timeDifference");
        long timeDifferenceMs = ApiUtils.validateMillisecondDuration(timeDifference, msgPrefixSize);
        if (timeDifferenceMs < 0L) {
            throw new IllegalArgumentException("Window time difference must not be negative.");
        }
        String msgPrefixGrace = ApiUtils.prepareMillisCheckFailMsgPrefix(grace, "grace");
        long graceMs = ApiUtils.validateMillisecondDuration(grace, msgPrefixGrace);
        if (graceMs < 0L) {
            throw new IllegalArgumentException("Window grace period must not be negative.");
        }
        return new SlidingWindows(timeDifferenceMs, graceMs);
    }

    public long timeDifferenceMs() {
        return this.timeDifferenceMs;
    }

    public long gracePeriodMs() {
        return this.graceMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlidingWindows that = (SlidingWindows)o;
        return this.timeDifferenceMs == that.timeDifferenceMs && this.graceMs == that.graceMs;
    }

    public int hashCode() {
        return Objects.hash(this.timeDifferenceMs, this.graceMs);
    }

    public String toString() {
        return "SlidingWindows{, sizeMs=" + this.timeDifferenceMs + ", graceMs=" + this.graceMs + '}';
    }
}

