/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.generated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class SubscriptionInfoData
implements ApiMessage {
    int version;
    int latestSupportedVersion;
    Uuid processId;
    List<TaskId> prevTasks;
    List<TaskId> standbyTasks;
    byte[] userEndPoint;
    List<TaskOffsetSum> taskOffsetSums;
    byte uniqueField;
    int errorCode;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("prev_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("standby_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), "")});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("prev_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("standby_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("user_end_point", (Type)Type.BYTES, "")});
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 1;
    public static final short HIGHEST_SUPPORTED_VERSION = 9;

    public SubscriptionInfoData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SubscriptionInfoData() {
        this.version = 0;
        this.latestSupportedVersion = -1;
        this.processId = Uuid.ZERO_UUID;
        this.prevTasks = new ArrayList<TaskId>(0);
        this.standbyTasks = new ArrayList<TaskId>(0);
        this.userEndPoint = Bytes.EMPTY;
        this.taskOffsetSums = new ArrayList<TaskOffsetSum>(0);
        this.uniqueField = 0;
        this.errorCode = 0;
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 1;
    }

    public short highestSupportedVersion() {
        return 9;
    }

    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<TaskId> newCollection;
        int arrayLength;
        this.version = _readable.readInt();
        this.latestSupportedVersion = _version >= 3 ? _readable.readInt() : -1;
        this.processId = _readable.readUuid();
        if (_version <= 6) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field prevTasks was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<TaskId>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TaskId(_readable, _version));
            }
            this.prevTasks = newCollection;
        } else {
            this.prevTasks = new ArrayList<TaskId>(0);
        }
        if (_version <= 6) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field standbyTasks was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TaskId(_readable, _version));
            }
            this.standbyTasks = newCollection;
        } else {
            this.standbyTasks = new ArrayList<TaskId>(0);
        }
        if (_version >= 2) {
            int length = _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field userEndPoint was serialized as null");
            }
            byte[] newBytes = _readable.readArray(length);
            this.userEndPoint = newBytes;
        } else {
            this.userEndPoint = Bytes.EMPTY;
        }
        if (_version >= 7) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field taskOffsetSums was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((TaskId)((Object)new TaskOffsetSum(_readable, _version)));
            }
            this.taskOffsetSums = newCollection;
        } else {
            this.taskOffsetSums = new ArrayList<TaskOffsetSum>(0);
        }
        this.uniqueField = _version >= 8 ? _readable.readByte() : (byte)0;
        this.errorCode = _version >= 9 ? _readable.readInt() : 0;
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.version);
        if (_version >= 3) {
            _writable.writeInt(this.latestSupportedVersion);
        } else if (this.latestSupportedVersion != -1) {
            throw new UnsupportedVersionException("Attempted to write a non-default latestSupportedVersion at version " + _version);
        }
        _writable.writeUuid(this.processId);
        if (_version <= 6) {
            _writable.writeInt(this.prevTasks.size());
            for (TaskId prevTasksElement : this.prevTasks) {
                prevTasksElement.write(_writable, _cache, _version);
            }
        } else if (!this.prevTasks.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default prevTasks at version " + _version);
        }
        if (_version <= 6) {
            _writable.writeInt(this.standbyTasks.size());
            for (TaskId standbyTasksElement : this.standbyTasks) {
                standbyTasksElement.write(_writable, _cache, _version);
            }
        } else if (!this.standbyTasks.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default standbyTasks at version " + _version);
        }
        if (_version >= 2) {
            _writable.writeInt(this.userEndPoint.length);
            _writable.writeByteArray(this.userEndPoint);
        } else if (this.userEndPoint.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default userEndPoint at version " + _version);
        }
        if (_version >= 7) {
            _writable.writeInt(this.taskOffsetSums.size());
            for (TaskOffsetSum taskOffsetSumsElement : this.taskOffsetSums) {
                taskOffsetSumsElement.write(_writable, _cache, _version);
            }
        } else if (!this.taskOffsetSums.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default taskOffsetSums at version " + _version);
        }
        if (_version >= 8) {
            _writable.writeByte(this.uniqueField);
        } else if (this.uniqueField != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default uniqueField at version " + _version);
        }
        if (_version >= 9) {
            _writable.writeInt(this.errorCode);
        } else if (this.errorCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default errorCode at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        if (_version >= 3) {
            _size.addBytes(4);
        }
        _size.addBytes(16);
        if (_version <= 6) {
            _size.addBytes(4);
            for (TaskId prevTasksElement : this.prevTasks) {
                prevTasksElement.addSize(_size, _cache, _version);
            }
        }
        if (_version <= 6) {
            _size.addBytes(4);
            for (TaskId standbyTasksElement : this.standbyTasks) {
                standbyTasksElement.addSize(_size, _cache, _version);
            }
        }
        if (_version >= 2) {
            _size.addBytes(this.userEndPoint.length);
            _size.addBytes(4);
        }
        if (_version >= 7) {
            _size.addBytes(4);
            for (TaskOffsetSum taskOffsetSumsElement : this.taskOffsetSums) {
                taskOffsetSumsElement.addSize(_size, _cache, _version);
            }
        }
        if (_version >= 8) {
            _size.addBytes(1);
        }
        if (_version >= 9) {
            _size.addBytes(4);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SubscriptionInfoData)) {
            return false;
        }
        SubscriptionInfoData other = (SubscriptionInfoData)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.latestSupportedVersion != other.latestSupportedVersion) {
            return false;
        }
        if (!this.processId.equals((Object)other.processId)) {
            return false;
        }
        if (this.prevTasks == null ? other.prevTasks != null : !this.prevTasks.equals(other.prevTasks)) {
            return false;
        }
        if (this.standbyTasks == null ? other.standbyTasks != null : !this.standbyTasks.equals(other.standbyTasks)) {
            return false;
        }
        if (!Arrays.equals(this.userEndPoint, other.userEndPoint)) {
            return false;
        }
        if (this.taskOffsetSums == null ? other.taskOffsetSums != null : !this.taskOffsetSums.equals(other.taskOffsetSums)) {
            return false;
        }
        if (this.uniqueField != other.uniqueField) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.version;
        hashCode = 31 * hashCode + this.latestSupportedVersion;
        hashCode = 31 * hashCode + this.processId.hashCode();
        hashCode = 31 * hashCode + (this.prevTasks == null ? 0 : this.prevTasks.hashCode());
        hashCode = 31 * hashCode + (this.standbyTasks == null ? 0 : this.standbyTasks.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.userEndPoint);
        hashCode = 31 * hashCode + (this.taskOffsetSums == null ? 0 : this.taskOffsetSums.hashCode());
        hashCode = 31 * hashCode + this.uniqueField;
        hashCode = 31 * hashCode + this.errorCode;
        return hashCode;
    }

    public SubscriptionInfoData duplicate() {
        SubscriptionInfoData _duplicate = new SubscriptionInfoData();
        _duplicate.version = this.version;
        _duplicate.latestSupportedVersion = this.latestSupportedVersion;
        _duplicate.processId = this.processId;
        ArrayList<TaskId> newPrevTasks = new ArrayList<TaskId>(this.prevTasks.size());
        for (TaskId taskId : this.prevTasks) {
            newPrevTasks.add(taskId.duplicate());
        }
        _duplicate.prevTasks = newPrevTasks;
        ArrayList<TaskId> newStandbyTasks = new ArrayList<TaskId>(this.standbyTasks.size());
        for (TaskId _element : this.standbyTasks) {
            newStandbyTasks.add(_element.duplicate());
        }
        _duplicate.standbyTasks = newStandbyTasks;
        _duplicate.userEndPoint = MessageUtil.duplicate((byte[])this.userEndPoint);
        ArrayList<TaskOffsetSum> arrayList = new ArrayList<TaskOffsetSum>(this.taskOffsetSums.size());
        for (TaskOffsetSum _element : this.taskOffsetSums) {
            arrayList.add(_element.duplicate());
        }
        _duplicate.taskOffsetSums = arrayList;
        _duplicate.uniqueField = this.uniqueField;
        _duplicate.errorCode = this.errorCode;
        return _duplicate;
    }

    public String toString() {
        return "SubscriptionInfoData(version=" + this.version + ", latestSupportedVersion=" + this.latestSupportedVersion + ", processId=" + this.processId.toString() + ", prevTasks=" + MessageUtil.deepToString(this.prevTasks.iterator()) + ", standbyTasks=" + MessageUtil.deepToString(this.standbyTasks.iterator()) + ", userEndPoint=" + Arrays.toString(this.userEndPoint) + ", taskOffsetSums=" + MessageUtil.deepToString(this.taskOffsetSums.iterator()) + ", uniqueField=" + this.uniqueField + ", errorCode=" + this.errorCode + ")";
    }

    public int version() {
        return this.version;
    }

    public int latestSupportedVersion() {
        return this.latestSupportedVersion;
    }

    public Uuid processId() {
        return this.processId;
    }

    public List<TaskId> prevTasks() {
        return this.prevTasks;
    }

    public List<TaskId> standbyTasks() {
        return this.standbyTasks;
    }

    public byte[] userEndPoint() {
        return this.userEndPoint;
    }

    public List<TaskOffsetSum> taskOffsetSums() {
        return this.taskOffsetSums;
    }

    public byte uniqueField() {
        return this.uniqueField;
    }

    public int errorCode() {
        return this.errorCode;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SubscriptionInfoData setVersion(int v) {
        this.version = v;
        return this;
    }

    public SubscriptionInfoData setLatestSupportedVersion(int v) {
        this.latestSupportedVersion = v;
        return this;
    }

    public SubscriptionInfoData setProcessId(Uuid v) {
        this.processId = v;
        return this;
    }

    public SubscriptionInfoData setPrevTasks(List<TaskId> v) {
        this.prevTasks = v;
        return this;
    }

    public SubscriptionInfoData setStandbyTasks(List<TaskId> v) {
        this.standbyTasks = v;
        return this;
    }

    public SubscriptionInfoData setUserEndPoint(byte[] v) {
        this.userEndPoint = v;
        return this;
    }

    public SubscriptionInfoData setTaskOffsetSums(List<TaskOffsetSum> v) {
        this.taskOffsetSums = v;
        return this;
    }

    public SubscriptionInfoData setUniqueField(byte v) {
        this.uniqueField = v;
        return this;
    }

    public SubscriptionInfoData setErrorCode(int v) {
        this.errorCode = v;
        return this;
    }

    static {
        SCHEMA_6 = SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("latest_supported_version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("prev_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("standby_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("user_end_point", (Type)Type.BYTES, "")})));
        SCHEMA_7 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("latest_supported_version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("user_end_point", (Type)Type.BYTES, ""), new Field("task_offset_sums", (Type)new ArrayOf((Type)TaskOffsetSum.SCHEMA_7), "")});
        SCHEMA_8 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("latest_supported_version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("user_end_point", (Type)Type.BYTES, ""), new Field("task_offset_sums", (Type)new ArrayOf((Type)TaskOffsetSum.SCHEMA_7), ""), new Field("unique_field", (Type)Type.INT8, "")});
        SCHEMA_9 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("latest_supported_version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("user_end_point", (Type)Type.BYTES, ""), new Field("task_offset_sums", (Type)new ArrayOf((Type)TaskOffsetSum.SCHEMA_7), ""), new Field("unique_field", (Type)Type.INT8, ""), new Field("error_code", (Type)Type.INT32, "")});
        SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
    }

    public static class TaskOffsetSum
    implements Message {
        int topicGroupId;
        List<PartitionToOffsetSum> partitionToOffsetSum;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 7;
        public static final short HIGHEST_SUPPORTED_VERSION = 9;

        public TaskOffsetSum(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TaskOffsetSum() {
            this.topicGroupId = 0;
            this.partitionToOffsetSum = new ArrayList<PartitionToOffsetSum>(0);
        }

        public short lowestSupportedVersion() {
            return 7;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.topicGroupId = _readable.readInt();
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionToOffsetSum was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionToOffsetSum> newCollection = new ArrayList<PartitionToOffsetSum>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionToOffsetSum(_readable, _version));
            }
            this.partitionToOffsetSum = newCollection;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.topicGroupId);
            _writable.writeInt(this.partitionToOffsetSum.size());
            for (PartitionToOffsetSum partitionToOffsetSumElement : this.partitionToOffsetSum) {
                partitionToOffsetSumElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(4);
            _size.addBytes(4);
            for (PartitionToOffsetSum partitionToOffsetSumElement : this.partitionToOffsetSum) {
                partitionToOffsetSumElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskOffsetSum)) {
                return false;
            }
            TaskOffsetSum other = (TaskOffsetSum)obj;
            if (this.topicGroupId != other.topicGroupId) {
                return false;
            }
            if (this.partitionToOffsetSum == null ? other.partitionToOffsetSum != null : !this.partitionToOffsetSum.equals(other.partitionToOffsetSum)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicGroupId;
            hashCode = 31 * hashCode + (this.partitionToOffsetSum == null ? 0 : this.partitionToOffsetSum.hashCode());
            return hashCode;
        }

        public TaskOffsetSum duplicate() {
            TaskOffsetSum _duplicate = new TaskOffsetSum();
            _duplicate.topicGroupId = this.topicGroupId;
            ArrayList<PartitionToOffsetSum> newPartitionToOffsetSum = new ArrayList<PartitionToOffsetSum>(this.partitionToOffsetSum.size());
            for (PartitionToOffsetSum _element : this.partitionToOffsetSum) {
                newPartitionToOffsetSum.add(_element.duplicate());
            }
            _duplicate.partitionToOffsetSum = newPartitionToOffsetSum;
            return _duplicate;
        }

        public String toString() {
            return "TaskOffsetSum(topicGroupId=" + this.topicGroupId + ", partitionToOffsetSum=" + MessageUtil.deepToString(this.partitionToOffsetSum.iterator()) + ")";
        }

        public int topicGroupId() {
            return this.topicGroupId;
        }

        public List<PartitionToOffsetSum> partitionToOffsetSum() {
            return this.partitionToOffsetSum;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskOffsetSum setTopicGroupId(int v) {
            this.topicGroupId = v;
            return this;
        }

        public TaskOffsetSum setPartitionToOffsetSum(List<PartitionToOffsetSum> v) {
            this.partitionToOffsetSum = v;
            return this;
        }

        static {
            SCHEMA_9 = SCHEMA_8 = (SCHEMA_7 = new Schema(new Field[]{new Field("topic_group_id", (Type)Type.INT32, ""), new Field("partition_to_offset_sum", (Type)new ArrayOf((Type)PartitionToOffsetSum.SCHEMA_7), "")}));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, SCHEMA_7, SCHEMA_8, SCHEMA_9};
        }
    }

    public static class TaskId
    implements Message {
        int topicGroupId;
        int partition;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 9;

        public TaskId(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TaskId() {
            this.topicGroupId = 0;
            this.partition = 0;
        }

        public short lowestSupportedVersion() {
            return 1;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.topicGroupId = _readable.readInt();
            this.partition = _readable.readInt();
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.topicGroupId);
            _writable.writeInt(this.partition);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskId)) {
                return false;
            }
            TaskId other = (TaskId)obj;
            if (this.topicGroupId != other.topicGroupId) {
                return false;
            }
            if (this.partition != other.partition) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicGroupId;
            hashCode = 31 * hashCode + this.partition;
            return hashCode;
        }

        public TaskId duplicate() {
            TaskId _duplicate = new TaskId();
            _duplicate.topicGroupId = this.topicGroupId;
            _duplicate.partition = this.partition;
            return _duplicate;
        }

        public String toString() {
            return "TaskId(topicGroupId=" + this.topicGroupId + ", partition=" + this.partition + ")";
        }

        public int topicGroupId() {
            return this.topicGroupId;
        }

        public int partition() {
            return this.partition;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskId setTopicGroupId(int v) {
            this.topicGroupId = v;
            return this;
        }

        public TaskId setPartition(int v) {
            this.partition = v;
            return this;
        }

        static {
            SCHEMA_9 = SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("topic_group_id", (Type)Type.INT32, ""), new Field("partition", (Type)Type.INT32, "")}))))))));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
        }
    }

    public static class PartitionToOffsetSum
    implements Message {
        int partition;
        long offsetSum;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 7;
        public static final short HIGHEST_SUPPORTED_VERSION = 9;

        public PartitionToOffsetSum(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionToOffsetSum() {
            this.partition = 0;
            this.offsetSum = 0L;
        }

        public short lowestSupportedVersion() {
            return 7;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.partition = _readable.readInt();
            this.offsetSum = _readable.readLong();
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partition);
            _writable.writeLong(this.offsetSum);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(4);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionToOffsetSum)) {
                return false;
            }
            PartitionToOffsetSum other = (PartitionToOffsetSum)obj;
            if (this.partition != other.partition) {
                return false;
            }
            if (this.offsetSum != other.offsetSum) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partition;
            hashCode = 31 * hashCode + ((int)(this.offsetSum >> 32) ^ (int)this.offsetSum);
            return hashCode;
        }

        public PartitionToOffsetSum duplicate() {
            PartitionToOffsetSum _duplicate = new PartitionToOffsetSum();
            _duplicate.partition = this.partition;
            _duplicate.offsetSum = this.offsetSum;
            return _duplicate;
        }

        public String toString() {
            return "PartitionToOffsetSum(partition=" + this.partition + ", offsetSum=" + this.offsetSum + ")";
        }

        public int partition() {
            return this.partition;
        }

        public long offsetSum() {
            return this.offsetSum;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionToOffsetSum setPartition(int v) {
            this.partition = v;
            return this;
        }

        public PartitionToOffsetSum setOffsetSum(long v) {
            this.offsetSum = v;
            return this;
        }

        static {
            SCHEMA_9 = SCHEMA_8 = (SCHEMA_7 = new Schema(new Field[]{new Field("partition", (Type)Type.INT32, ""), new Field("offset_sum", (Type)Type.INT64, "")}));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, SCHEMA_7, SCHEMA_8, SCHEMA_9};
        }
    }
}

