/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.KeyValueToTimestampedKeyValueIteratorAdapter;
import org.apache.kafka.streams.state.internals.ValueAndTimestampDeserializer;

class WindowToTimestampedWindowByteStoreAdapter
implements WindowStore<Bytes, byte[]> {
    final WindowStore<Bytes, byte[]> store;

    WindowToTimestampedWindowByteStoreAdapter(WindowStore<Bytes, byte[]> store) {
        if (!store.persistent()) {
            throw new IllegalArgumentException("Provided store must be a persistent store, but it is not.");
        }
        this.store = store;
    }

    @Override
    public void put(Bytes key, byte[] valueWithTimestamp) {
        this.store.put(key, valueWithTimestamp == null ? null : ValueAndTimestampDeserializer.rawValue(valueWithTimestamp));
    }

    @Override
    public void put(Bytes key, byte[] valueWithTimestamp, long windowStartTimestamp) {
        this.store.put(key, valueWithTimestamp == null ? null : ValueAndTimestampDeserializer.rawValue(valueWithTimestamp), windowStartTimestamp);
    }

    @Override
    public byte[] fetch(Bytes key, long time) {
        return TimestampedBytesStore.convertToTimestampedFormat((byte[])this.store.fetch(key, time));
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        return new WindowToTimestampedWindowIteratorAdapter((KeyValueIterator<Long, byte[]>)this.store.fetch(key, timeFrom, timeTo));
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, Instant from, Instant to) {
        return new WindowToTimestampedWindowIteratorAdapter((KeyValueIterator<Long, byte[]>)this.store.fetch(key, from, to));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to, long timeFrom, long timeTo) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.fetch(from, to, timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to, Instant fromTime, Instant toTime) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.fetch(from, to, fromTime, toTime));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.all());
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.fetchAll(timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(Instant from, Instant to) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.fetchAll(from, to));
    }

    @Override
    public String name() {
        return this.store.name();
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.store.init(context, root);
    }

    @Override
    public void flush() {
        this.store.flush();
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.store.isOpen();
    }

    private static class WindowToTimestampedWindowIteratorAdapter
    extends KeyValueToTimestampedKeyValueIteratorAdapter<Long>
    implements WindowStoreIterator<byte[]> {
        WindowToTimestampedWindowIteratorAdapter(KeyValueIterator<Long, byte[]> innerIterator) {
            super(innerIterator);
        }
    }
}

