/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.ThreadCache;

class MergedSortedCacheKeyValueStoreIterator<K, V>
implements KeyValueIterator<K, V> {
    private final ThreadCache.MemoryLRUCacheBytesIterator cacheIterator;
    private final PeekingKeyValueIterator<Bytes, byte[]> storeIterator;
    private final StateSerdes<K, V> serdes;
    private final Comparator<byte[]> comparator = Bytes.BYTES_LEXICO_COMPARATOR;

    public MergedSortedCacheKeyValueStoreIterator(ThreadCache.MemoryLRUCacheBytesIterator cacheIterator, PeekingKeyValueIterator<Bytes, byte[]> storeIterator, StateSerdes<K, V> serdes) {
        this.cacheIterator = cacheIterator;
        this.storeIterator = storeIterator;
        this.serdes = serdes;
    }

    @Override
    public boolean hasNext() {
        while (this.cacheIterator.hasNext() && this.isDeletedCacheEntry(this.cacheIterator.peekNext())) {
            byte[] storeKey;
            if (this.storeIterator.hasNext() && this.comparator.compare(storeKey = this.storeIterator.peekNextKey().get(), (byte[])this.cacheIterator.peekNext().key) == 0) {
                this.storeIterator.next();
            }
            this.cacheIterator.next();
        }
        return this.cacheIterator.hasNext() || this.storeIterator.hasNext();
    }

    private boolean isDeletedCacheEntry(KeyValue<byte[], LRUCacheEntry> nextFromCache) {
        return ((LRUCacheEntry)nextFromCache.value).value == null;
    }

    @Override
    public KeyValue<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        byte[] nextCacheKey = null;
        if (this.cacheIterator.hasNext()) {
            nextCacheKey = this.cacheIterator.peekNextKey();
        }
        byte[] nextStoreKey = null;
        if (this.storeIterator.hasNext()) {
            nextStoreKey = this.storeIterator.peekNextKey().get();
        }
        if (nextCacheKey == null) {
            return this.nextStoreValue();
        }
        if (nextStoreKey == null) {
            return this.nextCacheValue();
        }
        int comparison = this.comparator.compare(nextCacheKey, nextStoreKey);
        if (comparison > 0) {
            return this.nextStoreValue();
        }
        if (comparison < 0) {
            return this.nextCacheValue();
        }
        this.storeIterator.next();
        return this.nextCacheValue();
    }

    private KeyValue<K, V> nextCacheValue() {
        Object next = this.cacheIterator.next();
        return KeyValue.pair(this.serdes.keyFrom((byte[])((KeyValue)next).key), this.serdes.valueFrom(((LRUCacheEntry)((KeyValue)next).value).value));
    }

    private KeyValue<K, V> nextStoreValue() {
        KeyValue next = (KeyValue)this.storeIterator.next();
        return KeyValue.pair(this.serdes.keyFrom(((Bytes)next.key).get()), this.serdes.valueFrom((byte[])next.value));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    @Override
    public void close() {
        this.cacheIterator.close();
        this.storeIterator.close();
    }
}

