/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Count;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskIdFormatException;
import org.apache.kafka.streams.processor.PartitionGrouper;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamPartitionAssignor;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.ThreadCacheMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(StreamThread.class);
    private static final AtomicInteger STREAM_THREAD_ID_SEQUENCE = new AtomicInteger(1);
    public final PartitionGrouper partitionGrouper;
    private final StreamsMetadataState streamsMetadataState;
    public final String applicationId;
    public final String clientId;
    public final UUID processId;
    protected final StreamsConfig config;
    protected final TopologyBuilder builder;
    protected final Set<String> sourceTopics;
    protected final Pattern topicPattern;
    protected final Producer<byte[], byte[]> producer;
    protected final Consumer<byte[], byte[]> consumer;
    protected final Consumer<byte[], byte[]> restoreConsumer;
    private final String logPrefix;
    private final String threadClientId;
    private final AtomicBoolean running;
    private final Map<TaskId, StreamTask> activeTasks;
    private final Map<TaskId, StandbyTask> standbyTasks;
    private final Map<TopicPartition, StreamTask> activeTasksByPartition;
    private final Map<TopicPartition, StandbyTask> standbyTasksByPartition;
    private final Set<TaskId> prevTasks;
    private final Time time;
    private final long pollTimeMs;
    private final long cleanTimeMs;
    private final long commitTimeMs;
    private final StreamsMetricsImpl sensors;
    final StateDirectory stateDirectory;
    private StreamPartitionAssignor partitionAssignor = null;
    private long timerStartedMs;
    private long lastCleanMs;
    private long lastCommitMs;
    private Throwable rebalanceException = null;
    private Map<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> standbyRecords;
    private boolean processStandbyRecords = false;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private final long cacheSizeBytes;
    private ThreadCache cache;
    final ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(){

        public void onPartitionsAssigned(Collection<TopicPartition> assignment) {
            try {
                log.info("stream-thread [{}] New partitions [{}] assigned at the end of consumer rebalance.", (Object)StreamThread.this.getName(), assignment);
                StreamThread.this.addStreamTasks(assignment);
                StreamThread.this.addStandbyTasks();
                StreamThread.this.lastCleanMs = StreamThread.this.time.milliseconds();
                StreamThread.this.streamsMetadataState.onChange(StreamThread.this.partitionAssignor.getPartitionsByHostState(), StreamThread.this.partitionAssignor.clusterMetadata());
                StreamThread.this.initialized.set(true);
            }
            catch (Throwable t) {
                StreamThread.this.rebalanceException = t;
                throw t;
            }
        }

        public void onPartitionsRevoked(Collection<TopicPartition> assignment) {
            try {
                log.info("stream-thread [{}] partitions [{}] revoked at the beginning of consumer rebalance.", (Object)StreamThread.this.getName(), assignment);
                StreamThread.this.initialized.set(false);
                StreamThread.this.lastCleanMs = Long.MAX_VALUE;
                StreamThread.this.shutdownTasksAndState(true);
            }
            catch (Throwable t) {
                StreamThread.this.rebalanceException = t;
                throw t;
            }
            finally {
                StreamThread.this.streamsMetadataState.onChange(Collections.emptyMap(), StreamThread.this.partitionAssignor.clusterMetadata());
                StreamThread.this.removeStreamTasks();
                StreamThread.this.removeStandbyTasks();
            }
        }
    };

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public StreamThread(TopologyBuilder builder, StreamsConfig config, KafkaClientSupplier clientSupplier, String applicationId, String clientId, UUID processId, Metrics metrics, Time time, StreamsMetadataState streamsMetadataState) {
        super("StreamThread-" + STREAM_THREAD_ID_SEQUENCE.getAndIncrement());
        this.applicationId = applicationId;
        String threadName = this.getName();
        this.config = config;
        this.builder = builder;
        this.sourceTopics = builder.sourceTopics();
        this.topicPattern = builder.sourceTopicPattern();
        this.clientId = clientId;
        this.processId = processId;
        this.partitionGrouper = (PartitionGrouper)config.getConfiguredInstance("partition.grouper", PartitionGrouper.class);
        this.streamsMetadataState = streamsMetadataState;
        this.threadClientId = clientId + "-" + threadName;
        this.sensors = new StreamsMetricsImpl(metrics);
        if (config.getLong("cache.max.bytes.buffering") < 0L) {
            log.warn("Negative cache size passed in thread [{}]. Reverting to cache size of 0 bytes.", (Object)threadName);
        }
        this.cacheSizeBytes = Math.max(0L, config.getLong("cache.max.bytes.buffering") / (long)config.getInt("num.stream.threads").intValue());
        this.cache = new ThreadCache(this.threadClientId, this.cacheSizeBytes, this.sensors);
        this.logPrefix = String.format("stream-thread [%s]", threadName);
        log.info("{} Creating producer client", (Object)this.logPrefix);
        this.producer = clientSupplier.getProducer(config.getProducerConfigs(this.threadClientId));
        log.info("{} Creating consumer client", (Object)this.logPrefix);
        this.consumer = clientSupplier.getConsumer(config.getConsumerConfigs(this, applicationId, this.threadClientId));
        log.info("{} Creating restore consumer client", (Object)this.logPrefix);
        this.restoreConsumer = clientSupplier.getRestoreConsumer(config.getRestoreConsumerConfigs(this.threadClientId));
        this.activeTasks = new ConcurrentHashMap<TaskId, StreamTask>();
        this.standbyTasks = new HashMap<TaskId, StandbyTask>();
        this.activeTasksByPartition = new HashMap<TopicPartition, StreamTask>();
        this.standbyTasksByPartition = new HashMap<TopicPartition, StandbyTask>();
        this.prevTasks = new HashSet<TaskId>();
        this.standbyRecords = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>();
        this.stateDirectory = new StateDirectory(applicationId, config.getString("state.dir"));
        this.pollTimeMs = config.getLong("poll.ms");
        this.commitTimeMs = config.getLong("commit.interval.ms");
        this.cleanTimeMs = config.getLong("state.cleanup.delay.ms");
        this.time = time;
        this.timerStartedMs = time.milliseconds();
        this.lastCleanMs = Long.MAX_VALUE;
        this.lastCommitMs = this.timerStartedMs;
        this.running = new AtomicBoolean(true);
    }

    public void partitionAssignor(StreamPartitionAssignor partitionAssignor) {
        this.partitionAssignor = partitionAssignor;
    }

    @Override
    public void run() {
        log.info("{} Starting", (Object)this.logPrefix);
        try {
            this.runLoop();
        }
        catch (KafkaException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("{} Streams application error during processing: ", (Object)this.logPrefix, (Object)e);
            throw e;
        }
        finally {
            this.shutdown();
        }
    }

    public void close() {
        this.running.set(false);
    }

    public Map<TaskId, StreamTask> tasks() {
        return Collections.unmodifiableMap(this.activeTasks);
    }

    private void shutdown() {
        log.info("{} Shutting down", (Object)this.logPrefix);
        this.shutdownTasksAndState(false);
        try {
            this.producer.close();
        }
        catch (Throwable e) {
            log.error("{} Failed to close producer: ", (Object)this.logPrefix, (Object)e);
        }
        try {
            this.consumer.close();
        }
        catch (Throwable e) {
            log.error("{} Failed to close consumer: ", (Object)this.logPrefix, (Object)e);
        }
        try {
            this.restoreConsumer.close();
        }
        catch (Throwable e) {
            log.error("{} Failed to close restore consumer: ", (Object)this.logPrefix, (Object)e);
        }
        this.removeStreamTasks();
        this.removeStandbyTasks();
        log.info("{} Stream thread shutdown complete", (Object)this.logPrefix);
    }

    private void shutdownTasksAndState(boolean rethrowExceptions) {
        block2: {
            this.commitOffsets(rethrowExceptions);
            this.closeAllTasks();
            this.flushAllState(rethrowExceptions);
            this.producer.flush();
            this.closeAllStateManagers(rethrowExceptions);
            try {
                this.restoreConsumer.assign(Collections.emptyList());
            }
            catch (Exception e) {
                log.error("{} Failed to un-assign change log partitions: ", (Object)this.logPrefix, (Object)e);
                if (!rethrowExceptions) break block2;
                throw e;
            }
        }
    }

    private void performOnAllTasks(AbstractTaskAction action, String exceptionMessage, boolean throwExceptions) {
        ArrayList<StreamTask> allTasks = new ArrayList<StreamTask>(this.activeTasks.values());
        allTasks.addAll(this.standbyTasks.values());
        for (AbstractTask abstractTask : allTasks) {
            try {
                action.apply(abstractTask);
            }
            catch (KafkaException e) {
                log.error("{} Failed while executing {} {} duet to {}: ", new Object[]{this.logPrefix, abstractTask.getClass().getSimpleName(), abstractTask.id(), exceptionMessage, e});
                if (!throwExceptions) continue;
                throw e;
            }
        }
    }

    private void closeAllStateManagers(boolean throwExceptions) {
        this.performOnAllTasks(new AbstractTaskAction(){

            @Override
            public void apply(AbstractTask task) {
                log.info("{} Closing the state manager of task {}", (Object)StreamThread.this.logPrefix, (Object)task.id());
                task.closeStateManager();
            }
        }, "close state manager", throwExceptions);
    }

    private void commitOffsets(boolean throwExceptions) {
        this.performOnAllTasks(new AbstractTaskAction(){

            @Override
            public void apply(AbstractTask task) {
                log.info("{} Committing consumer offsets of task {}", (Object)StreamThread.this.logPrefix, (Object)task.id());
                task.commitOffsets();
            }
        }, "commit consumer offsets", throwExceptions);
    }

    private void flushAllState(boolean throwExceptions) {
        this.performOnAllTasks(new AbstractTaskAction(){

            @Override
            public void apply(AbstractTask task) {
                log.info("{} Flushing state stores of task {}", (Object)StreamThread.this.logPrefix, (Object)task.id());
                task.flushState();
            }
        }, "flush state", throwExceptions);
    }

    private long computeLatency() {
        long previousTimeMs = this.timerStartedMs;
        this.timerStartedMs = this.time.milliseconds();
        return Math.max(this.timerStartedMs - previousTimeMs, 0L);
    }

    private void runLoop() {
        int totalNumBuffered = 0;
        boolean requiresPoll = true;
        boolean polledRecords = false;
        if (this.topicPattern != null) {
            this.consumer.subscribe(this.topicPattern, this.rebalanceListener);
        } else {
            this.consumer.subscribe(new ArrayList<String>(this.sourceTopics), this.rebalanceListener);
        }
        while (this.stillRunning()) {
            this.timerStartedMs = this.time.milliseconds();
            if (requiresPoll) {
                requiresPoll = false;
                boolean longPoll = totalNumBuffered == 0;
                ConsumerRecords records = this.consumer.poll(longPoll ? this.pollTimeMs : 0L);
                if (this.rebalanceException != null) {
                    throw new StreamsException(this.logPrefix + " Failed to rebalance", this.rebalanceException);
                }
                if (!records.isEmpty()) {
                    for (TopicPartition partition : records.partitions()) {
                        StreamTask task = this.activeTasksByPartition.get(partition);
                        task.addRecords(partition, records.records(partition));
                    }
                    polledRecords = true;
                } else {
                    polledRecords = false;
                }
                if (longPoll) {
                    this.sensors.pollTimeSensor.record((double)this.computeLatency());
                }
            }
            if (totalNumBuffered > 0 || polledRecords) {
                totalNumBuffered = 0;
                if (!this.activeTasks.isEmpty()) {
                    for (StreamTask task : this.activeTasks.values()) {
                        totalNumBuffered += task.process();
                        requiresPoll = requiresPoll || task.requiresPoll();
                        this.sensors.processTimeSensor.record((double)this.computeLatency());
                        this.maybePunctuate(task);
                        if (!task.commitNeeded()) continue;
                        this.commitOne(task);
                    }
                } else {
                    requiresPoll = true;
                }
            } else {
                requiresPoll = true;
            }
            this.maybeCommit();
            this.maybeUpdateStandbyTasks();
            this.maybeClean();
        }
    }

    private void maybeUpdateStandbyTasks() {
        if (!this.standbyTasks.isEmpty()) {
            ConsumerRecords records;
            if (this.processStandbyRecords) {
                if (!this.standbyRecords.isEmpty()) {
                    HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> remainingStandbyRecords = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>();
                    for (TopicPartition partition : this.standbyRecords.keySet()) {
                        List<ConsumerRecord<byte[], byte[]>> remaining = this.standbyRecords.get(partition);
                        if (remaining == null) continue;
                        StandbyTask task = this.standbyTasksByPartition.get(partition);
                        remaining = task.update(partition, remaining);
                        if (remaining != null) {
                            remainingStandbyRecords.put(partition, remaining);
                            continue;
                        }
                        this.restoreConsumer.resume(Collections.singleton(partition));
                    }
                    this.standbyRecords = remainingStandbyRecords;
                }
                this.processStandbyRecords = false;
            }
            if (!(records = this.restoreConsumer.poll(0L)).isEmpty()) {
                for (TopicPartition partition : records.partitions()) {
                    StandbyTask task = this.standbyTasksByPartition.get(partition);
                    if (task == null) {
                        throw new StreamsException(this.logPrefix + " Missing standby task for partition " + partition);
                    }
                    List<ConsumerRecord<byte[], byte[]>> remaining = task.update(partition, records.records(partition));
                    if (remaining == null) continue;
                    this.restoreConsumer.pause(Collections.singleton(partition));
                    this.standbyRecords.put(partition, remaining);
                }
            }
        }
    }

    private boolean stillRunning() {
        if (!this.running.get()) {
            log.debug("{} Shutting down at user request", (Object)this.logPrefix);
            return false;
        }
        return true;
    }

    private void maybePunctuate(StreamTask task) {
        try {
            if (task.maybePunctuate()) {
                this.sensors.punctuateTimeSensor.record((double)this.computeLatency());
            }
        }
        catch (KafkaException e) {
            log.error("{} Failed to punctuate active task {}: ", new Object[]{this.logPrefix, task.id(), e});
            throw e;
        }
    }

    protected void maybeCommit() {
        long now = this.time.milliseconds();
        if (this.commitTimeMs >= 0L && this.lastCommitMs + this.commitTimeMs < now) {
            log.info("{} Committing all tasks because the commit interval {}ms has elapsed", (Object)this.logPrefix, (Object)this.commitTimeMs);
            this.commitAll();
            this.lastCommitMs = now;
            this.processStandbyRecords = true;
        }
    }

    protected void maybeClean() {
        long now = this.time.milliseconds();
        if (now > this.lastCleanMs + this.cleanTimeMs) {
            this.stateDirectory.cleanRemovedTasks();
            this.lastCleanMs = now;
        }
    }

    private void commitAll() {
        for (StreamTask streamTask : this.activeTasks.values()) {
            this.commitOne(streamTask);
        }
        for (StandbyTask standbyTask : this.standbyTasks.values()) {
            this.commitOne(standbyTask);
        }
    }

    private void commitOne(AbstractTask task) {
        log.info("{} Committing task {}", (Object)this.logPrefix, (Object)task.id());
        try {
            task.commit();
        }
        catch (CommitFailedException e) {
            log.warn("{} Failed to commit {} {} state: ", new Object[]{this.logPrefix, task.getClass().getSimpleName(), task.id(), e});
        }
        catch (KafkaException e) {
            log.error("{} Failed to commit {} {} state: ", new Object[]{this.logPrefix, task.getClass().getSimpleName(), task.id(), e});
            throw e;
        }
        this.sensors.commitTimeSensor.record((double)this.computeLatency());
    }

    public Set<TaskId> prevTasks() {
        return Collections.unmodifiableSet(this.prevTasks);
    }

    public Set<TaskId> cachedTasks() {
        HashSet<TaskId> tasks = new HashSet<TaskId>();
        File[] stateDirs = this.stateDirectory.listTaskDirectories();
        if (stateDirs != null) {
            for (File dir : stateDirs) {
                try {
                    TaskId id = TaskId.parse(dir.getName());
                    if (!new File(dir, ".checkpoint").exists()) continue;
                    tasks.add(id);
                }
                catch (TaskIdFormatException taskIdFormatException) {
                    // empty catch block
                }
            }
        }
        return tasks;
    }

    protected StreamTask createStreamTask(TaskId id, Collection<TopicPartition> partitions) {
        log.info("{} Creating active task {} with assigned partitions [{}]", new Object[]{this.logPrefix, id, partitions});
        this.sensors.taskCreationSensor.record();
        ProcessorTopology topology = this.builder.build(id.topicGroupId);
        return new StreamTask(id, this.applicationId, partitions, topology, this.consumer, this.producer, this.restoreConsumer, this.config, this.sensors, this.stateDirectory, this.cache);
    }

    private void addStreamTasks(Collection<TopicPartition> assignment) {
        if (this.partitionAssignor == null) {
            throw new IllegalStateException(this.logPrefix + " Partition assignor has not been initialized while adding stream tasks: this should not happen.");
        }
        HashMap<TaskId, HashSet<TopicPartition>> partitionsForTask = new HashMap<TaskId, HashSet<TopicPartition>>();
        for (TopicPartition topicPartition : assignment) {
            Set<TaskId> taskIds = this.partitionAssignor.tasksForPartition(topicPartition);
            for (TaskId taskId : taskIds) {
                HashSet<TopicPartition> partitions = (HashSet<TopicPartition>)partitionsForTask.get(taskId);
                if (partitions == null) {
                    partitions = new HashSet<TopicPartition>();
                    partitionsForTask.put(taskId, partitions);
                }
                partitions.add(topicPartition);
            }
        }
        for (Map.Entry entry : partitionsForTask.entrySet()) {
            TaskId taskId = (TaskId)entry.getKey();
            Set partitions = (Set)entry.getValue();
            try {
                StreamTask task = this.createStreamTask(taskId, partitions);
                this.activeTasks.put(taskId, task);
                for (TopicPartition partition : partitions) {
                    this.activeTasksByPartition.put(partition, task);
                }
            }
            catch (StreamsException e) {
                log.error("{} Failed to create an active task {}: ", new Object[]{this.logPrefix, taskId, e});
                throw e;
            }
        }
    }

    private StandbyTask createStandbyTask(TaskId id, Collection<TopicPartition> partitions) {
        log.info("{} Creating new standby task {} with assigned partitions [{}]", new Object[]{this.logPrefix, id, partitions});
        this.sensors.taskCreationSensor.record();
        ProcessorTopology topology = this.builder.build(id.topicGroupId);
        if (!topology.stateStores().isEmpty()) {
            return new StandbyTask(id, this.applicationId, partitions, topology, this.consumer, this.restoreConsumer, this.config, this.sensors, this.stateDirectory);
        }
        return null;
    }

    private void addStandbyTasks() {
        if (this.partitionAssignor == null) {
            throw new IllegalStateException(this.logPrefix + " Partition assignor has not been initialized while adding standby tasks: this should not happen.");
        }
        HashMap<TopicPartition, Long> checkpointedOffsets = new HashMap<TopicPartition, Long>();
        for (Map.Entry<TaskId, Set<TopicPartition>> entry : this.partitionAssignor.standbyTasks().entrySet()) {
            Set<TopicPartition> partitions;
            TaskId taskId = entry.getKey();
            StandbyTask task = this.createStandbyTask(taskId, partitions = entry.getValue());
            if (task == null) continue;
            this.standbyTasks.put(taskId, task);
            for (TopicPartition partition : partitions) {
                this.standbyTasksByPartition.put(partition, task);
            }
            for (TopicPartition partition : task.checkpointedOffsets().keySet()) {
                this.standbyTasksByPartition.put(partition, task);
            }
            checkpointedOffsets.putAll(task.checkpointedOffsets());
        }
        this.restoreConsumer.assign(new ArrayList(checkpointedOffsets.keySet()));
        for (Map.Entry<TaskId, Set<Object>> entry : checkpointedOffsets.entrySet()) {
            TopicPartition partition = (TopicPartition)entry.getKey();
            long offset = (Long)((Object)entry.getValue());
            if (offset >= 0L) {
                this.restoreConsumer.seek(partition, offset);
                continue;
            }
            this.restoreConsumer.seekToBeginning(Collections.singleton(partition));
        }
    }

    private void removeStreamTasks() {
        log.info("{} Removing all active tasks [{}]", (Object)this.logPrefix, this.activeTasks.keySet());
        try {
            this.prevTasks.clear();
            this.prevTasks.addAll(this.activeTasks.keySet());
            this.activeTasks.clear();
            this.activeTasksByPartition.clear();
        }
        catch (Exception e) {
            log.error("{} Failed to remove stream tasks: ", (Object)this.logPrefix, (Object)e);
        }
    }

    private void removeStandbyTasks() {
        log.info("{} Removing all standby tasks [{}]", (Object)this.logPrefix, this.standbyTasks.keySet());
        this.standbyTasks.clear();
        this.standbyTasksByPartition.clear();
        this.standbyRecords.clear();
    }

    private void closeAllTasks() {
        this.performOnAllTasks(new AbstractTaskAction(){

            @Override
            public void apply(AbstractTask task) {
                log.info("{} Closing a task {}", (Object)StreamThread.this.logPrefix, (Object)task.id());
                task.close();
                ((StreamThread)StreamThread.this).sensors.taskDestructionSensor.record();
            }
        }, "close", false);
    }

    @Override
    public String toString() {
        AbstractTask task;
        StringBuilder sb = new StringBuilder("StreamsThread appId:" + this.applicationId + "\n");
        sb.append("\tStreamsThread clientId:" + this.clientId + "\n");
        sb.append("\tStreamsThread threadId:" + this.getName() + "\n");
        if (this.activeTasks != null) {
            sb.append("\tActive tasks:\n");
            for (TaskId tId : this.activeTasks.keySet()) {
                task = this.activeTasks.get(tId);
                sb.append("\t\t" + ((StreamTask)task).toString());
            }
        }
        if (this.standbyTasks != null) {
            sb.append("\tStandby tasks:\n");
            for (TaskId tId : this.standbyTasks.keySet()) {
                task = this.standbyTasks.get(tId);
                sb.append("\t\t" + ((StandbyTask)task).toString());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private class StreamsMetricsImpl
    implements StreamsMetrics,
    ThreadCacheMetrics {
        final Metrics metrics;
        final String metricGrpName;
        final String sensorNamePrefix;
        final Map<String, String> metricTags;
        final Sensor commitTimeSensor;
        final Sensor pollTimeSensor;
        final Sensor processTimeSensor;
        final Sensor punctuateTimeSensor;
        final Sensor taskCreationSensor;
        final Sensor taskDestructionSensor;

        public StreamsMetricsImpl(Metrics metrics) {
            this.metrics = metrics;
            this.metricGrpName = "stream-metrics";
            this.sensorNamePrefix = "thread." + StreamThread.this.threadClientId;
            this.metricTags = Collections.singletonMap("client-id", StreamThread.this.threadClientId);
            this.commitTimeSensor = metrics.sensor(this.sensorNamePrefix + ".commit-time");
            this.commitTimeSensor.add(metrics.metricName("commit-time-avg", this.metricGrpName, "The average commit time in ms", this.metricTags), (MeasurableStat)new Avg());
            this.commitTimeSensor.add(metrics.metricName("commit-time-max", this.metricGrpName, "The maximum commit time in ms", this.metricTags), (MeasurableStat)new Max());
            this.commitTimeSensor.add(metrics.metricName("commit-calls-rate", this.metricGrpName, "The average per-second number of commit calls", this.metricTags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.pollTimeSensor = metrics.sensor(this.sensorNamePrefix + ".poll-time");
            this.pollTimeSensor.add(metrics.metricName("poll-time-avg", this.metricGrpName, "The average poll time in ms", this.metricTags), (MeasurableStat)new Avg());
            this.pollTimeSensor.add(metrics.metricName("poll-time-max", this.metricGrpName, "The maximum poll time in ms", this.metricTags), (MeasurableStat)new Max());
            this.pollTimeSensor.add(metrics.metricName("poll-calls-rate", this.metricGrpName, "The average per-second number of record-poll calls", this.metricTags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.processTimeSensor = metrics.sensor(this.sensorNamePrefix + ".process-time");
            this.processTimeSensor.add(metrics.metricName("process-time-avg-ms", this.metricGrpName, "The average process time in ms", this.metricTags), (MeasurableStat)new Avg());
            this.processTimeSensor.add(metrics.metricName("process-time-max-ms", this.metricGrpName, "The maximum process time in ms", this.metricTags), (MeasurableStat)new Max());
            this.processTimeSensor.add(metrics.metricName("process-calls-rate", this.metricGrpName, "The average per-second number of process calls", this.metricTags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.punctuateTimeSensor = metrics.sensor(this.sensorNamePrefix + ".punctuate-time");
            this.punctuateTimeSensor.add(metrics.metricName("punctuate-time-avg", this.metricGrpName, "The average punctuate time in ms", this.metricTags), (MeasurableStat)new Avg());
            this.punctuateTimeSensor.add(metrics.metricName("punctuate-time-max", this.metricGrpName, "The maximum punctuate time in ms", this.metricTags), (MeasurableStat)new Max());
            this.punctuateTimeSensor.add(metrics.metricName("punctuate-calls-rate", this.metricGrpName, "The average per-second number of punctuate calls", this.metricTags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.taskCreationSensor = metrics.sensor(this.sensorNamePrefix + ".task-creation");
            this.taskCreationSensor.add(metrics.metricName("task-creation-rate", this.metricGrpName, "The average per-second number of newly created tasks", this.metricTags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.taskDestructionSensor = metrics.sensor(this.sensorNamePrefix + ".task-destruction");
            this.taskDestructionSensor.add(metrics.metricName("task-destruction-rate", this.metricGrpName, "The average per-second number of destructed tasks", this.metricTags), (MeasurableStat)new Rate((SampledStat)new Count()));
        }

        @Override
        public void recordLatency(Sensor sensor, long startNs, long endNs) {
            sensor.record((double)(endNs - startNs), StreamThread.this.timerStartedMs);
        }

        @Override
        public void recordCacheSensor(Sensor sensor, double count) {
            sensor.record(count);
        }

        @Override
        public Sensor addLatencySensor(String scopeName, String entityName, String operationName, String ... tags) {
            HashMap<String, String> tagMap = new HashMap<String, String>(this.metricTags);
            if (tags.length % 2 != 0) {
                throw new IllegalArgumentException("Tags needs to be specified in key-value pairs");
            }
            for (int i = 0; i < tags.length; i += 2) {
                tagMap.put(tags[i], tags[i + 1]);
            }
            String metricGroupName = "stream-" + scopeName + "-metrics";
            Sensor parent = this.metrics.sensor(this.sensorNamePrefix + "." + scopeName + "-" + operationName);
            this.addLatencyMetrics(metricGroupName, parent, "all", operationName, this.metricTags);
            Sensor sensor = this.metrics.sensor(this.sensorNamePrefix + "." + scopeName + "-" + entityName + "-" + operationName, new Sensor[]{parent});
            this.addLatencyMetrics(metricGroupName, sensor, entityName, operationName, tagMap);
            return sensor;
        }

        @Override
        public Sensor addCacheSensor(String entityName, String operationName, String ... tags) {
            HashMap<String, String> tagMap = new HashMap<String, String>(this.metricTags);
            if (tags.length % 2 != 0) {
                throw new IllegalArgumentException("Tags needs to be specified in key-value pairs");
            }
            for (int i = 0; i < tags.length; i += 2) {
                tagMap.put(tags[i], tags[i + 1]);
            }
            String metricGroupName = "stream-thread-cache-metrics";
            Sensor sensor = this.metrics.sensor(this.sensorNamePrefix + "-" + entityName + "-" + operationName);
            this.addCacheMetrics(metricGroupName, sensor, entityName, operationName, tagMap);
            return sensor;
        }

        private void addCacheMetrics(String metricGrpName, Sensor sensor, String entityName, String opName, Map<String, String> tags) {
            this.maybeAddMetric(sensor, this.metrics.metricName(entityName + "-" + opName + "-avg", metricGrpName, "The current count of " + entityName + " " + opName + " operation.", tags), (MeasurableStat)new Avg());
            this.maybeAddMetric(sensor, this.metrics.metricName(entityName + "-" + opName + "-min", metricGrpName, "The current count of " + entityName + " " + opName + " operation.", tags), (MeasurableStat)new Min());
            this.maybeAddMetric(sensor, this.metrics.metricName(entityName + "-" + opName + "-max", metricGrpName, "The current count of " + entityName + " " + opName + " operation.", tags), (MeasurableStat)new Max());
        }

        private void addLatencyMetrics(String metricGrpName, Sensor sensor, String entityName, String opName, Map<String, String> tags) {
            this.maybeAddMetric(sensor, this.metrics.metricName(entityName + "-" + opName + "-avg-latency-ms", metricGrpName, "The average latency in milliseconds of " + entityName + " " + opName + " operation.", tags), (MeasurableStat)new Avg());
            this.maybeAddMetric(sensor, this.metrics.metricName(entityName + "-" + opName + "-max-latency-ms", metricGrpName, "The max latency in milliseconds of " + entityName + " " + opName + " operation.", tags), (MeasurableStat)new Max());
            this.maybeAddMetric(sensor, this.metrics.metricName(entityName + "-" + opName + "-qps", metricGrpName, "The average number of occurrence of " + entityName + " " + opName + " operation per second.", tags), (MeasurableStat)new Rate((SampledStat)new Count()));
        }

        private void maybeAddMetric(Sensor sensor, MetricName name, MeasurableStat stat) {
            if (!this.metrics.metrics().containsKey(name)) {
                sensor.add(name, stat);
            }
        }
    }

    static interface AbstractTaskAction {
        public void apply(AbstractTask var1);
    }
}

