/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentInfo;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.SubscriptionInfo;
import org.apache.kafka.streams.processor.internals.assignment.TaskAssignor;
import org.apache.kafka.streams.state.HostInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamPartitionAssignor
implements PartitionAssignor,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(StreamPartitionAssignor.class);
    private String userEndPointConfig;
    private Map<HostInfo, Set<TopicPartition>> partitionsByHostState;
    private Cluster metadataWithInternalTopics;
    private static final Comparator<TopicPartition> PARTITION_COMPARATOR = new Comparator<TopicPartition>(){

        @Override
        public int compare(TopicPartition p1, TopicPartition p2) {
            int result = p1.topic().compareTo(p2.topic());
            if (result != 0) {
                return result;
            }
            return p1.partition() < p2.partition() ? -1 : (p1.partition() > p2.partition() ? 1 : 0);
        }
    };
    private StreamThread streamThread;
    private int numStandbyReplicas;
    private Map<Integer, TopologyBuilder.TopicsInfo> topicGroups;
    private Map<TopicPartition, Set<TaskId>> partitionToTaskIds;
    private Map<InternalTopicConfig, Set<TaskId>> stateChangelogTopicToTaskIds;
    private Map<InternalTopicConfig, Set<TaskId>> internalSourceTopicToTaskIds;
    private Map<TaskId, Set<TopicPartition>> standbyTasks;
    private InternalTopicManager internalTopicManager;

    public void configure(Map<String, ?> configs) {
        this.numStandbyReplicas = (Integer)configs.get("num.standby.replicas");
        Object o = configs.get("__stream.thread.instance__");
        if (o == null) {
            KafkaException ex = new KafkaException("StreamThread is not specified");
            log.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        if (!(o instanceof StreamThread)) {
            KafkaException ex = new KafkaException(String.format("%s is not an instance of %s", o.getClass().getName(), StreamThread.class.getName()));
            log.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        this.streamThread = (StreamThread)o;
        this.streamThread.partitionAssignor(this);
        String userEndPoint = (String)configs.get("application.server");
        if (userEndPoint != null && !userEndPoint.isEmpty()) {
            String[] hostPort = userEndPoint.split(":");
            if (hostPort.length != 2) {
                throw new ConfigException(String.format("stream-thread [%s] Config %s isn't in the correct format. Expected a host:port pair but received %s", this.streamThread.getName(), "application.server", userEndPoint));
            }
            try {
                Integer.valueOf(hostPort[1]);
                this.userEndPointConfig = userEndPoint;
            }
            catch (NumberFormatException nfe) {
                throw new ConfigException(String.format("stream-thread [%s] Invalid port %s supplied in %s for config %s", this.streamThread.getName(), hostPort[1], userEndPoint, "application.server"));
            }
        }
        if (configs.containsKey("zookeeper.connect")) {
            this.internalTopicManager = new InternalTopicManager((String)configs.get("zookeeper.connect"), configs.containsKey("replication.factor") ? (Integer)configs.get("replication.factor") : 1, configs.containsKey("windowstore.changelog.additional.retention.ms") ? (Long)configs.get("windowstore.changelog.additional.retention.ms") : InternalTopicManager.WINDOW_CHANGE_LOG_ADDITIONAL_RETENTION_DEFAULT);
        } else {
            log.info("stream-thread [{}] Config '{}' isn't supplied and hence no internal topics will be created.", (Object)this.streamThread.getName(), (Object)"zookeeper.connect");
        }
    }

    public String name() {
        return "stream";
    }

    public PartitionAssignor.Subscription subscription(Set<String> topics) {
        Set<TaskId> prevTasks = this.streamThread.prevTasks();
        Set<TaskId> standbyTasks = this.streamThread.cachedTasks();
        standbyTasks.removeAll(prevTasks);
        SubscriptionInfo data = new SubscriptionInfo(this.streamThread.processId, prevTasks, standbyTasks, this.userEndPointConfig);
        if (this.streamThread.builder.sourceTopicPattern() != null) {
            SubscriptionUpdates subscriptionUpdates = new SubscriptionUpdates();
            log.debug("stream-thread [{}] found {} topics possibly matching regex", (Object)this.streamThread.getName(), topics);
            subscriptionUpdates.updateTopics(topics);
            this.streamThread.builder.updateSubscriptions(subscriptionUpdates, this.streamThread.getName());
        }
        return new PartitionAssignor.Subscription(new ArrayList<String>(topics), data.encode());
    }

    private Map<TopicPartition, PartitionInfo> prepareTopic(Map<InternalTopicConfig, Set<TaskId>> topicToTaskIds, boolean postPartitionPhase) {
        HashMap<TopicPartition, PartitionInfo> partitionInfos = new HashMap<TopicPartition, PartitionInfo>();
        if (this.internalTopicManager != null) {
            log.debug("stream-thread [{}] Starting to validate internal topics in partition assignor.", (Object)this.streamThread.getName());
            for (Map.Entry<InternalTopicConfig, Set<TaskId>> entry : topicToTaskIds.entrySet()) {
                List partitions;
                InternalTopicConfig topic = entry.getKey();
                int numPartitions = 0;
                if (postPartitionPhase) {
                    for (TaskId task : entry.getValue()) {
                        if (numPartitions >= task.partition + 1) continue;
                        numPartitions = task.partition + 1;
                    }
                } else {
                    numPartitions = -1;
                    for (TaskId task : entry.getValue()) {
                        numPartitions = task.partition;
                    }
                }
                this.internalTopicManager.makeReady(topic, numPartitions);
                while ((partitions = this.streamThread.restoreConsumer.partitionsFor(topic.name())) == null || partitions.size() != numPartitions) {
                }
                for (PartitionInfo partition : partitions) {
                    partitionInfos.put(new TopicPartition(partition.topic(), partition.partition()), partition);
                }
            }
            log.info("stream-thread [{}] Completed validating internal topics in partition assignor", (Object)this.streamThread.getName());
        } else {
            ArrayList<String> missingTopics = new ArrayList<String>();
            for (InternalTopicConfig topic : topicToTaskIds.keySet()) {
                List partitions = this.streamThread.restoreConsumer.partitionsFor(topic.name());
                if (partitions != null) continue;
                missingTopics.add(topic.name());
            }
            if (!missingTopics.isEmpty()) {
                log.warn("stream-thread [{}] Topic {} do not exists but couldn't created as the config '{}' isn't supplied", new Object[]{this.streamThread.getName(), missingTopics, "zookeeper.connect"});
            }
        }
        return partitionInfos;
    }

    public Map<String, PartitionAssignor.Assignment> assign(Cluster metadata, Map<String, PartitionAssignor.Subscription> subscriptions) {
        HashMap<UUID, HashSet<String>> consumersByClient = new HashMap<UUID, HashSet<String>>();
        Map states = new HashMap();
        HashMap<UUID, HostInfo> consumerEndPointMap = new HashMap<UUID, HostInfo>();
        for (Map.Entry<String, PartitionAssignor.Subscription> entry : subscriptions.entrySet()) {
            HashSet<String> consumers;
            String consumerId = entry.getKey();
            PartitionAssignor.Subscription subscription = entry.getValue();
            SubscriptionInfo info = SubscriptionInfo.decode(subscription.userData());
            if (info.userEndPoint != null) {
                String[] hostPort = info.userEndPoint.split(":");
                consumerEndPointMap.put(info.processId, new HostInfo(hostPort[0], Integer.valueOf(hostPort[1])));
            }
            if ((consumers = (HashSet<String>)consumersByClient.get(info.processId)) == null) {
                consumers = new HashSet<String>();
                consumersByClient.put(info.processId, consumers);
            }
            consumers.add(consumerId);
            ClientState state = (ClientState)states.get(info.processId);
            if (state == null) {
                state = new ClientState();
                states.put(info.processId, state);
            }
            state.prevActiveTasks.addAll(info.prevTasks);
            state.prevAssignedTasks.addAll(info.prevTasks);
            state.prevAssignedTasks.addAll(info.standbyTasks);
            state.capacity += 1.0;
        }
        this.topicGroups = this.streamThread.builder.topicGroups();
        this.internalSourceTopicToTaskIds = new HashMap<InternalTopicConfig, Set<TaskId>>();
        HashMap<Integer, Set<String>> sourceTopicGroups = new HashMap<Integer, Set<String>>();
        HashMap<Integer, Collection<InternalTopicConfig>> internalSourceTopicGroups = new HashMap<Integer, Collection<InternalTopicConfig>>();
        for (Map.Entry<Integer, TopologyBuilder.TopicsInfo> entry : this.topicGroups.entrySet()) {
            sourceTopicGroups.put(entry.getKey(), entry.getValue().sourceTopics);
            internalSourceTopicGroups.put(entry.getKey(), entry.getValue().interSourceTopics.values());
        }
        Map<Object, Object> internalPartitionInfos = new HashMap();
        HashMap<String, InternalTopicConfig> allInternalTopics = new HashMap<String, InternalTopicConfig>();
        for (Map.Entry<Integer, TopologyBuilder.TopicsInfo> entry : this.topicGroups.entrySet()) {
            Map<String, InternalTopicConfig> internalTopics = entry.getValue().interSourceTopics;
            allInternalTopics.putAll(internalTopics);
            for (InternalTopicConfig internalTopic : internalTopics.values()) {
                Set<TaskId> tasks = this.internalSourceTopicToTaskIds.get(internalTopic);
                if (tasks != null) continue;
                int numPartitions = -1;
                for (Map.Entry<Integer, TopologyBuilder.TopicsInfo> other : this.topicGroups.entrySet()) {
                    Set<String> otherSinkTopics = other.getValue().sinkTopics;
                    if (!otherSinkTopics.contains(internalTopic.name())) continue;
                    for (String topic : other.getValue().sourceTopics) {
                        Integer partitions = null;
                        if (allInternalTopics.containsKey(topic)) {
                            Set<TaskId> taskIds = this.internalSourceTopicToTaskIds.get(allInternalTopics.get(topic));
                            if (taskIds != null) {
                                for (TaskId taskId : taskIds) {
                                    partitions = taskId.partition;
                                }
                            }
                        } else {
                            partitions = metadata.partitionCountForTopic(topic);
                        }
                        if (partitions == null || partitions <= numPartitions) continue;
                        numPartitions = partitions;
                    }
                }
                this.internalSourceTopicToTaskIds.put(internalTopic, Collections.singleton(new TaskId(entry.getKey(), numPartitions)));
                for (int partition = 0; partition < numPartitions; ++partition) {
                    internalPartitionInfos.put(new TopicPartition(internalTopic.name(), partition), new PartitionInfo(internalTopic.name(), partition, null, new Node[0], new Node[0]));
                }
            }
        }
        Collection<Set<String>> copartitionTopicGroups = this.streamThread.builder.copartitionGroups();
        this.ensureCopartitioning(copartitionTopicGroups, internalSourceTopicGroups, metadata.withPartitions(internalPartitionInfos));
        internalPartitionInfos = this.prepareTopic(this.internalSourceTopicToTaskIds, false);
        this.internalSourceTopicToTaskIds.clear();
        this.metadataWithInternalTopics = metadata;
        if (this.internalTopicManager != null) {
            this.metadataWithInternalTopics = metadata.withPartitions(internalPartitionInfos);
        }
        Map<TaskId, Set<TopicPartition>> partitionsForTask = this.streamThread.partitionGrouper.partitionGroups(sourceTopicGroups, this.metadataWithInternalTopics);
        this.stateChangelogTopicToTaskIds = new HashMap<InternalTopicConfig, Set<TaskId>>();
        for (TaskId task : partitionsForTask.keySet()) {
            Map<String, InternalTopicConfig> stateChangelogTopics = this.topicGroups.get((Object)Integer.valueOf((int)task.topicGroupId)).stateChangelogTopics;
            for (InternalTopicConfig topic : stateChangelogTopics.values()) {
                Set<TaskId> tasks = this.stateChangelogTopicToTaskIds.get(topic);
                if (tasks == null) {
                    tasks = new HashSet<TaskId>();
                    this.stateChangelogTopicToTaskIds.put(topic, tasks);
                }
                tasks.add(task);
            }
            Map<String, InternalTopicConfig> interSourceTopics = this.topicGroups.get((Object)Integer.valueOf((int)task.topicGroupId)).interSourceTopics;
            for (InternalTopicConfig topic : interSourceTopics.values()) {
                Set<TaskId> tasks = this.internalSourceTopicToTaskIds.get(topic);
                if (tasks == null) {
                    tasks = new HashSet<TaskId>();
                    this.internalSourceTopicToTaskIds.put(topic, tasks);
                }
                tasks.add(task);
            }
        }
        states = TaskAssignor.assign(states, partitionsForTask.keySet(), this.numStandbyReplicas, this.streamThread.getName());
        ArrayList<AssignmentSupplier> assignmentSuppliers = new ArrayList<AssignmentSupplier>();
        HashMap<HostInfo, Set<TopicPartition>> endPointMap = new HashMap<HostInfo, Set<TopicPartition>>();
        for (Map.Entry entry : consumersByClient.entrySet()) {
            UUID processId = (UUID)entry.getKey();
            Set consumers = (Set)entry.getValue();
            ClientState state = (ClientState)states.get(processId);
            ArrayList<TaskId> taskIds = new ArrayList<TaskId>(state.assignedTasks.size());
            int numActiveTasks = state.activeTasks.size();
            for (TaskId taskId : state.activeTasks) {
                taskIds.add(taskId);
            }
            for (TaskId id : state.assignedTasks) {
                if (state.activeTasks.contains(id)) continue;
                taskIds.add(id);
            }
            int numConsumers = consumers.size();
            int i = 0;
            for (String consumer : consumers) {
                HashMap<TaskId, Set<TopicPartition>> standby = new HashMap<TaskId, Set<TopicPartition>>();
                ArrayList<AssignedPartition> assignedPartitions = new ArrayList<AssignedPartition>();
                int numTaskIds = taskIds.size();
                for (int j = i; j < numTaskIds; j += numConsumers) {
                    TaskId taskId = (TaskId)taskIds.get(j);
                    if (j < numActiveTasks) {
                        for (TopicPartition topicPartition : partitionsForTask.get(taskId)) {
                            assignedPartitions.add(new AssignedPartition(taskId, topicPartition));
                        }
                        continue;
                    }
                    HashSet standbyPartitions = (HashSet)standby.get(taskId);
                    if (standbyPartitions == null) {
                        standbyPartitions = new HashSet();
                        standby.put(taskId, standbyPartitions);
                    }
                    standbyPartitions.addAll(partitionsForTask.get(taskId));
                }
                Collections.sort(assignedPartitions);
                ArrayList<TaskId> active = new ArrayList<TaskId>();
                ArrayList<TopicPartition> activePartitions = new ArrayList<TopicPartition>();
                for (AssignedPartition assignedPartition : assignedPartitions) {
                    active.add(assignedPartition.taskId);
                    activePartitions.add(assignedPartition.partition);
                    HostInfo hostInfo = (HostInfo)consumerEndPointMap.get(processId);
                    if (hostInfo == null) continue;
                    if (!endPointMap.containsKey(hostInfo)) {
                        endPointMap.put(hostInfo, new HashSet());
                    }
                    Set topicPartitions = (Set)endPointMap.get(hostInfo);
                    topicPartitions.add(assignedPartition.partition);
                }
                assignmentSuppliers.add(new AssignmentSupplier(consumer, active, standby, endPointMap, activePartitions));
                ++i;
            }
        }
        this.prepareTopic(this.internalSourceTopicToTaskIds, true);
        this.prepareTopic(this.stateChangelogTopicToTaskIds, true);
        HashMap<String, PartitionAssignor.Assignment> assignment = new HashMap<String, PartitionAssignor.Assignment>();
        for (AssignmentSupplier assignmentSupplier : assignmentSuppliers) {
            assignment.put(assignmentSupplier.consumer, assignmentSupplier.get());
        }
        return assignment;
    }

    public void onAssignment(PartitionAssignor.Assignment assignment) {
        ArrayList partitions = new ArrayList(assignment.partitions());
        Collections.sort(partitions, PARTITION_COMPARATOR);
        AssignmentInfo info = AssignmentInfo.decode(assignment.userData());
        this.standbyTasks = info.standbyTasks;
        HashMap<TopicPartition, Set<TaskId>> partitionToTaskIds = new HashMap<TopicPartition, Set<TaskId>>();
        Iterator<TaskId> iter = info.activeTasks.iterator();
        for (TopicPartition partition : partitions) {
            HashSet<TaskId> taskIds = (HashSet<TaskId>)partitionToTaskIds.get(partition);
            if (taskIds == null) {
                taskIds = new HashSet<TaskId>();
                partitionToTaskIds.put(partition, taskIds);
            }
            if (iter.hasNext()) {
                taskIds.add(iter.next());
                continue;
            }
            TaskAssignmentException ex = new TaskAssignmentException(String.format("stream-thread [%s] failed to find a task id for the partition=%s, partitions=%d, assignmentInfo=%s", this.streamThread.getName(), partition.toString(), partitions.size(), info.toString()));
            log.error(ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        this.partitionToTaskIds = partitionToTaskIds;
        this.partitionsByHostState = info.partitionsByHostState;
        if (this.metadataWithInternalTopics == null) {
            Collection<Set<TopicPartition>> values = this.partitionsByHostState.values();
            HashMap<TopicPartition, PartitionInfo> topicToPartitionInfo = new HashMap<TopicPartition, PartitionInfo>();
            for (Set<TopicPartition> value : values) {
                for (TopicPartition topicPartition : value) {
                    topicToPartitionInfo.put(topicPartition, new PartitionInfo(topicPartition.topic(), topicPartition.partition(), null, new Node[0], new Node[0]));
                }
            }
            this.metadataWithInternalTopics = Cluster.empty().withPartitions(topicToPartitionInfo);
        }
    }

    public Map<HostInfo, Set<TopicPartition>> getPartitionsByHostState() {
        if (this.partitionsByHostState == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.partitionsByHostState);
    }

    public Cluster clusterMetadata() {
        if (this.metadataWithInternalTopics == null) {
            return Cluster.empty();
        }
        return this.metadataWithInternalTopics;
    }

    private void ensureCopartitioning(Collection<Set<String>> copartitionGroups, Map<Integer, Collection<InternalTopicConfig>> internalTopicGroups, Cluster metadata) {
        HashMap<String, InternalTopicConfig> internalTopics = new HashMap<String, InternalTopicConfig>();
        for (Collection<InternalTopicConfig> collection : internalTopicGroups.values()) {
            for (InternalTopicConfig topic : collection) {
                internalTopics.put(topic.name(), topic);
            }
        }
        for (Set set : copartitionGroups) {
            this.ensureCopartitioning(set, (Map<String, InternalTopicConfig>)internalTopics, metadata);
        }
    }

    private void ensureCopartitioning(Set<String> copartitionGroup, Map<String, InternalTopicConfig> internalTopics, Cluster metadata) {
        int numPartitions = -1;
        for (String string : copartitionGroup) {
            if (internalTopics.containsKey(string)) continue;
            List infos = metadata.partitionsForTopic(string);
            if (infos == null) {
                throw new TopologyBuilderException(String.format("stream-thread [%s] External source topic not found: %s", this.streamThread.getName(), string));
            }
            if (numPartitions == -1) {
                numPartitions = infos.size();
                continue;
            }
            if (numPartitions == infos.size()) continue;
            Object[] topics = copartitionGroup.toArray(new String[copartitionGroup.size()]);
            Arrays.sort(topics);
            throw new TopologyBuilderException(String.format("stream-thread [%s] Topics not copartitioned: [%s]", this.streamThread.getName(), Utils.mkString(Arrays.asList(topics), (String)",")));
        }
        if (numPartitions == -1) {
            for (InternalTopicConfig internalTopicConfig : internalTopics.values()) {
                Integer partitions;
                if (!copartitionGroup.contains(internalTopicConfig.name()) || (partitions = metadata.partitionCountForTopic(internalTopicConfig.name())) == null || partitions <= numPartitions) continue;
                numPartitions = partitions;
            }
        }
        for (InternalTopicConfig internalTopicConfig : internalTopics.values()) {
            if (!copartitionGroup.contains(internalTopicConfig.name())) continue;
            this.internalSourceTopicToTaskIds.put(internalTopicConfig, Collections.singleton(new TaskId(-1, numPartitions)));
        }
    }

    public Set<TaskId> tasksForState(String stateName) {
        String changeLogName = ProcessorStateManager.storeChangelogTopic(this.streamThread.applicationId, stateName);
        for (InternalTopicConfig internalTopicConfig : this.stateChangelogTopicToTaskIds.keySet()) {
            if (!internalTopicConfig.name().equals(changeLogName)) continue;
            return this.stateChangelogTopicToTaskIds.get(internalTopicConfig);
        }
        return Collections.emptySet();
    }

    public Set<TaskId> tasksForPartition(TopicPartition partition) {
        return this.partitionToTaskIds.get(partition);
    }

    public Map<TaskId, Set<TopicPartition>> standbyTasks() {
        return this.standbyTasks;
    }

    public void setInternalTopicManager(InternalTopicManager internalTopicManager) {
        this.internalTopicManager = internalTopicManager;
    }

    public static class SubscriptionUpdates {
        private final Set<String> updatedTopicSubscriptions = new HashSet<String>();

        private void updateTopics(Collection<String> topicNames) {
            this.updatedTopicSubscriptions.clear();
            this.updatedTopicSubscriptions.addAll(topicNames);
        }

        public Collection<String> getUpdates() {
            return Collections.unmodifiableSet(new HashSet<String>(this.updatedTopicSubscriptions));
        }

        public boolean hasUpdates() {
            return !this.updatedTopicSubscriptions.isEmpty();
        }

        public String toString() {
            return "SubscriptionUpdates{updatedTopicSubscriptions=" + this.updatedTopicSubscriptions + '}';
        }
    }

    class AssignmentSupplier {
        private final String consumer;
        private final List<TaskId> active;
        private final Map<TaskId, Set<TopicPartition>> standby;
        private final Map<HostInfo, Set<TopicPartition>> endPointMap;
        private final List<TopicPartition> activePartitions;

        AssignmentSupplier(String consumer, List<TaskId> active, Map<TaskId, Set<TopicPartition>> standby, Map<HostInfo, Set<TopicPartition>> endPointMap, List<TopicPartition> activePartitions) {
            this.consumer = consumer;
            this.active = active;
            this.standby = standby;
            this.endPointMap = endPointMap;
            this.activePartitions = activePartitions;
        }

        PartitionAssignor.Assignment get() {
            return new PartitionAssignor.Assignment(this.activePartitions, new AssignmentInfo(this.active, this.standby, this.endPointMap).encode());
        }
    }

    private static class AssignedPartition
    implements Comparable<AssignedPartition> {
        public final TaskId taskId;
        public final TopicPartition partition;

        public AssignedPartition(TaskId taskId, TopicPartition partition) {
            this.taskId = taskId;
            this.partition = partition;
        }

        @Override
        public int compareTo(AssignedPartition that) {
            return PARTITION_COMPARATOR.compare(this.partition, that.partition);
        }
    }
}

