/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayDeque;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.MinTimestampTracker;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.processor.internals.StampedRecord;
import org.apache.kafka.streams.processor.internals.TimestampTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordQueue {
    private static final Logger log = LoggerFactory.getLogger(RecordQueue.class);
    private final SourceNode source;
    private final TopicPartition partition;
    private final ArrayDeque<StampedRecord> fifoQueue;
    private final TimestampTracker<ConsumerRecord<Object, Object>> timeTracker;
    private long partitionTime = -1L;

    public RecordQueue(TopicPartition partition, SourceNode source) {
        this.partition = partition;
        this.source = source;
        this.fifoQueue = new ArrayDeque();
        this.timeTracker = new MinTimestampTracker<ConsumerRecord<Object, Object>>();
    }

    public SourceNode source() {
        return this.source;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public int addRawRecords(Iterable<ConsumerRecord<byte[], byte[]>> rawRecords, TimestampExtractor timestampExtractor) {
        for (ConsumerRecord<byte[], byte[]> rawRecord : rawRecords) {
            Object value;
            Object key;
            try {
                key = this.source.deserializeKey(rawRecord.topic(), (byte[])rawRecord.key());
            }
            catch (Exception e) {
                throw new StreamsException(String.format("Failed to deserialize key for record. topic=%s, partition=%d, offset=%d", rawRecord.topic(), rawRecord.partition(), rawRecord.offset()), e);
            }
            try {
                value = this.source.deserializeValue(rawRecord.topic(), (byte[])rawRecord.value());
            }
            catch (Exception e) {
                throw new StreamsException(String.format("Failed to deserialize value for record. topic=%s, partition=%d, offset=%d", rawRecord.topic(), rawRecord.partition(), rawRecord.offset()), e);
            }
            ConsumerRecord record = new ConsumerRecord(rawRecord.topic(), rawRecord.partition(), rawRecord.offset(), rawRecord.timestamp(), TimestampType.CREATE_TIME, rawRecord.checksum(), rawRecord.serializedKeySize(), rawRecord.serializedValueSize(), key, value);
            long timestamp = timestampExtractor.extract((ConsumerRecord<Object, Object>)record);
            log.trace("Source node {} extracted timestamp {} for record {} when adding to buffered queue", new Object[]{this.source.name(), timestamp, record});
            if (timestamp < 0L) {
                throw new StreamsException("Extracted timestamp value is negative, which is not allowed.");
            }
            StampedRecord stampedRecord = new StampedRecord((ConsumerRecord<Object, Object>)record, timestamp);
            this.fifoQueue.addLast(stampedRecord);
            this.timeTracker.addElement(stampedRecord);
        }
        long timestamp = this.timeTracker.get();
        if (timestamp > this.partitionTime) {
            this.partitionTime = timestamp;
        }
        return this.size();
    }

    public StampedRecord poll() {
        StampedRecord elem = this.fifoQueue.pollFirst();
        if (elem == null) {
            return null;
        }
        this.timeTracker.removeElement(elem);
        long timestamp = this.timeTracker.get();
        if (timestamp > this.partitionTime) {
            this.partitionTime = timestamp;
        }
        return elem;
    }

    public int size() {
        return this.fifoQueue.size();
    }

    public boolean isEmpty() {
        return this.fifoQueue.isEmpty();
    }

    public long timestamp() {
        return this.partitionTime;
    }
}

