/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.CachedStateStore;

public class KTableReduce<K, V>
implements KTableProcessorSupplier<K, V, V> {
    private final String storeName;
    private final Reducer<V> addReducer;
    private final Reducer<V> removeReducer;
    private boolean sendOldValues = false;

    public KTableReduce(String storeName, Reducer<V> addReducer, Reducer<V> removeReducer) {
        this.storeName = storeName;
        this.addReducer = addReducer;
        this.removeReducer = removeReducer;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableReduceProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        return new KTableValueGetterSupplier<K, V>(){

            @Override
            public KTableValueGetter<K, V> get() {
                return new KTableAggregateValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KTableReduce.this.storeName};
            }
        };
    }

    private class KTableAggregateValueGetter
    implements KTableValueGetter<K, V> {
        private KeyValueStore<K, V> store;

        private KTableAggregateValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.store = (KeyValueStore)context.getStateStore(KTableReduce.this.storeName);
        }

        @Override
        public V get(K key) {
            return this.store.get(key);
        }
    }

    private class KTableReduceProcessor
    extends AbstractProcessor<K, Change<V>> {
        private KeyValueStore<K, V> store;

        private KTableReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (KeyValueStore)context.getStateStore(KTableReduce.this.storeName);
            ((CachedStateStore)((Object)this.store)).setFlushListener(new ForwardingCacheFlushListener(context, KTableReduce.this.sendOldValues));
        }

        @Override
        public void process(K key, Change<V> value) {
            Object oldAgg;
            if (key == null) {
                throw new StreamsException("Record key for KTable reduce operator with state " + KTableReduce.this.storeName + " should not be null.");
            }
            Object newAgg = oldAgg = this.store.get(key);
            if (value.newValue != null) {
                newAgg = newAgg == null ? value.newValue : KTableReduce.this.addReducer.apply(newAgg, value.newValue);
            }
            if (value.oldValue != null) {
                newAgg = KTableReduce.this.removeReducer.apply(newAgg, value.oldValue);
            }
            this.store.put(key, newAgg);
        }
    }
}

