/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.telemetry.ClientTelemetryPayload;
import org.apache.kafka.server.telemetry.ClientTelemetryReceiver;

public class ClientMetricsTestUtils {
    public static final String DEFAULT_METRICS = "org.apache.kafka.client.producer.partition.queue.,org.apache.kafka.client.producer.partition.latency";
    public static final int DEFAULT_PUSH_INTERVAL_MS = 30000;
    public static final List<String> DEFAULT_CLIENT_MATCH_PATTERNS = Collections.unmodifiableList(Arrays.asList("client_software_name=apache-kafka-java", "client_software_version=3.5.*"));
    public static final int CLIENT_PORT = 56078;

    public static Properties defaultProperties() {
        Properties props = new Properties();
        props.put("metrics", DEFAULT_METRICS);
        props.put("interval.ms", Integer.toString(30000));
        props.put("match", String.join((CharSequence)",", DEFAULT_CLIENT_MATCH_PATTERNS));
        return props;
    }

    public static RequestContext requestContext() throws UnknownHostException {
        return new RequestContext(new RequestHeader(ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS, 0, "producer-1", 0), "1", InetAddress.getLocalHost(), Optional.of(56078), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("apache-kafka-java", "3.5.2"), false);
    }

    public static RequestContext requestContextWithNullClientInfo() throws UnknownHostException {
        return new RequestContext(new RequestHeader(ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS, 0, "producer-1", 0), "1", InetAddress.getLocalHost(), Optional.of(56078), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, null, false);
    }

    public static class TestClientMetricsReceiver
    implements ClientTelemetryReceiver {
        public int exportMetricsInvokedCount = 0;
        public List<ByteBuffer> metricsData = new ArrayList<ByteBuffer>();

        public void exportMetrics(AuthorizableRequestContext context, ClientTelemetryPayload payload) {
            ++this.exportMetricsInvokedCount;
            this.metricsData.add(payload.data());
        }
    }
}

