/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.net.UnknownHostException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.metrics.ClientMetricsInstance;
import org.apache.kafka.server.metrics.ClientMetricsInstanceMetadata;
import org.apache.kafka.server.metrics.ClientMetricsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientMetricsInstanceTest {
    private ClientMetricsInstance clientInstance;

    @BeforeEach
    public void setUp() throws UnknownHostException {
        Uuid uuid = Uuid.randomUuid();
        ClientMetricsInstanceMetadata instanceMetadata = new ClientMetricsInstanceMetadata(uuid, ClientMetricsTestUtils.requestContext());
        this.clientInstance = new ClientMetricsInstance(uuid, instanceMetadata, 0, 0, null, 300000);
    }

    @Test
    public void testMaybeUpdateRequestTimestampValid() {
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdateGetRequestTimestamp(System.currentTimeMillis()));
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdatePushRequestTimestamp(System.currentTimeMillis()));
    }

    @Test
    public void testMaybeUpdateGetRequestAfterElapsedTimeValid() {
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdateGetRequestTimestamp(System.currentTimeMillis() - 300000L));
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdateGetRequestTimestamp(System.currentTimeMillis()));
    }

    @Test
    public void testMaybeUpdateGetRequestWithImmediateRetryFail() {
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdateGetRequestTimestamp(System.currentTimeMillis()));
        Assertions.assertFalse((boolean)this.clientInstance.maybeUpdateGetRequestTimestamp(System.currentTimeMillis()));
    }

    @Test
    public void testMaybeUpdatePushRequestAfterElapsedTimeValid() {
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdatePushRequestTimestamp(System.currentTimeMillis() - 300000L));
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdatePushRequestTimestamp(System.currentTimeMillis()));
    }

    @Test
    public void testMaybeUpdateGetRequestWithImmediateRetryAfterPushFail() {
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdatePushRequestTimestamp(System.currentTimeMillis()));
        Assertions.assertFalse((boolean)this.clientInstance.maybeUpdateGetRequestTimestamp(System.currentTimeMillis() + 1L));
    }

    @Test
    public void testMaybeUpdatePushRequestWithImmediateRetryFail() {
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdatePushRequestTimestamp(System.currentTimeMillis()));
        Assertions.assertFalse((boolean)this.clientInstance.maybeUpdatePushRequestTimestamp(System.currentTimeMillis()));
    }

    @Test
    public void testMaybeUpdatePushRequestWithImmediateRetryAfterGetValid() {
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdatePushRequestTimestamp(System.currentTimeMillis() - 300000L));
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdateGetRequestTimestamp(System.currentTimeMillis()));
        Assertions.assertTrue((boolean)this.clientInstance.maybeUpdatePushRequestTimestamp(System.currentTimeMillis() + 1L));
    }
}

