/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.message.PushTelemetryRequestData;
import org.apache.kafka.common.requests.PushTelemetryRequest;
import org.apache.kafka.server.metrics.ClientMetricsReceiverPlugin;
import org.apache.kafka.server.metrics.ClientMetricsTestUtils;
import org.apache.kafka.server.telemetry.ClientTelemetryReceiver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientMetricsReceiverPluginTest {
    private ClientMetricsTestUtils.TestClientMetricsReceiver telemetryReceiver;
    private ClientMetricsReceiverPlugin clientMetricsReceiverPlugin;

    @BeforeEach
    public void setUp() {
        this.telemetryReceiver = new ClientMetricsTestUtils.TestClientMetricsReceiver();
        this.clientMetricsReceiverPlugin = new ClientMetricsReceiverPlugin();
    }

    @Test
    public void testExportMetrics() throws UnknownHostException {
        Assertions.assertTrue((boolean)this.clientMetricsReceiverPlugin.isEmpty());
        this.clientMetricsReceiverPlugin.add((ClientTelemetryReceiver)this.telemetryReceiver);
        Assertions.assertFalse((boolean)this.clientMetricsReceiverPlugin.isEmpty());
        Assertions.assertEquals((int)0, (int)this.telemetryReceiver.exportMetricsInvokedCount);
        Assertions.assertTrue((boolean)this.telemetryReceiver.metricsData.isEmpty());
        byte[] metrics = "test-metrics".getBytes(StandardCharsets.UTF_8);
        this.clientMetricsReceiverPlugin.exportMetrics(ClientMetricsTestUtils.requestContext(), (PushTelemetryRequest)new PushTelemetryRequest.Builder(new PushTelemetryRequestData().setMetrics(metrics), true).build());
        Assertions.assertEquals((int)1, (int)this.telemetryReceiver.exportMetricsInvokedCount);
        Assertions.assertEquals((int)1, (int)this.telemetryReceiver.metricsData.size());
        Assertions.assertEquals((Object)metrics, (Object)this.telemetryReceiver.metricsData.get(0).array());
    }
}

