/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Arrays;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.server.Assignment;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TopicIdPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AssignmentTest {
    private static final MetadataImage TEST_IMAGE;

    @Test
    public void testValidAssignment() {
        Assertions.assertTrue((boolean)new Assignment(new TopicIdPartition(Uuid.fromString((String)"rTudty6ITOCcO_ldVyzZYg"), 0), Uuid.fromString((String)"rzRT8XZaSbKsP6j238zogg"), 0L, (Runnable)NoOpRunnable.INSTANCE).valid(0, TEST_IMAGE));
    }

    @Test
    public void testAssignmentForNonExistentTopicIsNotValid() {
        Assertions.assertFalse((boolean)new Assignment(new TopicIdPartition(Uuid.fromString((String)"uuOi4qGPSsuM0QwnYINvOw"), 0), Uuid.fromString((String)"rzRT8XZaSbKsP6j238zogg"), 0L, (Runnable)NoOpRunnable.INSTANCE).valid(0, TEST_IMAGE));
    }

    @Test
    public void testAssignmentForNonExistentPartitionIsNotValid() {
        Assertions.assertFalse((boolean)new Assignment(new TopicIdPartition(Uuid.fromString((String)"rTudty6ITOCcO_ldVyzZYg"), 2), Uuid.fromString((String)"rzRT8XZaSbKsP6j238zogg"), 0L, (Runnable)NoOpRunnable.INSTANCE).valid(0, TEST_IMAGE));
    }

    @Test
    public void testAssignmentReplicaNotOnBrokerIsNotValid() {
        Assertions.assertFalse((boolean)new Assignment(new TopicIdPartition(Uuid.fromString((String)"rTudty6ITOCcO_ldVyzZYg"), 0), Uuid.fromString((String)"rzRT8XZaSbKsP6j238zogg"), 0L, (Runnable)NoOpRunnable.INSTANCE).valid(3, TEST_IMAGE));
    }

    @Test
    public void testAssignmentToString() {
        Assertions.assertEquals((Object)"Assignment(topicIdPartition=rTudty6ITOCcO_ldVyzZYg:1, directoryId=rzRT8XZaSbKsP6j238zogg, submissionTimeNs=123, successCallback=NoOpRunnable)", (Object)new Assignment(new TopicIdPartition(Uuid.fromString((String)"rTudty6ITOCcO_ldVyzZYg"), 1), Uuid.fromString((String)"rzRT8XZaSbKsP6j238zogg"), 123L, (Runnable)NoOpRunnable.INSTANCE).toString());
    }

    static {
        MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
        delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_8_IV0.featureLevel()));
        delta.replay(new TopicRecord().setName("foo").setTopicId(Uuid.fromString((String)"rTudty6ITOCcO_ldVyzZYg")));
        delta.replay(new PartitionRecord().setPartitionId(0).setTopicId(Uuid.fromString((String)"rTudty6ITOCcO_ldVyzZYg")).setReplicas(Arrays.asList(0, 1, 2)).setIsr(Arrays.asList(0, 1, 2)).setLeader(1));
        delta.replay(new PartitionRecord().setPartitionId(1).setTopicId(Uuid.fromString((String)"rTudty6ITOCcO_ldVyzZYg")).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1));
        TEST_IMAGE = delta.apply(MetadataProvenance.EMPTY);
    }

    static class NoOpRunnable
    implements Runnable {
        static final NoOpRunnable INSTANCE = new NoOpRunnable();

        NoOpRunnable() {
        }

        @Override
        public void run() {
        }

        public String toString() {
            return "NoOpRunnable";
        }
    }
}

