/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.Objects;
import java.util.concurrent.locks.Lock;

public class LockUtils {
    public static <T, E extends Exception> T inLock(Lock lock, ThrowingSupplier<T, E> supplier) throws E {
        Objects.requireNonNull(lock, "Lock must not be null");
        Objects.requireNonNull(supplier, "Supplier must not be null");
        lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public static <E extends Exception> void inLock(Lock lock, ThrowingRunnable<E> runnable) throws E {
        Objects.requireNonNull(lock, "Lock must not be null");
        Objects.requireNonNull(runnable, "Runnable must not be null");
        lock.lock();
        try {
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

