/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;
import org.apache.kafka.metadata.ScramCredentialData;

public class ScramCredentialDataNode
implements MetadataNode {
    private final ScramCredentialData data;

    public ScramCredentialDataNode(ScramCredentialData data) {
        this.data = data;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    private static void arrayToHex(byte[] array, StringBuilder bld) {
        for (int i = 0; i < array.length; ++i) {
            bld.append(String.format("%02x", array[i] & 0xFF));
        }
    }

    @Override
    public void print(MetadataNodePrinter printer) {
        StringBuilder bld = new StringBuilder();
        bld.append("ScramCredentialData");
        bld.append("(salt=");
        if (printer.redactionCriteria().shouldRedactScram()) {
            bld.append("[redacted]");
        } else {
            ScramCredentialDataNode.arrayToHex(this.data.salt(), bld);
        }
        bld.append(", storedKey=");
        if (printer.redactionCriteria().shouldRedactScram()) {
            bld.append("[redacted]");
        } else {
            ScramCredentialDataNode.arrayToHex(this.data.storedKey(), bld);
        }
        bld.append(", serverKey=");
        if (printer.redactionCriteria().shouldRedactScram()) {
            bld.append("[redacted]");
        } else {
            ScramCredentialDataNode.arrayToHex(this.data.serverKey(), bld);
        }
        bld.append(", iterations=");
        if (printer.redactionCriteria().shouldRedactScram()) {
            bld.append("[redacted]");
        } else {
            bld.append(this.data.iterations());
        }
        bld.append(")");
        printer.output(bld.toString());
    }
}

