/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.security.SecureRandom;

public class UniqueIdGenerator {
    private int count = 0;
    private long previousTimeMilliseconds = 0L;
    private static int serverId;
    private static final int IDS_PER_MILLISECONDS = 1000;

    public long generate(long currentTimeMilliseconds, int nodeId) {
        ++this.count;
        if (this.count >= this.idsPerMilliseconds()) {
            this.count = 0;
        }
        if (currentTimeMilliseconds > this.previousTimeMilliseconds) {
            this.count = 0;
            this.previousTimeMilliseconds = currentTimeMilliseconds;
        }
        return currentTimeMilliseconds * 100000L + (long)(this.count * 100) + (long)nodeId;
    }

    public long generate(long currentTimestamp) {
        return this.generate(currentTimestamp, serverId);
    }

    protected int serverId() {
        return serverId;
    }

    protected int idsPerMilliseconds() {
        return 1000;
    }

    static {
        SecureRandom random = new SecureRandom();
        serverId = Math.abs(random.nextInt()) % 100;
    }
}

