/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Utils;

public class ProduceRequest
extends AbstractRequest {
    public static final short LAST_STABLE_VERSION_BEFORE_TRANSACTION_V2 = 11;
    private final short acks;
    private final int timeout;
    private final String transactionalId;
    private volatile ProduceRequestData data;
    private volatile Map<TopicIdPartition, Integer> partitionSizes;

    public static Builder builder(ProduceRequestData data, boolean useTransactionV1Version) {
        short maxVersion = useTransactionV1Version ? (short)11 : (short)ApiKeys.PRODUCE.latestVersion();
        return new Builder(ApiKeys.PRODUCE.oldestVersion(), maxVersion, data);
    }

    public static Builder builder(ProduceRequestData data) {
        return ProduceRequest.builder(data, false);
    }

    public ProduceRequest(ProduceRequestData produceRequestData, short version) {
        super(ApiKeys.PRODUCE, version);
        this.data = produceRequestData;
        this.acks = this.data.acks();
        this.timeout = this.data.timeoutMs();
        this.transactionalId = this.data.transactionalId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<TopicIdPartition, Integer> partitionSizes() {
        if (this.partitionSizes == null) {
            ProduceRequest produceRequest = this;
            synchronized (produceRequest) {
                if (this.partitionSizes == null) {
                    HashMap<TopicIdPartition, Integer> tmpPartitionSizes = new HashMap<TopicIdPartition, Integer>();
                    this.data.topicData().forEach(topicData -> topicData.partitionData().forEach(partitionData -> tmpPartitionSizes.compute(new TopicIdPartition(topicData.topicId(), partitionData.index(), topicData.name()), (ignored, previousValue) -> partitionData.records().sizeInBytes() + (previousValue == null ? 0 : previousValue))));
                    this.partitionSizes = tmpPartitionSizes;
                }
            }
        }
        return this.partitionSizes;
    }

    @Override
    public ProduceRequestData data() {
        ProduceRequestData tmp = this.data;
        if (tmp == null) {
            throw new IllegalStateException("The partition records are no longer available because clearPartitionRecords() has been invoked.");
        }
        return tmp;
    }

    @Override
    public String toString(boolean verbose) {
        StringBuilder bld = new StringBuilder();
        bld.append("{acks=").append(this.acks).append(",timeout=").append(this.timeout);
        if (verbose) {
            bld.append(",partitionSizes=").append(Utils.mkString(this.partitionSizes(), "[", "]", "=", ","));
        } else {
            bld.append(",numPartitions=").append(this.partitionSizes().size());
        }
        bld.append("}");
        return bld.toString();
    }

    @Override
    public ProduceResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        if (this.acks == 0) {
            return null;
        }
        ApiError apiError = ApiError.fromThrowable(e);
        ProduceResponseData data = new ProduceResponseData().setThrottleTimeMs(throttleTimeMs);
        this.partitionSizes().forEach((tpId, ignored) -> {
            ProduceResponseData.TopicProduceResponse tpr = data.responses().find(tpId.topic(), tpId.topicId());
            if (tpr == null) {
                tpr = new ProduceResponseData.TopicProduceResponse().setName(tpId.topic()).setTopicId(tpId.topicId());
                data.responses().add(tpr);
            }
            tpr.partitionResponses().add(new ProduceResponseData.PartitionProduceResponse().setIndex(tpId.partition()).setRecordErrors(Collections.emptyList()).setBaseOffset(-1L).setLogAppendTimeMs(-1L).setLogStartOffset(-1L).setErrorMessage(apiError.message()).setErrorCode(apiError.error().code()));
        });
        return new ProduceResponse(data);
    }

    @Override
    public Map<Errors, Integer> errorCounts(Throwable e) {
        Errors error = Errors.forException(e);
        return Collections.singletonMap(error, this.partitionSizes().size());
    }

    public short acks() {
        return this.acks;
    }

    public int timeout() {
        return this.timeout;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public void clearPartitionRecords() {
        this.partitionSizes();
        this.data = null;
    }

    public static void validateRecords(short version, BaseRecords baseRecords) {
        if (baseRecords instanceof Records) {
            Records records = (Records)baseRecords;
            Iterator<? extends RecordBatch> iterator = records.batches().iterator();
            if (!iterator.hasNext()) {
                throw new InvalidRecordException("Produce requests with version " + version + " must have at least one record batch per partition");
            }
            RecordBatch entry = iterator.next();
            if (entry.magic() != 2) {
                throw new InvalidRecordException("Produce requests with version " + version + " are only allowed to contain record batches with magic version 2");
            }
            if (version < 7 && entry.compressionType() == CompressionType.ZSTD) {
                throw new UnsupportedCompressionTypeException("Produce requests with version " + version + " are not allowed to use ZStandard compression");
            }
            if (iterator.hasNext()) {
                throw new InvalidRecordException("Produce requests with version " + version + " are only allowed to contain exactly one record batch per partition");
            }
        }
    }

    public static ProduceRequest parse(Readable readable, short version, MessageContext context) {
        return new ProduceRequest(new ProduceRequestData(readable, version, context), version);
    }

    public static boolean isTransactionV2Requested(short version) {
        return version > 11;
    }

    public static class Builder
    extends AbstractRequest.Builder<ProduceRequest> {
        private final ProduceRequestData data;

        public Builder(short minVersion, short maxVersion, ProduceRequestData data) {
            super(ApiKeys.PRODUCE, minVersion, maxVersion);
            this.data = data;
        }

        @Override
        public ProduceRequest build(short version) {
            this.data.topicData().forEach(tpd -> tpd.partitionData().forEach(partitionProduceData -> ProduceRequest.validateRecords(version, partitionProduceData.records())));
            return new ProduceRequest(this.data, version);
        }

        public String toString() {
            return "(type=ProduceRequest, acks=" + this.data.acks() + ", timeout=" + this.data.timeoutMs() + ", partitionRecords=(" + String.valueOf(this.data.topicData().stream().flatMap(d -> d.partitionData().stream()).collect(Collectors.toList())) + "), transactionalId='" + (this.data.transactionalId() != null ? this.data.transactionalId() : "") + "'";
        }
    }
}

