/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterClusterLinksResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<AlterClusterLinkResult> alterClusterLinkResults;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the request succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if request operation succeeded."), new Field("alter_cluster_link_results", new CompactArrayOf(AlterClusterLinkResult.SCHEMA_0), "The results of the alter cluster link operation."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterClusterLinksResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterClusterLinksResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.alterClusterLinkResults = new ArrayList<AlterClusterLinkResult>(0);
    }

    @Override
    public short apiKey() {
        return 10043;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field alterClusterLinkResults was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<AlterClusterLinkResult> newCollection = new ArrayList<AlterClusterLinkResult>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new AlterClusterLinkResult(_readable, _version, _context));
        }
        this.alterClusterLinkResults = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeUnsignedVarint(this.alterClusterLinkResults.size() + 1);
        _stringBytes = this.alterClusterLinkResults.iterator();
        while (_stringBytes.hasNext()) {
            AlterClusterLinkResult alterClusterLinkResultsElement = (AlterClusterLinkResult)_stringBytes.next();
            alterClusterLinkResultsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.alterClusterLinkResults.size() + 1));
        for (AlterClusterLinkResult alterClusterLinkResultsElement : this.alterClusterLinkResults) {
            alterClusterLinkResultsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterClusterLinksResponseData)) {
            return false;
        }
        AlterClusterLinksResponseData other = (AlterClusterLinksResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.alterClusterLinkResults == null ? other.alterClusterLinkResults != null : !this.alterClusterLinkResults.equals(other.alterClusterLinkResults)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.alterClusterLinkResults == null ? 0 : this.alterClusterLinkResults.hashCode());
        return hashCode;
    }

    @Override
    public AlterClusterLinksResponseData duplicate() {
        AlterClusterLinksResponseData _duplicate = new AlterClusterLinksResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<AlterClusterLinkResult> newAlterClusterLinkResults = new ArrayList<AlterClusterLinkResult>(this.alterClusterLinkResults.size());
        for (AlterClusterLinkResult _element : this.alterClusterLinkResults) {
            newAlterClusterLinkResults.add(_element.duplicate());
        }
        _duplicate.alterClusterLinkResults = newAlterClusterLinkResults;
        return _duplicate;
    }

    public String toString() {
        return "AlterClusterLinksResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", alterClusterLinkResults=" + MessageUtil.deepToString(this.alterClusterLinkResults.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<AlterClusterLinkResult> alterClusterLinkResults() {
        return this.alterClusterLinkResults;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterClusterLinksResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AlterClusterLinksResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public AlterClusterLinksResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public AlterClusterLinksResponseData setAlterClusterLinkResults(List<AlterClusterLinkResult> v) {
        this.alterClusterLinkResults = v;
        return this;
    }

    public static class AlterClusterLinkResult
    implements Message {
        short errorCode;
        String errorMessage;
        Uuid linkId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if alter operation succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if alter cluster link operation succeeded."), new Field("link_id", Type.UUID, "The ID of the link being altered."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public AlterClusterLinkResult(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AlterClusterLinkResult() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.linkId = Uuid.ZERO_UUID;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterClusterLinkResult");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this.linkId = _readable.readUuid();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUuid(this.linkId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterClusterLinkResult");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(16);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterClusterLinkResult)) {
                return false;
            }
            AlterClusterLinkResult other = (AlterClusterLinkResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (!this.linkId.equals(other.linkId)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + this.linkId.hashCode();
            return hashCode;
        }

        @Override
        public AlterClusterLinkResult duplicate() {
            AlterClusterLinkResult _duplicate = new AlterClusterLinkResult();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.linkId = this.linkId;
            return _duplicate;
        }

        public String toString() {
            return "AlterClusterLinkResult(errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", linkId=" + this.linkId.toString() + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public Uuid linkId() {
            return this.linkId;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterClusterLinkResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public AlterClusterLinkResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public AlterClusterLinkResult setLinkId(Uuid v) {
            this.linkId = v;
            return this;
        }
    }
}

